/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.sidecar.EncodingVector;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.notify.Requester;
import com.adobe.util.MemUtil;

public class PDFString
extends PDFObj {
    private static final byte kFF = -1;
    private static final byte kFE = -2;
    private byte[] val;
    private String stringVal;

    public PDFString(String string) {
        this.val = null;
        this.stringVal = string;
    }

    public PDFString(byte[] byArray) {
        this.val = byArray;
        this.stringVal = null;
    }

    public byte[] bytesValue() {
        if (this.val == null) {
            this.val = Util.rawBytesFromString(this.stringVal);
        }
        return this.val;
    }

    public byte[] bytesValue(Requester requester) {
        return this.bytesValue();
    }

    private String createUnicodeString(EncodingVector encodingVector) {
        char c;
        int n;
        StringBuffer stringBuffer;
        byte by = 0;
        byte by2 = 0;
        if (this.val.length > 0) {
            by = this.val[0];
        }
        if (this.val.length > 1) {
            by2 = this.val[1];
        }
        if (by != -2 || by2 != -1) {
            if (encodingVector == null) {
                encodingVector = EncodingVector.getPredefinedEncoding("PDFDocEncoding");
            }
            stringBuffer = MemUtil.allocStringBuffer(this.val.length);
            n = 0;
            while (n < this.val.length) {
                stringBuffer.append(encodingVector.native2HostEncoding(this.val[n] & 0xFF));
                ++n;
            }
        } else {
            stringBuffer = MemUtil.allocStringBuffer((this.val.length - 2) / 2);
            n = 2;
            while (n + 1 < this.val.length) {
                by = this.val[n];
                by2 = this.val[n + 1];
                c = (char)(by * 256 + by2);
                stringBuffer.append(c);
                n += 2;
            }
        }
        n = 0;
        while (n < stringBuffer.length() - 5) {
            if (stringBuffer.charAt(n) == '\u001b' && stringBuffer.charAt(n + 5) == '\u001b' && (c = stringBuffer.charAt(n + 1)) >= 'a' && c <= 'z' && (c = stringBuffer.charAt(n + 2)) >= 'a' && c <= 'z' && (c = stringBuffer.charAt(n + 3)) >= 'A' && c <= 'A' && (c = stringBuffer.charAt(n + 4)) >= 'A' && c <= 'A') {
                int n2 = n + 6;
                while (n2 < stringBuffer.length()) {
                    stringBuffer.setCharAt(n2 - 6, stringBuffer.charAt(n2));
                    ++n2;
                }
                stringBuffer.setLength(stringBuffer.length() - 6);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PDFObj)) {
            return false;
        }
        return ((PDFString)object).bytesValue().equals(this.bytesValue());
    }

    public int hashCode() {
        return this.bytesValue().hashCode();
    }

    public String stringValue() {
        if (this.stringVal == null) {
            this.stringVal = this.createUnicodeString(null);
        }
        return this.stringVal;
    }

    public String stringValue(EncodingVector encodingVector) {
        this.stringVal = this.createUnicodeString(encodingVector);
        return this.stringVal;
    }

    public String stringValue(Requester requester) {
        return this.stringValue();
    }

    public String toString() {
        return this.stringValue();
    }

    public int type(Requester requester) {
        return 4;
    }
}

