/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.pdfobjstore.IllegalIndirectObjRef;
import com.adobe.acrobat.pdfobjstore.IndirectObjectNFExc;
import com.adobe.acrobat.pdfobjstore.PDFNull;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.acrobat.pdfobjstore.security.PDFObjCryptKey;
import com.adobe.acrobat.pdfobjstore.security.PDFObjStoreCryptKey;
import com.adobe.pe.notify.Requester;

public class PDFIndirectObj
extends PDFReference {
    private VPDFObj vResolution;
    private int id;
    private short gen;

    PDFIndirectObj(int n, short s, PDFObjStore pDFObjStore) {
        super(pDFObjStore);
        this.id = n;
        this.gen = s;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PDFIndirectObj)) {
            return false;
        }
        PDFIndirectObj pDFIndirectObj = (PDFIndirectObj)object;
        return this.id == pDFIndirectObj.id && this.gen == pDFIndirectObj.gen && this.store == pDFIndirectObj.store;
    }

    public PDFObjCryptKey getCryptKey(Requester requester) throws Exception {
        PDFObjStoreCryptKey pDFObjStoreCryptKey = this.store.getVPDFObjStoreCryptKey().peObjStoreCryptKeyValue(requester);
        return pDFObjStoreCryptKey == null ? null : new PDFObjCryptKey(pDFObjStoreCryptKey, this.id, this.gen);
    }

    public short getGeneration() {
        return this.gen;
    }

    public int getID() {
        return this.id;
    }

    public int hashCode() {
        return this.id ^ this.gen << 16 ^ this.store.hashCode();
    }

    public PDFObj resolveFromStore(Requester requester) throws Exception {
        if (this.store == null) {
            throw new IllegalIndirectObjRef();
        }
        if (this.vResolution == null) {
            this.vResolution = this.store.createIndirectObjResolution(this);
        }
        try {
            return this.vResolution.pdfObjValue(requester);
        }
        catch (IndirectObjectNFExc indirectObjectNFExc) {
            return PDFNull.getPDFNull();
        }
    }

    public String toString() {
        return String.valueOf(this.id) + " " + this.gen + " R";
    }
}

