/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import java.awt.image.ColorModel;

public class LabColorModel
extends PDFColorModel {
    private float lBase;
    private float lSpread;
    private float aBase;
    private float aSpread;
    private float bBase;
    private float bSpread;
    private float xBase;
    private float xSpread;
    private float yBase;
    private float ySpread;
    private float zBase;
    private float zSpread;

    public LabColorModel() {
        this(new PDFColorParams(4));
    }

    public LabColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams);
        float[] fArray = pDFColorParams.getDecode();
        if (fArray == null) {
            this.lBase = 0.0f;
            this.lSpread = 100.0f;
            this.bBase = -100.0f;
            this.aBase = -100.0f;
            this.bSpread = 200.0f;
            this.aSpread = 200.0f;
        } else {
            this.lBase = fArray[0];
            this.lSpread = fArray[1] - this.lBase;
            this.aBase = fArray[2];
            this.aSpread = fArray[3] - this.aBase;
            this.bBase = fArray[4];
            this.bSpread = fArray[5] - this.bBase;
        }
        this.aBase *= 0.002f;
        this.aSpread *= 0.002f;
        this.bBase *= 0.005f;
        this.bSpread *= 0.005f;
        float[] fArray2 = pDFColorParams.getWhitePt();
        float[] fArray3 = pDFColorParams.getBlackPt();
        this.xBase = fArray3[0];
        this.xSpread = fArray2[0] - this.xBase;
        this.yBase = fArray3[1];
        this.ySpread = fArray2[1] - this.yBase;
        this.zBase = fArray3[2];
        this.zSpread = fArray2[2] - this.zBase;
    }

    public float[] getBlack() {
        float[] fArray = new float[3];
        fArray[2] = 0.0f;
        fArray[1] = 0.0f;
        fArray[0] = 0.0f;
        return fArray;
    }

    public ColorModel getJavaColorModel() {
        return ColorModel.getRGBdefault();
    }

    public int getRGB(float f, float f2, float f3) {
        float f4 = (f + 16.0f) / 116.0f;
        float f5 = f4 + f2 * 0.002f;
        float f6 = f4 - f3 * 0.005f;
        f5 = f5 < 0.2069f ? 0.12842f * (f5 - 0.13793f) : f5 * f5 * f5;
        f4 = f4 < 0.2069f ? 0.12842f * (f4 - 0.13793f) : f4 * f4 * f4;
        f6 = f6 < 0.2069f ? 0.12842f * (f6 - 0.13793f) : f6 * f6 * f6;
        f5 = this.xBase + f5 * this.xSpread;
        f4 = this.yBase + f4 * this.ySpread;
        f6 = this.zBase + f6 * this.zSpread;
        return PDFColorModel.XYZtoRGB(f5, f4, f6);
    }

    public int getRGB(int n) {
        float f = this.lBase + this.lSpread * (float)(n >> 16 & 0xFF) / 255.0f;
        float f2 = this.aBase + this.aSpread * (float)(n >> 8 & 0xFF) / 255.0f;
        float f3 = this.bBase + this.bSpread * (float)(n & 0xFF) / 255.0f;
        return this.getRGB(f, f2 / 0.002f, f3 / 0.005f);
    }

    public int getRGB(float[] fArray) {
        if (fArray.length >= 3) {
            return this.getRGB(fArray[0], fArray[1], fArray[2]);
        }
        throw new RuntimeException("LabColorModel.getRGB(c[]) -- arrayToShort");
    }

    public void toRGB(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        float f = this.lSpread / 255.0f;
        float f2 = this.aSpread / 255.0f;
        float f3 = this.bSpread / 255.0f;
        int[] nArray2 = this.params.getAlphaMask();
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        while (n8 < n3) {
            int n9 = byArray[n] & 0xFF;
            int n10 = byArray[n + 1] & 0xFF;
            int n11 = byArray[n + 2] & 0xFF;
            n += 3;
            if (n9 == n7 && n10 == n6 && n11 == n5) {
                nArray[n2 + n8] = n4;
            } else if (nArray2 != null && nArray2[0] <= n9 && n9 <= nArray2[1] && nArray2[2] <= n10 && n10 <= nArray2[3] && nArray2[4] <= n11 && n11 <= nArray2[5]) {
                n7 = n9;
                n6 = n10;
                n5 = n11;
                n4 = 0;
                nArray[n2 + n8] = 0;
            } else {
                n7 = n9;
                n6 = n10;
                n5 = n11;
                float f4 = this.lBase + f * (float)n9;
                float f5 = this.aBase + f2 * (float)n10;
                float f6 = this.bBase + f3 * (float)n11;
                float f7 = (f4 + 16.0f) / 116.0f;
                float f8 = f7 + f5;
                float f9 = f7 - f6;
                f8 = f8 < 0.2069f ? 0.12842f * (f8 - 0.13793f) : f8 * f8 * f8;
                f7 = f7 < 0.2069f ? 0.12842f * (f7 - 0.13793f) : f7 * f7 * f7;
                f9 = f9 < 0.2069f ? 0.12842f * (f9 - 0.13793f) : f9 * f9 * f9;
                f8 = this.xBase + f8 * this.xSpread;
                f7 = this.yBase + f7 * this.ySpread;
                f9 = this.zBase + f9 * this.zSpread;
                nArray[n2 + n8] = n4 = PDFColorModel.XYZtoRGB(f8, f7, f9);
            }
            ++n8;
        }
    }

    public String toString() {
        return "Lab";
    }
}

