/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.Document;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.VValue;
import com.adobe.util.Assert;

public class VPageTreeNodeProps
extends VValue {
    static final String VPageTreeNodeProps_K = "VPageTreeNodeProps";
    private static ExtensionDataProvider provider = null;
    public static final int kNotInPageTree = -1;
    private static final String Count_K = "Count";
    private static final String Page_K = "Page";
    private static final String Pages_K = "Pages";
    private static final String Parent_K = "Parent";
    private static final String Kids_K = "Kids";
    private PDFReference pageRef;
    private boolean fIsInTree;
    private boolean fIsPage;
    private boolean fIsPageNode;
    private int pageNum;
    private int fNumChildren;

    VPageTreeNodeProps(PDFReference pDFReference) {
        this.pageRef = pDFReference;
    }

    private void buildTreeInfo(PDFDict pDFDict, Requester requester) throws Exception {
        this.pageNum = -1;
        this.fIsInTree = false;
        if (pDFDict.hasKey(Parent_K)) {
            PDFObj pDFObj = pDFDict.get(Parent_K);
            if (pDFObj.type(requester) != 6) {
                return;
            }
            PDFReference pDFReference = pDFObj.pdfReferenceValue(requester);
            VPageTreeNodeProps vPageTreeNodeProps = VPageTreeNodeProps.getVPageTreeNodeProps(pDFReference);
            if (!vPageTreeNodeProps.isInTree(requester) || vPageTreeNodeProps.isPage(requester)) {
                return;
            }
            PDFDict pDFDict2 = pDFReference.dictValue(requester);
            if (pDFDict2.hasKey(Kids_K)) {
                PDFObj pDFObj2 = pDFDict2.get(Kids_K);
                if (pDFObj2.type(requester) != 7) {
                    return;
                }
                int n = vPageTreeNodeProps.numPagesBefore(requester);
                PDFArray pDFArray = pDFObj2.arrayValue(requester);
                int n2 = 0;
                while (n2 < pDFArray.size()) {
                    PDFObj pDFObj3 = pDFArray.get(n2);
                    if (pDFObj3.equals(this.pageRef)) {
                        this.fIsInTree = true;
                        int n3 = n2;
                        while (n3-- > 0) {
                            VPageTreeNodeProps vPageTreeNodeProps2;
                            PDFObj pDFObj4 = pDFArray.get(n3);
                            if (pDFObj4.type(requester) != 6 || !(vPageTreeNodeProps2 = VPageTreeNodeProps.getVPageTreeNodeProps(pDFObj4.pdfReferenceValue(requester))).isInTree(requester)) continue;
                            this.pageNum = vPageTreeNodeProps2.numPagesBefore(requester) + vPageTreeNodeProps2.numChildren(requester);
                            return;
                        }
                        this.pageNum = vPageTreeNodeProps.numPagesBefore(requester);
                    }
                    ++n2;
                }
            }
        } else {
            PDFReference pDFReference;
            PDFObjStore pDFObjStore = this.pageRef.getObjStore();
            if (pDFObjStore != null && (pDFReference = Document.getPageTreeRoot(pDFObjStore).pdfReferenceValue(requester)).equals(this.pageRef)) {
                this.pageNum = 0;
                this.fIsInTree = true;
            }
        }
    }

    protected final void compute(Requester requester) throws Exception {
        String string;
        PDFObj pDFObj;
        PDFObjStore pDFObjStore = this.pageRef.getObjStore();
        this.fIsInTree = false;
        this.fIsPage = false;
        this.fIsPageNode = false;
        if (pDFObjStore == null) {
            return;
        }
        if (this.pageRef.type(requester) != 6) {
            return;
        }
        PDFDict pDFDict = this.pageRef.dictValue(requester);
        if (pDFDict.hasKey("Type")) {
            pDFObj = pDFDict.get("Type");
            if (pDFObj.type(requester) != 5) {
                return;
            }
            string = pDFObj.nameValue(requester);
        } else {
            string = pDFDict.hasKey(Kids_K) ? Pages_K : Page_K;
        }
        if (string.equals(Page_K)) {
            this.fIsPage = true;
            this.fNumChildren = 1;
            this.buildTreeInfo(pDFDict, requester);
        } else if (string.equals(Pages_K)) {
            if (!pDFDict.hasKey(Count_K)) {
                return;
            }
            pDFObj = pDFDict.get(Count_K);
            if (pDFObj.type(requester) != 2) {
                return;
            }
            this.fIsPageNode = true;
            this.fNumChildren = pDFObj.integerValue(requester);
            this.buildTreeInfo(pDFDict, requester);
        }
    }

    public static VPageTreeNodeProps getVPageTreeNodeProps(PDFReference pDFReference) throws Exception {
        VPageTreeNodeProps.initProvider();
        return (VPageTreeNodeProps)pDFReference.getExtensionData(VPageTreeNodeProps_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    if (string.equals(VPageTreeNodeProps.VPageTreeNodeProps_K)) {
                        Assert.notFalse(extensible instanceof PDFReference);
                        return new VPageTreeNodeProps((PDFReference)extensible);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VPageTreeNodeProps_K, provider);
        }
    }

    public boolean isInTree(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.fIsInTree;
    }

    public boolean isPage(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.fIsPage;
    }

    public boolean isPageNode(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.fIsPageNode;
    }

    public int numChildren(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.fNumChildren;
    }

    public int numPagesBefore(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.pageNum;
    }
}

