/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.vtypes.VAffineTransform;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.vtypes.VInt;

public class VPageRotationTransform
extends VAffineTransform {
    private VInt vDegrees;
    private VFloatRect vCropBox;

    VPageRotationTransform(VInt vInt, VFloatRect vFloatRect) {
        this.vDegrees = vInt;
        this.vCropBox = vFloatRect;
    }

    protected AffineTransform computeAffineTransform(Requester requester) throws Exception {
        int n = this.vDegrees.intValue(requester);
        FloatRect floatRect = this.vCropBox.floatRectValue(requester);
        if (n < 0) {
            n = 180 - n;
        }
        if ((n %= 360) % 90 != 0) {
            throw new Exception("Illegal page rotation");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        switch (n) {
            case 0: {
                d = 1.0;
                d4 = -1.0;
                d5 = -floatRect.getxMin();
                d6 = floatRect.getyMax();
                break;
            }
            case 90: {
                d2 = 1.0;
                d3 = 1.0;
                d5 = -floatRect.getyMin();
                d6 = -floatRect.getxMin();
                break;
            }
            case 180: {
                d = -1.0;
                d4 = 1.0;
                d5 = floatRect.getxMax();
                d6 = -floatRect.getyMin();
                break;
            }
            case 270: {
                d2 = -1.0;
                d3 = -1.0;
                d5 = floatRect.getyMax();
                d6 = floatRect.getxMax();
                break;
            }
        }
        return new AffineTransform(d, d2, d3, d4, d5, d6);
    }
}

