/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.AnnotBorderProps;
import com.adobe.acrobat.pdf.VAnnotBorderPropsProvider;
import com.adobe.acrobat.pdf.VPDFColorValue;
import com.adobe.acrobat.pdf.VPDFDashArray;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.vtypes.VColorValue;
import com.adobe.acrobat.vtypes.VDashArray;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.VValue;

public class VAnnotBorderProps
extends VValue {
    static final String VAnnotBorderProps_K = "VAnnotBorderProps";
    private static VAnnotBorderPropsProvider provider = null;
    private static final String Border_K = "Border";
    private static final String BS_K = "BS";
    private static final String C_K = "C";
    private static final String D_K = "D";
    private static final String S_K = "S";
    private static final String W_K = "W";
    private PDFReference annotRef;
    private AnnotBorderProps props;

    VAnnotBorderProps(PDFReference pDFReference) {
        this.annotRef = pDFReference;
    }

    public AnnotBorderProps annotBorderPropsValue(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.props;
    }

    protected void compute(Requester requester) throws Exception {
        Object object;
        this.props = new AnnotBorderProps();
        PDFDict pDFDict = this.annotRef.dictValue(requester);
        if (pDFDict.hasKey(C_K)) {
            object = VPDFColorValue.getVPDFColorValue(pDFDict.get(C_K).pdfReferenceValue(requester));
            this.props.color = ((VColorValue)object).colorValue(requester);
        }
        if (pDFDict.hasKey(BS_K)) {
            object = pDFDict.get(BS_K).pdfReferenceValue(requester);
            PDFDict pDFDict2 = ((PDFReference)object).dictValue(requester);
            if (pDFDict2.hasKey(S_K)) {
                this.props.borderType = pDFDict2.get(S_K).nameValue(requester);
            }
            if (pDFDict2.hasKey(W_K)) {
                this.props.borderWidth = pDFDict2.get(W_K).doubleValue(requester);
            }
            if (pDFDict2.hasKey(D_K) && this.props.borderType.equals(D_K)) {
                VDashArray vDashArray = VPDFDashArray.getVPDFDashArray(pDFDict2.get(D_K).pdfReferenceValue(requester));
                this.props.dashArray = vDashArray.dashArrayValue(requester);
            }
        } else if (pDFDict.hasKey(Border_K)) {
            object = pDFDict.get(Border_K).pdfReferenceValue(requester);
            PDFArray pDFArray = ((PDFReference)object).arrayValue(requester);
            if (pDFArray.size() != 3 && pDFArray.size() != 4) {
                throw new Exception("Malformed Border array");
            }
            this.props.hCornerRadius = pDFArray.get(0).floatValue(requester);
            this.props.vCornerRadius = pDFArray.get(1).floatValue(requester);
            this.props.borderWidth = pDFArray.get(2).floatValue(requester);
            if (pDFArray.size() == 4) {
                PDFReference pDFReference = pDFArray.get(3).pdfReferenceValue(requester);
                VDashArray vDashArray = VPDFDashArray.getVPDFDashArray(pDFReference);
                this.props.dashArray = vDashArray.dashArrayValue(requester);
                this.props.borderType = D_K;
            }
        }
    }

    public static VAnnotBorderProps getVAnnotBorderProps(PDFReference pDFReference) throws Exception {
        VAnnotBorderProps.initProvider();
        return (VAnnotBorderProps)pDFReference.getExtensionData(VAnnotBorderProps_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new VAnnotBorderPropsProvider();
            Extension.registerProvider(VAnnotBorderProps_K, provider);
        }
    }
}

