/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.PSCalculatorStack;
import com.adobe.acrobat.pdf.PSbinary_op;
import com.adobe.acrobat.pdf.PSload_op;
import com.adobe.acrobat.pdf.PSspecial_op;
import com.adobe.acrobat.pdf.PSunary_op;
import java.util.Hashtable;

abstract class PSCalculatorOperator
implements Cloneable {
    static final double DegToRad = Math.PI / 180;
    static final double RadToDeg = 57.29577951308232;
    static final double Log10 = Math.log(10.0);
    public PSCalculatorOperator next;
    static Hashtable opTable = new Hashtable();

    static {
        opTable.put("true", new PSload_op(true));
        opTable.put("false", new PSload_op(false));
        opTable.put("abs", new PSunary_op(1));
        opTable.put("add", new PSbinary_op(1));
        opTable.put("and", new PSbinary_op(2));
        opTable.put("atan", new PSbinary_op(3));
        opTable.put("bitshift", new PSbinary_op(4));
        opTable.put("ceiling", new PSunary_op(2));
        opTable.put("cos", new PSunary_op(3));
        opTable.put("cvi", new PSunary_op(4));
        opTable.put("cvr", new PSunary_op(5));
        opTable.put("div", new PSbinary_op(5));
        opTable.put("exp", new PSbinary_op(7));
        opTable.put("floor", new PSunary_op(6));
        opTable.put("idiv", new PSbinary_op(10));
        opTable.put("ln", new PSunary_op(7));
        opTable.put("log", new PSunary_op(8));
        opTable.put("mod", new PSbinary_op(13));
        opTable.put("mul", new PSbinary_op(14));
        opTable.put("neg", new PSunary_op(9));
        opTable.put("not", new PSunary_op(0));
        opTable.put("or", new PSbinary_op(16));
        opTable.put("round", new PSunary_op(11));
        opTable.put("sin", new PSunary_op(12));
        opTable.put("sqrt", new PSunary_op(13));
        opTable.put("sub", new PSbinary_op(17));
        opTable.put("truncate", new PSunary_op(14));
        opTable.put("xor", new PSbinary_op(18));
        opTable.put("eq", new PSbinary_op(6));
        opTable.put("ge", new PSbinary_op(8));
        opTable.put("gt", new PSbinary_op(9));
        opTable.put("le", new PSbinary_op(11));
        opTable.put("lt", new PSbinary_op(12));
        opTable.put("ne", new PSbinary_op(15));
        opTable.put("if", new PSspecial_op(1));
        opTable.put("ifelse", new PSspecial_op(2));
        opTable.put("copy", new PSspecial_op(3));
        opTable.put("dup", new PSspecial_op(4));
        opTable.put("exch", new PSspecial_op(5));
        opTable.put("index", new PSspecial_op(6));
        opTable.put("pop", new PSspecial_op(7));
        opTable.put("roll", new PSspecial_op(8));
    }

    PSCalculatorOperator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract void execute(PSCalculatorStack var1) throws Exception;

    public static PSCalculatorOperator loadBoolean(boolean bl) {
        return new PSload_op(bl);
    }

    public static PSCalculatorOperator loadInteger(int n) {
        return new PSload_op(n);
    }

    public static PSCalculatorOperator loadNumber(double d) {
        return new PSload_op(d);
    }

    public static PSCalculatorOperator loadSubroutine(PSCalculatorOperator pSCalculatorOperator) {
        return new PSload_op(pSCalculatorOperator);
    }
}

