/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.PSCalculatorOperator;
import com.adobe.acrobat.pdf.PSCalculatorStack;
import com.adobe.acrobat.tokenize.Tokenizer;
import java.io.InputStream;

public class PSCalculatorExecuter {
    private PSCalculatorOperator thisProgram;

    public void compile(InputStream inputStream) {
        Tokenizer tokenizer = null;
        try {
            tokenizer = new Tokenizer(inputStream);
            this.thisProgram = this.parseOne(tokenizer);
        }
        catch (Throwable throwable) {
            this.thisProgram = null;
        }
        try {
            if (tokenizer != null) {
                tokenizer.close();
            }
        }
        catch (Exception exception) {}
    }

    public void compute(PSCalculatorStack pSCalculatorStack) throws Exception {
        this.thisProgram.execute(pSCalculatorStack);
        pSCalculatorStack.pop(1);
        PSCalculatorOperator pSCalculatorOperator = pSCalculatorStack.getSubroutineValue(1);
        PSCalculatorExecuter.doSub(pSCalculatorOperator, pSCalculatorStack);
    }

    public static void doSub(PSCalculatorOperator pSCalculatorOperator, PSCalculatorStack pSCalculatorStack) throws Exception {
        while (pSCalculatorOperator != null) {
            pSCalculatorOperator.execute(pSCalculatorStack);
            pSCalculatorOperator = pSCalculatorOperator.next;
        }
    }

    private PSCalculatorOperator parseOne(Tokenizer tokenizer) throws Exception {
        tokenizer.nextToken();
        switch (tokenizer.type()) {
            case 256: {
                return null;
            }
            case 2: {
                return PSCalculatorOperator.loadInteger(tokenizer.integerValue());
            }
            case 3: {
                return PSCalculatorOperator.loadNumber(tokenizer.realValue());
            }
            case 5: {
                String string = tokenizer.literalValue();
                Object v = PSCalculatorOperator.opTable.get(string);
                if (v != null) {
                    PSCalculatorOperator pSCalculatorOperator = (PSCalculatorOperator)v;
                    return (PSCalculatorOperator)pSCalculatorOperator.clone();
                }
                if (string.equals("{")) {
                    PSCalculatorOperator pSCalculatorOperator = this.parseOne(tokenizer);
                    if (pSCalculatorOperator != null) {
                        PSCalculatorOperator pSCalculatorOperator2;
                        PSCalculatorOperator pSCalculatorOperator3 = pSCalculatorOperator;
                        do {
                            pSCalculatorOperator3.next = pSCalculatorOperator2 = this.parseOne(tokenizer);
                        } while ((pSCalculatorOperator3 = pSCalculatorOperator2) != null);
                    }
                    return PSCalculatorOperator.loadSubroutine(pSCalculatorOperator);
                }
                if (!string.equals("}")) break;
                return null;
            }
        }
        throw new Exception("badprogram");
    }
}

