/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.ContentParser;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.pdf.Funct_text;
import com.adobe.acrobat.pdf.PDFFont;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFNumber;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFString;
import com.adobe.acrobat.pdfobjstore.UnexpectedTypeException;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.notify.Requester;
import com.adobe.util.MemUtil;

class Funct_cTJ
extends Funct_text {
    Funct_cTJ() {
    }

    private void addOffset(double d, CharOffsetObj charOffsetObj) {
        if (charOffsetObj.charOffsets == null) {
            charOffsetObj.charOffsets = MemUtil.allocDouble(50);
        } else if (charOffsetObj.nextOffset >= charOffsetObj.charOffsets.length) {
            double[] dArray = MemUtil.allocDouble(charOffsetObj.charOffsets.length + 50);
            System.arraycopy(charOffsetObj.charOffsets, 0, dArray, 0, charOffsetObj.charOffsets.length);
            charOffsetObj.charOffsets = dArray;
        }
        charOffsetObj.charOffsets[charOffsetObj.nextOffset++] = d;
    }

    private void adjustLastOffset(double d, CharOffsetObj charOffsetObj, int n, int n2) {
        int n3 = charOffsetObj.nextOffset - n + n2;
        charOffsetObj.charOffsets[n3] = charOffsetObj.charOffsets[n3] + d;
    }

    private double[] computeOffsetsAndString(Requester requester, GState gState, PDFArray pDFArray, StringBuffer stringBuffer) throws Exception {
        int n;
        int n2;
        int n3 = pDFArray.size();
        PDFFont pDFFont = gState.getVFont().pdfFontValue(requester);
        double d = 0.0;
        int n4 = 0;
        int n5 = 0;
        CharOffsetObj charOffsetObj = new CharOffsetObj();
        int n6 = 0;
        while (n6 < n3) {
            PDFObj pDFObj = pDFArray.get(n6);
            if (pDFObj instanceof PDFString) {
                ++n4;
            }
            ++n6;
        }
        if (pDFFont.isCIDFont()) {
            n2 = pDFFont.getWMode() == 1 ? 1 : 0;
            n = 4;
        } else {
            n2 = 0;
            n = 1;
        }
        int n7 = 0;
        while (n7 < n3) {
            PDFObj pDFObj = pDFArray.get(n7);
            if (pDFObj instanceof PDFString) {
                String string = Util.stringFromRawBytes(((PDFString)pDFObj).bytesValue());
                if (string.length() > 0) {
                    int n8;
                    string = pDFFont.convertHexStrings(string);
                    double[] dArray = this.computeLogicalOffsets(requester, gState, string, n5 == n4 - 1);
                    if (pDFFont.isCIDFont()) {
                        n8 = 0;
                        while (n8 < dArray.length) {
                            if (n8 % 4 == n2) {
                                this.addOffset(dArray[n8] + d, charOffsetObj);
                            } else {
                                this.addOffset(dArray[n8], charOffsetObj);
                            }
                            ++n8;
                        }
                    } else {
                        n8 = 0;
                        while (n8 < dArray.length) {
                            this.addOffset(dArray[n8] + d, charOffsetObj);
                            ++n8;
                        }
                    }
                    stringBuffer.append(string);
                    ++n5;
                    d = pDFFont.isCIDFont() ? (d += dArray[dArray.length - 4 + n2]) : (d += dArray[dArray.length - 1]);
                }
            } else if (pDFObj instanceof PDFNumber) {
                double d2 = ((PDFNumber)pDFObj).doubleValue();
                if (pDFFont.isCIDFont() && pDFFont.getWMode() == 1) {
                    d2 = -d2;
                }
                d -= d2;
                this.adjustLastOffset(-d2, charOffsetObj, n, n2);
            } else {
                throw new UnexpectedTypeException(4);
            }
            ++n7;
        }
        return this.getOffsets(charOffsetObj);
    }

    private double[] getOffsets(CharOffsetObj charOffsetObj) {
        if (charOffsetObj.charOffsets.length == charOffsetObj.nextOffset) {
            return charOffsetObj.charOffsets;
        }
        double[] dArray = MemUtil.allocDouble(charOffsetObj.nextOffset);
        System.arraycopy(charOffsetObj.charOffsets, 0, dArray, 0, charOffsetObj.nextOffset);
        return dArray;
    }

    public void setUp(Requester requester, ContentParser contentParser) throws Exception {
        PDFArray pDFArray = contentParser.popArray();
        contentParser.setGStateForText();
        GState gState = contentParser.getGState();
        StringBuffer stringBuffer = new StringBuffer(20);
        double[] dArray = this.computeOffsetsAndString(requester, gState, pDFArray, stringBuffer);
        double d = this.calcGreekWidth(gState, requester, dArray);
        this.handleText(requester, contentParser, new String(stringBuffer), dArray, d);
    }

    class CharOffsetObj {
        double[] charOffsets = null;
        int nextOffset = 0;

        CharOffsetObj() {
        }
    }
}

