/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.ContentInspectorFriend;
import com.adobe.acrobat.page.DrawContext;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.pdf.DocumentException;
import com.adobe.acrobat.pdf.PDFFont;
import com.adobe.acrobat.pdf.VPDFFont;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.util.Log;

class ContentText
extends Content
implements ContentInspectorFriend {
    protected static final int kTextRenderStrokeBit = 1;
    protected static final int kTextRenderFillBit = 2;
    static final boolean doAsserts = false;
    private FloatRect bbox = new FloatRect();
    double txtWidAdj = 0.0;
    private final double[] dbbox = new double[4];
    boolean doGreek = false;
    private int fGreekTextLimit;
    static boolean dumpit = false;
    static final boolean debug = false;
    private static double Deg2Rad = Math.PI / 180;
    private int renderBits = 0;
    private double[] logicalOffsets;
    private double greekWidth;
    private String text;
    PDFFont pdfFont;

    ContentText(GState gState, int n, int n2, String string, double[] dArray, double d, int n3, int n4) {
        super(gState, n3, n4);
        this.text = string;
        this.logicalOffsets = dArray;
        this.greekWidth = d;
        if (n2 == 0 || n2 == 2 || n2 == 4 || n2 == 6) {
            this.renderBits |= 2;
        }
        if (n2 == 1 || n2 == 2 || n2 == 5 || n2 == 6) {
            this.renderBits |= 1;
        }
        this.fGreekTextLimit = n;
    }

    public void draw(DrawContext drawContext) throws Exception {
        if (this.text.length() > 0) {
            this.drawSubstring(this.text, this.logicalOffsets, drawContext);
        }
    }

    public void drawSubstring(String string, double[] dArray, DrawContext drawContext) throws Exception {
        if (string.length() > 0) {
            VPDFFont vPDFFont = this.gState.getVFont();
            if (vPDFFont == null) {
                return;
            }
            PDFFont pDFFont = vPDFFont.pdfFontValue(null);
            FloatRect floatRect = this.getBoundingBox(drawContext.awtg.getCurrentTransform());
            if (!drawContext.awtg.getClipShape().rectVisible(floatRect)) {
                return;
            }
            if (this.doGreek) {
                drawContext.awtg.setFillColor(this.gState.getFillColor());
                drawContext.awtg.greekText(this.greekWidth / 1000.0, pDFFont.getWMode() == 1);
                return;
            }
            if ((this.renderBits & 2) != 0) {
                drawContext.awtg.setFillColor(this.gState.getFillColor());
                drawContext.awtg.fillString(string, pDFFont, dArray, floatRect);
            }
            if ((this.renderBits & 1) != 0) {
                drawContext.awtg.setStrokeColor(this.gState.getStrokeColor());
                drawContext.awtg.drawString(string, pDFFont, dArray, floatRect);
            }
        }
    }

    public FloatRect getBoundingBox() throws Exception {
        return this.getBoundingBox(this.gState.getCTM());
    }

    public synchronized FloatRect getBoundingBox(AffineTransform affineTransform) throws Exception {
        double d;
        double d2;
        VPDFFont vPDFFont = this.gState.getVFont();
        if (vPDFFont == null) {
            throw new DocumentException(96);
        }
        this.pdfFont = vPDFFont.pdfFontValue(null);
        this.pdfFont.getBBox(this.dbbox);
        double d3 = this.dbbox[2];
        double d4 = this.dbbox[3];
        double d5 = this.pdfFont.unitsPerEM();
        if (this.logicalOffsets.length > 0) {
            if (this.pdfFont.isCIDFont()) {
                if (this.pdfFont.getWMode() == 0) {
                    if (this.logicalOffsets.length > 4) {
                        d2 = this.logicalOffsets[this.logicalOffsets.length - 8] / 1000.0 * d5 + d3;
                        d = this.logicalOffsets[this.logicalOffsets.length - 4] / 1000.0 * d5;
                        this.dbbox[2] = d2 > d ? d2 : d;
                        this.dbbox[0] = this.dbbox[0] + this.logicalOffsets[2] / 1000.0 * d5;
                    } else if (d4 > this.dbbox[3]) {
                        this.dbbox[2] = d3;
                    }
                    if (this.pdfFont.getItalicAngle() != 0.0) {
                        this.dbbox[2] = this.dbbox[2] - Math.sin(this.pdfFont.getItalicAngle() * Deg2Rad) * d5;
                    }
                } else {
                    double d6 = this.logicalOffsets[2] / 1000.0 * d5;
                    if (this.logicalOffsets.length > 4) {
                        double d7 = this.logicalOffsets[this.logicalOffsets.length - 4 + 1] / 1000.0 * d5;
                        double d8 = this.logicalOffsets[this.logicalOffsets.length - 4 + 2] / 1000.0 * d5;
                        this.dbbox[0] = this.dbbox[0] + d6;
                        this.dbbox[1] = this.dbbox[1] - d7;
                        this.dbbox[2] = this.dbbox[2] + d8;
                    } else {
                        double d9 = this.logicalOffsets[3] / 1000.0 * d5;
                        if (d4 > this.dbbox[3]) {
                            this.dbbox[3] = d4;
                        }
                        this.dbbox[0] = this.dbbox[0] + d6;
                        this.dbbox[1] = this.dbbox[1] + d9;
                    }
                    if (this.pdfFont.getItalicAngle() != 0.0) {
                        this.dbbox[2] = this.dbbox[2] - Math.sin(this.pdfFont.getItalicAngle() * Deg2Rad) * d5;
                    }
                }
            } else {
                if (this.logicalOffsets.length > 1) {
                    d2 = this.logicalOffsets[this.logicalOffsets.length - 2] / 1000.0 * d5 + d3;
                    d = this.logicalOffsets[this.logicalOffsets.length - 1] / 1000.0 * d5;
                    this.dbbox[2] = d2 > d ? d2 : d;
                } else if (d3 > this.dbbox[2]) {
                    this.dbbox[2] = d3;
                }
                if (this.pdfFont.getItalicAngle() != 0.0) {
                    this.dbbox[2] = this.dbbox[2] - Math.sin(this.pdfFont.getItalicAngle() * Deg2Rad) * d5;
                }
            }
        }
        this.dbbox[0] = this.dbbox[0] / d5;
        this.dbbox[2] = this.dbbox[2] / d5;
        this.dbbox[1] = this.dbbox[1] / d5;
        this.dbbox[3] = this.dbbox[3] / d5;
        this.bbox = new FloatRect(this.dbbox);
        this.bbox = this.bbox.transformRect(affineTransform);
        if ((this.renderBits & 1) != 0) {
            this.txtWidAdj = this.gState.getLineWidth() / (2.0 * FloatPoint.sqrtTwo);
            if (this.txtWidAdj != 0.0) {
                this.bbox = this.bbox.grow(this.txtWidAdj, -this.txtWidAdj);
            }
        } else {
            this.txtWidAdj = 0.0;
        }
        double d10 = this.bbox.getxMin();
        double d11 = this.bbox.getyMin();
        double d12 = this.bbox.getxMax();
        double d13 = this.bbox.getyMax();
        d2 = this.pdfFont.getwMode() == 0 ? d13 - d11 : d12 - d10;
        boolean bl = this.doGreek = d2 <= (double)this.fGreekTextLimit;
        if (d10 > d12) {
            d = d10;
            d10 = d12;
            d12 = d;
        }
        if (d11 > d13) {
            d = d11;
            d11 = d13;
            d13 = d;
        }
        this.bbox = new FloatRect(d10, d11, d12, d13);
        return this.bbox;
    }

    public PDFFont getFont() {
        return this.pdfFont;
    }

    double[] getLogicalOffsets() {
        return this.logicalOffsets;
    }

    public String getShortDescription() {
        return "(" + this.text + ") Text";
    }

    public String getText() {
        return this.text;
    }

    double getTextWidth() {
        return this.logicalOffsets[this.logicalOffsets.length - 1];
    }

    void validate(String string) {
        if (this.text != null && this.logicalOffsets != null && this.text.length() != this.logicalOffsets.length) {
            Log.clog(String.valueOf(string) + ":Assert fail; text.size() != logicalOffsets.length");
        }
    }
}

