/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.Pattern;
import com.adobe.acrobat.pdf.image.DeviceGrayColorModel;
import com.adobe.acrobat.pdf.image.DeviceRGBColorModel;
import com.adobe.acrobat.pdf.image.ImageMaskColorModel;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.SidecarColor;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.util.MemUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class ColorValue
implements Cloneable {
    public float[] channels;
    public float alpha;
    Pattern pattern;
    PDFColorModel colormodel;
    public static ColorValue black;
    public static ColorValue darkGray;
    public static ColorValue gray;
    public static ColorValue lightGray;
    public static ColorValue white;
    public static ColorValue red;
    public static ColorValue green;
    public static ColorValue blue;
    public static ColorValue cyan;
    public static ColorValue magenta;
    public static ColorValue yellow;

    static {
        float[] fArray = new float[1];
        black = new ColorValue(DeviceGrayColorModel.DefaultColorModel, fArray);
        float[] fArray2 = new float[]{0.251f};
        darkGray = new ColorValue(DeviceGrayColorModel.DefaultColorModel, fArray2);
        float[] fArray3 = new float[]{0.5f};
        gray = new ColorValue(DeviceGrayColorModel.DefaultColorModel, fArray3);
        float[] fArray4 = new float[]{0.75f};
        lightGray = new ColorValue(DeviceGrayColorModel.DefaultColorModel, fArray4);
        float[] fArray5 = new float[]{1.0f};
        white = new ColorValue(DeviceGrayColorModel.DefaultColorModel, fArray5);
        float[] fArray6 = new float[3];
        fArray6[0] = 1.0f;
        float[] fArray7 = fArray6;
        red = new ColorValue(DeviceRGBColorModel.DefaultColorModel, fArray7);
        float[] fArray8 = new float[3];
        fArray8[1] = 1.0f;
        float[] fArray9 = fArray8;
        green = new ColorValue(DeviceRGBColorModel.DefaultColorModel, fArray9);
        float[] fArray10 = new float[3];
        fArray10[2] = 1.0f;
        float[] fArray11 = fArray10;
        blue = new ColorValue(DeviceRGBColorModel.DefaultColorModel, fArray11);
        float[] fArray12 = new float[3];
        fArray12[1] = 1.0f;
        fArray12[2] = 1.0f;
        float[] fArray13 = fArray12;
        cyan = new ColorValue(DeviceRGBColorModel.DefaultColorModel, fArray13);
        float[] fArray14 = new float[3];
        fArray14[0] = 1.0f;
        fArray14[2] = 1.0f;
        float[] fArray15 = fArray14;
        magenta = new ColorValue(DeviceRGBColorModel.DefaultColorModel, fArray15);
        float[] fArray16 = new float[3];
        fArray16[0] = 1.0f;
        fArray16[1] = 1.0f;
        float[] fArray17 = fArray16;
        yellow = new ColorValue(DeviceRGBColorModel.DefaultColorModel, fArray17);
    }

    public ColorValue() {
        this(black);
    }

    public ColorValue(ColorValue colorValue) {
        this.channels = (float[])colorValue.channels.clone();
        this.alpha = colorValue.alpha;
        this.pattern = colorValue.pattern;
        this.colormodel = colorValue.colormodel;
    }

    public ColorValue(Pattern pattern, PDFColorModel pDFColorModel, float[] fArray) {
        this.channels = fArray;
        this.alpha = 1.0f;
        this.pattern = pattern;
        this.colormodel = pDFColorModel;
    }

    public ColorValue(PDFColorModel pDFColorModel, float[] fArray) {
        this(null, pDFColorModel, fArray);
    }

    public float[] accessColor() {
        return this.channels;
    }

    public Object clone() {
        return new ColorValue(this);
    }

    public int getAlpha() {
        return Math.round(this.alpha * 255.0f);
    }

    public int getBlue() {
        return this.colormodel.getRGB(this.channels) & 0xFF;
    }

    public float[] getColor() {
        if (this.channels != null) {
            return (float[])this.channels.clone();
        }
        return null;
    }

    public PDFColorModel getColorModel() {
        return this.colormodel;
    }

    public int getGreen() {
        return this.colormodel.getRGB(this.channels) >>> 8 & 0xFF;
    }

    public int getRGB() {
        return (this.getAlpha() << 24) + (this.colormodel.getRGB(this.channels) & 0xFFFFFF);
    }

    public Color getRGBColor() {
        if (this.colormodel != null) {
            return new SidecarColor(this.getRGB());
        }
        return Color.black;
    }

    public int getRed() {
        return this.colormodel.getRGB(this.channels) >>> 16 & 0xFF;
    }

    public boolean paintIsComplex() {
        return this.pattern != null;
    }

    public SidecarImage patternImage(AffineTransform affineTransform, Rectangle rectangle) throws Exception {
        SidecarImage sidecarImage = null;
        if (this.pattern != null) {
            sidecarImage = this.pattern.patternImage(this, affineTransform, rectangle);
            sidecarImage.applyOpacity(this.alpha);
        } else {
            ImageMaskColorModel imageMaskColorModel = new ImageMaskColorModel();
            ((PDFColorModel)imageMaskColorModel).setPaintColor(this);
            byte by = (byte)this.getAlpha();
            int n = rectangle.width * rectangle.height;
            byte[] byArray = MemUtil.allocByte(n);
            while (n-- > 0) {
                byArray[n] = by;
            }
            sidecarImage = new SidecarImage(rectangle.width, rectangle.height, (ColorModel)imageMaskColorModel, byArray, 0, rectangle.width);
            sidecarImage.setOrigin(rectangle.x, rectangle.y);
        }
        return sidecarImage;
    }

    public void setColor(float[] fArray) {
        this.channels = fArray;
    }

    public void setOpacity(float f) {
        this.alpha = f <= 0.0f ? 0.0f : (f >= 1.0f ? 1.0f : f);
    }
}

