/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.page;

import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.ClipShape;
import com.adobe.acrobat.sidecar.Region;
import java.awt.Rectangle;

public class DrawContext {
    public AWTGraphics awtg;
    public AffineTransform transform;
    public ClipShape clip;
    private GState currState;
    private boolean printing;
    private boolean dead = false;

    public DrawContext(AWTGraphics aWTGraphics) throws Exception {
        this(aWTGraphics, AffineTransform.getIdentityMatrix(), Region.getUniversalRegion(), false);
    }

    public DrawContext(AWTGraphics aWTGraphics, AffineTransform affineTransform) throws Exception {
        this(aWTGraphics, affineTransform, Region.getUniversalRegion(), false);
    }

    public DrawContext(AWTGraphics aWTGraphics, AffineTransform affineTransform, ClipShape clipShape) throws Exception {
        this(aWTGraphics, affineTransform, clipShape, false);
    }

    public DrawContext(AWTGraphics aWTGraphics, AffineTransform affineTransform, ClipShape clipShape, boolean bl) throws Exception {
        this.awtg = aWTGraphics;
        this.transform = affineTransform;
        this.clip = clipShape;
        this.currState = null;
        this.printing = bl;
        this.reset();
    }

    public DrawContext(AWTGraphics aWTGraphics, AffineTransform affineTransform, Region region) throws Exception {
        this(aWTGraphics, affineTransform, new ClipShape(region), false);
    }

    public DrawContext(AWTGraphics aWTGraphics, AffineTransform affineTransform, Region region, boolean bl) throws Exception {
        this(aWTGraphics, affineTransform, new ClipShape(region), bl);
    }

    public DrawContext(AWTGraphics aWTGraphics, AffineTransform affineTransform, Rectangle rectangle) throws Exception {
        this(aWTGraphics, affineTransform, new Region(rectangle), false);
    }

    public DrawContext(AWTGraphics aWTGraphics, AffineTransform affineTransform, Rectangle rectangle, boolean bl) throws Exception {
        this(aWTGraphics, affineTransform, new Region(rectangle), bl);
    }

    public DrawContext(AWTGraphics aWTGraphics, AffineTransform affineTransform, boolean bl) throws Exception {
        this(aWTGraphics, affineTransform, Region.getUniversalRegion(), bl);
    }

    public DrawContext(AWTGraphics aWTGraphics, boolean bl) throws Exception {
        this(aWTGraphics, AffineTransform.getIdentityMatrix(), Region.getUniversalRegion(), bl);
    }

    public GState getCurrState() {
        return this.currState;
    }

    boolean isDead() {
        return this.dead;
    }

    public void kill() {
        this.dead = true;
    }

    public void reset() throws Exception {
        this.awtg.reset();
        this.awtg.setClip(this.clip);
        this.awtg.setTransform(this.transform);
        GState gState = GState.getInitialGState();
        if (this.printing) {
            gState = gState.setForPrinting(this.printing);
        }
        gState.apply(this);
    }

    public void setCurrState(GState gState) {
        this.currState = gState;
    }
}

