/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui.tree;

import com.adobe.acrobat.gui.tree.Icon;
import com.adobe.acrobat.gui.tree.TreeLayoutManager;
import com.adobe.acrobat.gui.tree.TreeListener;
import com.adobe.acrobat.gui.tree.TreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class Tree
extends Container
implements KeyListener,
FocusListener {
    private TreeNode selectedNode;
    private int selectedIndex;
    private ScrollPane sp;
    private boolean hasFocus;
    private int searchLoopBound;
    private Vector treeListener;
    private static final int NODE_SELECTED = 0;
    private static final int NODE_DESELECTED = 1;
    private static final int SETUP_CHILDREN = 2;

    public Tree() {
        this.setLayout(new TreeLayoutManager(this));
        this.sp = new ScrollPane();
        this.sp.add(this);
        this.sp.setBackground(SystemColor.window);
        this.selectedIndex = -1;
        this.treeListener = new Vector();
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Tree.this.requestFocus();
            }
        });
    }

    public Tree(TreeNode treeNode) {
        this();
        this.addRootNode(treeNode);
    }

    public void addNode(TreeNode treeNode) {
        super.add("Node", treeNode);
        treeNode.setTree(this);
    }

    public void addRootNode(TreeNode treeNode) {
        this.addNode(treeNode);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.treeListener.addElement(treeListener);
    }

    public void expandNode(TreeNode treeNode) {
        if (treeNode.isChildrenKnown()) {
            treeNode.expandNode();
        } else {
            this.notifyListeners(2, treeNode);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        if (this.selectedNode != null) {
            this.selectedNode.focusGained(focusEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        if (this.selectedNode != null) {
            this.selectedNode.focusLost(focusEvent);
        }
    }

    public int getNodeIndex(TreeNode treeNode) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n].equals(treeNode)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getRow(TreeNode treeNode) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n].equals(treeNode)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ScrollPane getScrollPane() {
        return this.sp;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    private void insertAllChildren(TreeNode treeNode, int n) {
        if (n != -1) {
            TreeNode treeNode2;
            Vector vector = treeNode.getChildren();
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                treeNode2 = (TreeNode)vector.elementAt(n3);
                this.addNode(treeNode2);
                if (treeNode2.isExpanded()) {
                    this.insertAllChildren(treeNode2, n + n3 + 1);
                }
                ++n3;
            }
            if (n2 == 1) {
                treeNode2 = (TreeNode)vector.elementAt(0);
                treeNode2.setIsSingletonChild(true);
            } else if (n2 > 1) {
                treeNode2 = (TreeNode)vector.elementAt(0);
                treeNode2.setIsFirstChild(true);
                treeNode2 = (TreeNode)vector.elementAt(n2 - 1);
                treeNode2.setIsLastChild(true);
            } else {
                treeNode.setIsLeaf();
            }
        }
    }

    public void insertChildren(TreeNode treeNode) {
        int n = this.getNodeIndex(treeNode);
        Component[] componentArray = this.removeElementsAfter(n);
        this.insertAllChildren(treeNode, n);
        int n2 = 0;
        while (n2 < componentArray.length) {
            this.addNode((TreeNode)componentArray[n2]);
            ++n2;
        }
        this.validate();
        this.sp.validate();
        this.repaint();
    }

    public boolean isNodeFullyVisible(TreeNode treeNode) {
        Rectangle rectangle = treeNode.getBounds();
        Rectangle rectangle2 = new Rectangle(this.sp.getScrollPosition(), this.sp.getViewportSize());
        return rectangle2.intersects(rectangle);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 40) {
            this.selectNextNode();
        } else if (n == 38) {
            this.selectPreviousNode();
        } else if (n == 36) {
            this.selectNode((TreeNode)this.getComponents()[0]);
        } else if (n == 35) {
            Component[] componentArray = this.getComponents();
            this.selectNode((TreeNode)componentArray[componentArray.length - 1]);
        } else if (n == 39) {
            this.expandNode(this.selectedNode);
        } else if (n == 37) {
            if (this.selectedNode != null) {
                if (this.selectedNode.isLeaf() || !this.selectedNode.isExpanded()) {
                    this.selectNode(this.selectedNode.getParentNode());
                } else {
                    this.selectedNode.collapseNode();
                }
            }
        } else {
            this.searchLoopBound = 0;
            this.selectNodeWithChar(KeyEvent.getKeyText(n).toLowerCase().charAt(0), this.selectedIndex);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        Component component;
        Icon icon = new Icon("icons/default/icon16.gif", "Acrobat Icon");
        TreeNode treeNode = new TreeNode(null, icon, "RootNode - Name of the Document");
        Tree tree = new Tree(treeNode);
        Icon icon2 = new Icon("icons/default/pageonly.gif", "Acrobat Icon");
        int n = 0;
        while (n < 2) {
            component = new TreeNode(treeNode, icon2, "Line " + n + " Shahram Javey, Adobe Systems, Inc. San Jose, California");
            treeNode.addChildNode((TreeNode)component);
            int n2 = 0;
            while (n2 < 5) {
                TreeNode treeNode2 = new TreeNode((TreeNode)component, icon2, "Child number " + n2 + " of parent " + n + " - Level 1");
                int n3 = 0;
                while (n3 < 2) {
                    TreeNode treeNode3 = new TreeNode(treeNode2, icon2, "Child number " + n3 + " of parent " + n2 + " - Level 2");
                    int n4 = 0;
                    while (n4 < 3) {
                        TreeNode treeNode4 = new TreeNode(treeNode3, icon2, "Child number " + n2 + " of parent " + n4 + " - Level 3");
                        treeNode4.setIsLeaf();
                        treeNode3.addChildNode(treeNode4);
                        ++n4;
                    }
                    treeNode2.addChildNode(treeNode3);
                    ++n3;
                }
                ((TreeNode)component).addChildNode(treeNode2);
                ++n2;
            }
            ++n;
        }
        treeNode.expandNode();
        component = new Frame("Test Tree");
        ((Window)component).addWindowListener(new WindowAdapter((Frame)component){
            private final /* synthetic */ Frame val$f;
            {
                this.val$f = frame;
            }

            public void windowClosing(WindowEvent windowEvent) {
                this.val$f.dispose();
                System.exit(0);
            }
        });
        ((Container)component).setLayout(new BorderLayout());
        ((Container)component).add(tree.getScrollPane(), "Center");
        component.setSize(500, 500);
        ((Window)component).show();
        Container container = tree;
        while (container != null) {
            System.out.println(container);
            container = container.getParent();
        }
    }

    private void notifyListeners(int n, TreeNode treeNode) {
        int n2 = 0;
        while (n2 < this.treeListener.size()) {
            TreeListener treeListener = (TreeListener)this.treeListener.elementAt(n2);
            switch (n) {
                case 0: {
                    treeListener.nodeSelected(treeNode);
                    break;
                }
                case 1: {
                    treeListener.nodeDeselected(treeNode);
                    break;
                }
                case 2: {
                    treeListener.computeChildrenAndExpand(treeNode);
                    break;
                }
            }
            ++n2;
        }
    }

    private void removeAllChildren(TreeNode treeNode, int n) {
        if (n != -1) {
            Vector vector = treeNode.getChildren();
            int n2 = 0;
            while (n2 < vector.size()) {
                TreeNode treeNode2 = (TreeNode)vector.elementAt(n2);
                if (treeNode2.isExpanded()) {
                    int n3 = this.getNodeIndex(treeNode2);
                    this.removeAllChildren(treeNode2, n3);
                }
                this.remove(n + 1);
                ++n2;
            }
        }
    }

    public void removeChildren(TreeNode treeNode) {
        int n = this.getNodeIndex(treeNode);
        this.removeAllChildren(treeNode, n);
        this.validate();
        this.sp.validate();
        this.repaint();
    }

    private Component[] removeElementsAfter(int n) {
        Component[] componentArray = this.getComponents();
        Component[] componentArray2 = new Component[componentArray.length - n - 1];
        int n2 = 0;
        while (n2 < componentArray2.length) {
            componentArray2[n2] = componentArray[n + n2 + 1];
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < componentArray.length) {
            this.remove(n + 1);
            ++n3;
        }
        return componentArray2;
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.treeListener.removeElement(treeListener);
    }

    public void selectNextNode() {
        Component[] componentArray = this.getComponents();
        if (this.selectedIndex < componentArray.length - 1) {
            this.selectNode((TreeNode)componentArray[++this.selectedIndex]);
        }
    }

    public void selectNode(TreeNode treeNode) {
        this.selectTheNode(treeNode);
        this.selectedIndex = this.getRow(treeNode);
    }

    public void selectNodeAt(int n) {
        if (n < 0 || n + 1 > this.getComponentCount()) {
            return;
        }
        this.selectTheNode((TreeNode)this.getComponent(n));
        this.selectedIndex = n;
    }

    private void selectNodeWithChar(char c, int n) {
        int n2 = n + 1;
        Component[] componentArray = this.getComponents();
        if (n2 == componentArray.length) {
            n2 = 1;
        }
        boolean bl = false;
        int n3 = n2;
        while (n3 < componentArray.length) {
            TreeNode treeNode = (TreeNode)this.getComponent(n3);
            char c2 = treeNode.getText().toLowerCase().charAt(0);
            if (c2 == c) {
                this.selectNodeAt(n3);
                bl = true;
                break;
            }
            ++n3;
        }
        if (!bl && this.searchLoopBound++ < 1) {
            this.selectNodeWithChar(c, 0);
        }
    }

    public void selectPreviousNode() {
        Component[] componentArray = this.getComponents();
        if (this.selectedIndex > 0) {
            this.selectNode((TreeNode)componentArray[--this.selectedIndex]);
        }
    }

    private void selectTheNode(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (this.selectedNode != null) {
            this.selectedNode.selectNode(false);
        }
        this.notifyListeners(1, this.selectedNode);
        this.selectedNode = treeNode;
        this.selectedNode.selectNode(true);
        this.notifyListeners(0, this.selectedNode);
        if (!this.isNodeFullyVisible(treeNode)) {
            this.sp.setScrollPosition(treeNode.getLocation());
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

