/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.ViewerCommand;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.acrobat.gui.ZoomLevelButton;
import com.adobe.acrobat.gui.ZoomValueSpec;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.vtypes.VBoolean;

class ZoomUIVerb
extends UIVerb
implements ViewerCommand {
    AcroViewContext context;
    ZoomValueSpec spec;

    ZoomUIVerb(AcroViewContext acroViewContext, ZoomValueSpec zoomValueSpec) {
        this.context = acroViewContext;
        this.spec = zoomValueSpec;
        ZoomTransactor zoomTransactor = new ZoomTransactor();
        VBoolean vBoolean = SimpleUIVerb.getVDocIsOpenBoolean(acroViewContext);
        VZoomIsSelectedBoolean vZoomIsSelectedBoolean = zoomValueSpec == null ? null : new VZoomIsSelectedBoolean();
        this.setAttributes(zoomTransactor, vBoolean, vZoomIsSelectedBoolean);
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        CommandRegistry.addCommand(new ZoomUIVerb(acroViewContext, new ZoomValueSpec(null, "FixedZoom", 1.0)), acroViewContext, "ActualSize");
        CommandRegistry.addCommand(new ZoomUIVerb(acroViewContext, new ZoomValueSpec(null, "FitVisible", 1.0)), acroViewContext, "FitVisible");
        CommandRegistry.addCommand(new ZoomUIVerb(acroViewContext, new ZoomValueSpec(null, "FitPage", 1.0)), acroViewContext, "FitPage");
        CommandRegistry.addCommand(new ZoomUIVerb(acroViewContext, new ZoomValueSpec(null, "FitWidth", 1.0)), acroViewContext, "FitWidth");
        CommandRegistry.addCommand(new ZoomUIVerb(acroViewContext, new ZoomValueSpec(null, "FitVisibleWidth", 1.0)), acroViewContext, "FitVisibleWidth");
        CommandRegistry.addCommand(new ZoomUIVerb(acroViewContext, new ZoomValueSpec(null, "FitHeight", 1.0)), acroViewContext, "FitHeight");
        CommandRegistry.addCommand(new ZoomUIVerb(acroViewContext, new ZoomValueSpec(null, "FitVisibleHeight", 1.0)), acroViewContext, "FitVisibleHeight");
        CommandRegistry.addCommand(new ZoomUIVerb(acroViewContext, null), acroViewContext, "ZoomTo");
    }

    class ZoomTransactor
    extends Transactor {
        ZoomTransactor() {
        }

        public void buildChanges(Transaction transaction) throws Exception {
            if (ZoomUIVerb.this.spec != null) {
                ZoomUIVerb.this.context.getPageView().setZoomValueSpec(transaction, ZoomUIVerb.this.spec);
            } else {
                ZoomLevelButton.handleZoomDialog(ZoomUIVerb.this.context);
            }
        }
    }

    class VZoomIsSelectedBoolean
    extends VBoolean {
        VZoomIsSelectedBoolean() {
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            if (!SimpleUIVerb.getVDocIsOpenBoolean(ZoomUIVerb.this.context).booleanValue(requester)) {
                return false;
            }
            PageView pageView = ZoomUIVerb.this.context.getPageView();
            String string = pageView.getScaleType(requester);
            if (string.equals(ZoomUIVerb.this.spec.zoomType)) {
                if (string.equals("FixedZoom")) {
                    float f = pageView.getScale(requester);
                    return f == ZoomUIVerb.this.spec.zoomLevel;
                }
                return true;
            }
            return false;
        }
    }
}

