/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.Viewer;
import com.adobe.acrobat.ViewerCommand;
import com.adobe.acrobat.debug.VDebugUIElementGroup;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.EditVerb;
import com.adobe.acrobat.gui.PrintUI;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.acrobat.gui.Tool;
import com.adobe.acrobat.gui.VNavigationUIElements;
import com.adobe.acrobat.gui.VTocUIElements;
import com.adobe.acrobat.gui.ViewModes;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.UIElement;
import com.adobe.pe.awt.UIElementGroup;
import com.adobe.pe.awt.UIElementVerb;
import com.adobe.pe.awt.VUIElement;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.util.Assert;

public class VViewerMenus
extends VUIElement
implements ViewerCommand {
    private static final String VViewerMenus_K = "VViewerMenus";
    private static ExtensionDataProvider provider = null;
    private AcroViewContext context;

    VViewerMenus(AcroViewContext acroViewContext) {
        this.context = acroViewContext;
    }

    protected final UIElement computeUIElement(Requester requester) throws Exception {
        UIElementGroup uIElementGroup = new UIElementGroup(0);
        uIElementGroup.addUIElement(this.createFileMenu(requester));
        uIElementGroup.addUIElement(this.createEditMenu(requester));
        uIElementGroup.addUIElement(this.createViewMenu(requester));
        uIElementGroup.addUIElement(this.createToolMenu(requester));
        uIElementGroup.addUIElement(this.createHelpMenu(requester));
        if (Viewer.enabledDebug()) {
            uIElementGroup.addUIElement(VDebugUIElementGroup.getVDebugUIElementGroup(this.context).uiElementValue(requester));
        }
        return uIElementGroup;
    }

    private UIElement createEditMenu(Requester requester) {
        UIElementVerb uIElementVerb;
        UIElement uIElement;
        UIElementGroup uIElementGroup = new UIElementGroup(2, Util.getMenuVString("Edit"));
        UIElementGroup uIElementGroup2 = new UIElementGroup(1);
        if (CommandRegistry.isCommandAllowed("EditUndo")) {
            uIElement = new UIElementVerb(1, new EditVerb(this.context, 1), Util.getMenuVString("Undo"), null, null);
            uIElementGroup2.addUIElement(uIElement);
        }
        uIElement = new UIElementGroup(1);
        if (CommandRegistry.isCommandAllowed("EditCut")) {
            uIElementVerb = new UIElementVerb(0, new EditVerb(this.context, 2), Util.getMenuVString("Cut"), null, null);
            ((UIElementGroup)uIElement).addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("EditCopy")) {
            uIElementVerb = new UIElementVerb(0, new EditVerb(this.context, 3), Util.getMenuVString("Copy"), null, null);
            ((UIElementGroup)uIElement).addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("EditPaste")) {
            uIElementVerb = new UIElementVerb(0, new EditVerb(this.context, 4), Util.getMenuVString("Paste"), null, null);
            ((UIElementGroup)uIElement).addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("EditDelete")) {
            uIElementVerb = new UIElementVerb(0, new EditVerb(this.context, 5), Util.getMenuVString("Delete"), null, null);
            ((UIElementGroup)uIElement).addUIElement(uIElementVerb);
        }
        uIElementGroup2.addUIElement(uIElement);
        if (CommandRegistry.isCommandAllowed("EditSelectAll")) {
            uIElementVerb = new UIElementVerb(1, new EditVerb(this.context, 6), Util.getMenuVString("SelectAll"), null, null);
            uIElementGroup2.addUIElement(uIElementVerb);
        }
        uIElementGroup.addUIElement(uIElementGroup2);
        if (CommandRegistry.isCommandAllowed("Find")) {
            uIElementVerb = new UIElementVerb(1, new SimpleUIVerb(18, this.context), Util.getMenuVString("Find"), null, null);
            uIElementGroup.addUIElement(uIElementVerb);
        }
        return uIElementGroup;
    }

    private UIElement createFileMenu(Requester requester) throws Exception {
        UIElementVerb uIElementVerb;
        UIElement uIElement;
        UIElementGroup uIElementGroup = new UIElementGroup(2, Util.getMenuVString("File"));
        this.createOpenGroup(uIElementGroup);
        if (CommandRegistry.isCommandAllowed("DocInfo")) {
            uIElement = new UIElementVerb(1, new SimpleUIVerb(19, this.context), Util.getMenuVString("DocInfo"), null, null);
            uIElementGroup.addUIElement(uIElement);
        }
        uIElement = PrintUI.getVPrintUIElements(this.context).uiElementValue(requester);
        uIElementGroup.addUIElement(uIElement);
        if (CommandRegistry.isCommandAllowed("GeneralPrefs")) {
            uIElementVerb = new UIElementVerb(1, new SimpleUIVerb(5, this.context), Util.getMenuVString("GeneralPrefs"), null, null);
            uIElementGroup.addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("Close")) {
            uIElementVerb = new UIElementVerb(1, new SimpleUIVerb(4, this.context), Util.getMenuVString("Close"), null, null);
            uIElementGroup.addUIElement(uIElementVerb);
        }
        return uIElementGroup;
    }

    private UIElement createHelpMenu(Requester requester) throws Exception {
        UIElementVerb uIElementVerb;
        UIElementGroup uIElementGroup = new UIElementGroup(2, Util.getMenuVString("Help"), true);
        if (CommandRegistry.isCommandAllowed("ListBindings")) {
            uIElementVerb = new UIElementVerb(1, new SimpleUIVerb(7, this.context), Util.getMenuVString("ListBindings"), null, null);
            uIElementGroup.addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("OpenHelpFile")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(8, this.context), Util.getMenuVString("OpenHelpFile"), null, null);
            uIElementGroup.addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("OpenLicenseFile")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(9, this.context), Util.getMenuVString("ViewLicense"), null, null);
            uIElementGroup.addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("About")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(6, this.context), Util.getMenuVString("AboutThis"), null, null);
            uIElementGroup.addUIElement(uIElementVerb);
        }
        return uIElementGroup;
    }

    private void createOpenGroup(UIElementGroup uIElementGroup) {
        UIElementVerb uIElementVerb;
        UIElementGroup uIElementGroup2 = new UIElementGroup(1);
        boolean bl = false;
        if (CommandRegistry.isCommandAllowed("Window")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(1, this.context), Util.getMenuVString("NewWindow"), null, null);
            uIElementGroup2.addUIElement(uIElementVerb);
            bl = true;
        }
        if (CommandRegistry.isCommandAllowed("Open")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(2, this.context), Util.getMenuVString("Open"), null, null);
            uIElementGroup2.addUIElement(uIElementVerb);
            bl = true;
        }
        if (CommandRegistry.isCommandAllowed("OpenURL")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(3, this.context), Util.getMenuVString("OpenURL"), null, null);
            uIElementGroup2.addUIElement(uIElementVerb);
            bl = true;
        }
        if (CommandRegistry.isCommandAllowed("Reload")) {
            uIElementVerb = new UIElementVerb(1, new SimpleUIVerb(17, this.context), Util.getMenuVString("Reload"), null, null);
            uIElementGroup2.addUIElement(uIElementVerb);
            bl = true;
        }
        if (bl) {
            uIElementGroup.addUIElement(uIElementGroup2);
        }
    }

    private UIElement createToolMenu(Requester requester) throws Exception {
        UIElementGroup uIElementGroup = new UIElementGroup(2, Util.getMenuVString("Tools"));
        UIElement uIElement = Tool.getVToolUIElementGroup(this.context).uiElementValue(requester);
        uIElementGroup.addUIElement(uIElement);
        return uIElementGroup;
    }

    private UIElement createViewMenu(Requester requester) throws Exception {
        UIElement uIElement;
        UIElementGroup uIElementGroup = new UIElementGroup(2, Util.getMenuVString("View"));
        UIElement uIElement2 = ViewModes.getVZoomUIElementGroup(this.context, 2).uiElementValue(requester);
        uIElementGroup.addUIElement(uIElement2);
        if (CommandRegistry.isCommandAllowed("ToggleFullScreen")) {
            uIElement = new UIElementVerb(1, this.context.getFullScreenVerb(), Util.getMenuVString("FullScreen"), null, null);
            uIElementGroup.addUIElement(uIElement);
        }
        uIElement = VNavigationUIElements.getVNavigationUIElements(this.context, true).uiElementValue(requester);
        uIElementGroup.addUIElement(uIElement);
        UIElement uIElement3 = ViewModes.getVPageLayoutUIElementGroup(this.context).uiElementValue(requester);
        uIElementGroup.addUIElement(uIElement3);
        UIElement uIElement4 = VTocUIElements.getVTocUIElements(this.context).uiElementValue(requester);
        uIElementGroup.addUIElement(uIElement4);
        return uIElementGroup;
    }

    public static VUIElement getVViewerMenus(AcroViewContext acroViewContext) {
        VViewerMenus.initProvider();
        return (VUIElement)acroViewContext.getExtensionData(VViewerMenus_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public final Object provide(String string, Extensible extensible) {
                    if (string.equals(VViewerMenus.VViewerMenus_K)) {
                        Assert.notFalse(extensible instanceof AcroViewContext);
                        AcroViewContext acroViewContext = (AcroViewContext)extensible;
                        return new VViewerMenus(acroViewContext);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VViewerMenus_K, provider);
        }
    }
}

