/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.ScrollingMouseTransactionClient;
import com.adobe.acrobat.gui.TextSelection;
import com.adobe.acrobat.pdf.VPageTextWordy;
import com.adobe.acrobat.pdf.Wordy;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.pe.notify.Transaction;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class TextSelectionMTC
extends ScrollingMouseTransactionClient {
    private Point mouseDownPoint;
    private int mouseDownPage = -1;
    private int mouseDownCharAt = -1;
    private Point mouseOverPoint;
    private int mouseOverPage = -1;
    private int mouseOverCharAt = -1;
    private PageView pv;

    TextSelectionMTC(PageView pageView) {
        super(pageView);
        this.pv = pageView;
    }

    private void computeTextSelection(Transaction transaction) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        Wordy wordy;
        FloatPoint floatPoint;
        AffineTransform affineTransform;
        PDFReference pDFReference;
        if (this.mouseDownPage < 0) {
            this.mouseDownPage = this.getPageAt(this.mouseDownPoint, transaction);
            pDFReference = this.pv.getPageRef(this.mouseDownPage, transaction);
            affineTransform = this.pv.getGalleyTransform(this.mouseDownPage, transaction).getInverse();
            floatPoint = new FloatPoint(this.mouseDownPoint);
            affineTransform.transformPoint(floatPoint);
            wordy = VPageTextWordy.getVPageTextWordy(pDFReference).wordyValue(transaction);
            this.mouseDownCharAt = wordy.findCharAt(floatPoint);
        }
        this.mouseOverPage = this.getPageAt(this.mouseOverPoint, transaction);
        pDFReference = this.pv.getPageRef(this.mouseOverPage, transaction);
        affineTransform = this.pv.getGalleyTransform(this.mouseOverPage, transaction).getInverse();
        floatPoint = new FloatPoint(this.mouseOverPoint);
        affineTransform.transformPoint(floatPoint);
        wordy = VPageTextWordy.getVPageTextWordy(pDFReference).wordyValue(transaction);
        this.mouseOverCharAt = wordy.findCharAt(floatPoint);
        if (this.mouseDownPage < this.mouseOverPage) {
            n4 = this.mouseDownPage;
            n3 = this.mouseDownCharAt;
            n2 = this.mouseOverPage;
            n = this.mouseOverCharAt;
        } else if (this.mouseDownPage > this.mouseOverPage) {
            n4 = this.mouseOverPage;
            n3 = this.mouseOverCharAt;
            n2 = this.mouseDownPage;
            n = this.mouseDownCharAt;
        } else {
            n4 = n2 = this.mouseDownPage;
            if (this.mouseDownCharAt <= this.mouseOverCharAt) {
                n3 = this.mouseDownCharAt;
                n = this.mouseOverCharAt;
            } else {
                n3 = this.mouseOverCharAt;
                n = this.mouseDownCharAt;
            }
        }
        TextSelection textSelection = TextSelection.getEmptyTextSelection();
        while (n4 < n2) {
            pDFReference = this.pv.getPageRef(n4++, transaction);
            wordy = VPageTextWordy.getVPageTextWordy(pDFReference).wordyValue(transaction);
            textSelection = textSelection.addToSelection(this.pv, pDFReference, n3, Integer.MAX_VALUE, transaction);
            n3 = 0;
        }
        pDFReference = this.pv.getPageRef(n2, transaction);
        wordy = VPageTextWordy.getVPageTextWordy(pDFReference).wordyValue(transaction);
        textSelection = textSelection.addToSelection(this.pv, pDFReference, n3, n - n3 + 1, transaction);
        this.pv.setSelection(transaction, textSelection);
    }

    private int getPageAt(Point point, Transaction transaction) throws Exception {
        int n = this.pv.getNumPages(transaction);
        int n2 = this.pv.getNumColumns(transaction);
        int n3 = this.pv.getNumRows(transaction);
        int n4 = this.pv.getTopLeftPage(transaction);
        int n5 = 0;
        while (n5 < n2 - 1) {
            if (point.x < this.pv.getNthColumnStart(n5 + 1, transaction)) break;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n3 - 1) {
            if (point.y < this.pv.getNthRowStart(n6 + 1, transaction)) break;
            ++n6;
        }
        int n7 = n4 + n6 * n2 + n5;
        if (n7 < 0) {
            n7 = 0;
        } else if (n7 >= n) {
            n7 = n - 1;
        }
        return n7;
    }

    public void mouseDragged(Transaction transaction, Point point) throws Exception {
        Rectangle rectangle = this.pv.getAperture(transaction);
        this.dragPoint.setLocation(point.x - rectangle.x, point.y - rectangle.y);
        this.dragRef.setLocation(this.dragPoint);
        if (this.dragPoint.x < 0) {
            this.dragPoint.x = 0;
        } else if (this.dragPoint.x >= rectangle.width) {
            this.dragPoint.x = rectangle.width - 1;
        }
        if (this.dragPoint.y < 0) {
            this.dragPoint.y = 0;
        } else if (this.dragPoint.y >= rectangle.height) {
            this.dragPoint.y = rectangle.height - 1;
        }
        this.scrollTo(transaction, this.dragPoint);
        this.mouseOverPoint = point;
        this.computeTextSelection(transaction);
        transaction.notifyStrobes();
    }

    public void mousePressed(Transaction transaction, MouseEvent mouseEvent) throws Exception {
        super.mousePressed(transaction, mouseEvent);
        this.mouseOverPoint = this.mouseDownPoint = mouseEvent.getPoint();
        this.computeTextSelection(transaction);
        transaction.notifyStrobes();
    }

    public void mouseReleased(Transaction transaction, Point point) throws Exception {
        super.mouseAborted(transaction);
        this.mouseOverPoint = point;
        this.computeTextSelection(transaction);
        transaction.notifyStrobes();
    }
}

