/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.TabEvent;
import com.adobe.acrobat.gui.TabListener;
import com.adobe.pe.awt.LightWeightPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TabbedPane
extends LightWeightPanel
implements TabListener {
    private Tab selectedTab;
    private Container contents;
    private CardLayout cards;
    private Container tabs;
    private Hashtable tabindex;
    private Insets insets = new Insets(1, 1, 1, 1);

    public TabbedPane() {
        this.setLayout(new BorderLayout());
        this.tabindex = new Hashtable();
        this.tabs = new Panel();
        this.tabs.setLayout(new TabsLayoutManager());
        this.contents = new LightWeightPanel();
        this.cards = new CardLayout(25, 45);
        this.contents.setLayout(this.cards);
        this.add((Component)this.tabs, "North");
        this.add((Component)this.contents, "Center");
    }

    public void addTab(String string, Component component) {
        Tab tab = new Tab(string);
        this.tabs.add(string, tab);
        tab.addTabListener(this);
        this.contents.add(string, component);
        this.tabindex.put(string.intern(), tab);
        this.tabs.invalidate();
    }

    public void doLayout() {
        this.tabs.validate();
        super.doLayout();
    }

    private Tab findTab(String string) {
        Enumeration enumeration = this.tabindex.keys();
        while (enumeration.hasMoreElements()) {
            Tab tab = (Tab)this.tabindex.get(enumeration.nextElement());
            if (!tab.getTabLabel().equals(string)) continue;
            return tab;
        }
        return null;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public static void main(String[] stringArray) {
        Panel panel = new Panel(new FlowLayout());
        panel.add(new Button("button one"));
        panel.add(new Label("hi there!"));
        Panel panel2 = new Panel(new FlowLayout());
        panel2.add(new Button("button"));
        panel2.add(new TextField("hi there!"));
        TabbedPane tabbedPane = new TabbedPane();
        tabbedPane.addTab("Tab One", new Label("First tab - 1"));
        tabbedPane.addTab("Tab Two", panel);
        tabbedPane.addTab("Tab Three", panel2);
        tabbedPane.selectTab("Tab One");
        Frame frame = new Frame("Test Tabs");
        frame.setLayout(new BorderLayout());
        frame.add((Component)tabbedPane, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(2);
            }
        });
        ((Component)frame).setSize(500, 500);
        frame.show();
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = this.tabs.getSize().height;
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(1, n3 + 1, n - 3, n2 - n3 - 3, true);
        Rectangle rectangle = this.selectedTab.getBounds();
        graphics.setColor(this.getBackground());
        graphics.drawLine(rectangle.x + 2, n3 + 1, rectangle.x + rectangle.width - 1, n3 + 1);
        graphics.setColor(this.getBackground().darker());
        graphics.drawLine(rectangle.x + rectangle.width - 1, n3 + 1, rectangle.x + rectangle.width - 1, n3 + 1);
        graphics.setColor(this.getForeground());
        super.paint(graphics);
    }

    public void selectTab(String string) {
        Tab tab = this.findTab(string);
        if (tab != null) {
            this.tabSelected(new TabEvent(tab));
        }
    }

    public void tabDeselected(TabEvent tabEvent) {
    }

    public void tabSelected(TabEvent tabEvent) {
        Tab tab = (Tab)tabEvent.getSource();
        if (this.selectedTab != null && tab != this.selectedTab) {
            this.selectedTab.setSelected(false);
        }
        this.selectedTab = tab;
        this.repaint();
        this.cards.show(this.contents, this.selectedTab.getTabLabel());
    }

    public class Tab
    extends Component
    implements MouseListener,
    FocusListener {
        private Vector listeners;
        private String label;
        private Dimension minSize;
        private Insets insets;
        private Font font;
        private boolean isMouseOn;
        private boolean gainedFocus;
        private boolean isSelected;
        private TabEvent event;

        public Tab(String string) {
            this.label = string;
            this.font = new Font("sanserif", 0, 12);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            this.minSize = new Dimension(fontMetrics.stringWidth(string) + 10, fontMetrics.getHeight() + 10);
            this.insets = new Insets(5, 5, 5, 5);
            this.isMouseOn = false;
            this.isSelected = false;
            this.addMouseListener(this);
            this.event = new TabEvent(this);
            this.listeners = new Vector();
            this.addFocusListener(this);
        }

        public void addTabListener(TabListener tabListener) {
            this.listeners.addElement(tabListener);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public Insets getInsets() {
            return this.insets;
        }

        public Dimension getMinimumSize() {
            return this.minSize;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public String getTabLabel() {
            return this.label;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.isSelected = true;
            this.repaint();
            this.updateListeners();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.isMouseOn = true;
            this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getDefaultCursor());
            this.isMouseOn = false;
            this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setFont(this.font);
            int n = this.getSize().height;
            int n2 = this.getSize().width;
            graphics.setColor(this.getBackground().brighter());
            graphics.drawRect(0, 0, n2 - 1, n - 1);
            graphics.setColor(this.getBackground());
            graphics.drawLine(1, n - 1, n2 - 2, n - 1);
            if (this.isSelected) {
                graphics.setColor(this.getBackground().darker().darker());
                graphics.drawLine(n2 - 1, n - 1, n2 - 1, 2);
                graphics.setColor(this.getBackground().darker());
                graphics.drawLine(n2 - 2, n - 1, n2 - 2, 1);
            }
            if (this.gainedFocus) {
                graphics.setColor(this.getBackground().darker());
                graphics.drawRect(3, 3, n2 - 6, n - 6);
            }
            graphics.setColor(this.getForeground());
            graphics.drawString(this.label, this.insets.left, n - this.insets.bottom - 1);
            if (this.isMouseOn) {
                graphics.drawLine(this.insets.left, n - this.insets.bottom, this.getSize().width - 10, n - this.insets.bottom);
            }
        }

        public void removeTabListener(TabListener tabListener) {
            this.listeners.removeElement(tabListener);
        }

        public void setSelected(boolean bl) {
            this.isSelected = false;
            this.repaint();
            this.updateListeners();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        private void updateListeners() {
            int n = 0;
            while (n < this.listeners.size()) {
                TabListener tabListener = (TabListener)this.listeners.elementAt(n);
                if (this.isSelected) {
                    tabListener.tabSelected(this.event);
                } else {
                    tabListener.tabDeselected(this.event);
                }
                ++n;
            }
        }
    }

    public class TabsLayoutManager
    implements LayoutManager {
        private Vector tabs = new Vector();
        private Dimension minSize = new Dimension();

        public void addLayoutComponent(String string, Component component) {
            this.tabs.addElement(component);
        }

        public void layoutContainer(Container container) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.tabs.size()) {
                Tab tab = (Tab)container.getComponent(n3);
                Dimension dimension = tab.getPreferredSize();
                tab.setBounds(n2, 0, dimension.width, dimension.height);
                n = Math.max(n, dimension.height);
                n2 += dimension.width;
                ++n3;
            }
            this.minSize.setSize(n2, n);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.minSize;
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minSize;
        }

        public void removeLayoutComponent(Component component) {
            this.tabs.removeElement(component);
        }
    }
}

