/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ComboButton;
import com.adobe.acrobat.gui.GoToPageDialog;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.vtypes.VBoolean;

public class PageButton
extends ComboButton
implements VObserver,
StrobeContainer {
    private AcroViewContext context;
    private PageView pv;
    private VStrobe strobe;

    public PageButton(AcroViewContext acroViewContext) {
        super(null, "page.gif", true);
        this.context = acroViewContext;
        this.pv = acroViewContext.getPageView();
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            VBoolean vBoolean = SimpleUIVerb.getVDocIsOpenBoolean(this.context);
            if (vBoolean.booleanValue(requester)) {
                int n = this.pv.getCurrentPage(requester);
                int n2 = this.pv.getNumPages(requester);
                if (n == -1) {
                    this.setString(Util.getAcroViewContextString("GoToPageButton:NumPages", new Integer(n2)));
                } else {
                    this.setString(Util.getAcroViewContextString("GoToPageButton:PageXOfY", new Integer(n + 1), new Integer(n2)));
                }
            } else {
                this.setString("");
            }
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            this.setString("");
        }
        this.invalidate();
        this.repaint();
    }

    public boolean isEnabled() {
        boolean bl = false;
        try {
            bl = super.isEnabled() && this.pv.getNumPages(null) > 1;
        }
        catch (Exception exception) {}
        return bl;
    }

    public void performComboButtonAction() {
        new GoToPageDialog(this.context);
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

