/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.PVNavigationVerb;
import com.adobe.acrobat.gui.PageView;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.util.Assert;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Hashtable;

public class PVNavigation
implements ExtensionDataProvider {
    static final int kLineSize = 15;
    static final String PVNavigationVerbTable_K = "PVNavigationVerbTable";
    private static ExtensionDataProvider provider = null;

    private PVNavigation() {
    }

    private static int computeDelta(PageView pageView, boolean bl, Requester requester) throws Exception {
        if (bl) {
            return 15;
        }
        Dimension dimension = pageView.getApertureSize(requester);
        return dimension.height - 15;
    }

    public static synchronized UIVerb getUIVerb(PageView pageView, String string) {
        PVNavigation.initProvider();
        Hashtable hashtable = (Hashtable)pageView.getExtensionData(PVNavigationVerbTable_K);
        UIVerb uIVerb = (UIVerb)hashtable.get(string);
        if (uIVerb == null) {
            uIVerb = new PVNavigationVerb(pageView, string);
            hashtable.put(string, uIVerb);
        }
        return uIVerb;
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new PVNavigation();
            Extension.registerProvider(PVNavigationVerbTable_K, provider);
        }
    }

    static void pageScroll(Transaction transaction, PageView pageView, boolean bl, boolean bl2) throws Exception {
        pageView.suspendNavigation(transaction);
        Point point = pageView.getScrollPosition(transaction);
        if (bl) {
            int n = 0;
            if (point.y <= n) {
                int n2 = pageView.getTopLeftPage(transaction);
                if (n2 > 0) {
                    int n3 = pageView.getNumColumns(transaction) * pageView.getNumRows(transaction);
                    int n4 = pageView.getNumPages(transaction);
                    int n5 = n2 - n3;
                    pageView.goToPageGalley(transaction, n5);
                    int n6 = pageView.getVScrollMax(transaction);
                    pageView.scrollTo(transaction, new Point(point.x, n6));
                }
            } else {
                int n7 = -PVNavigation.computeDelta(pageView, bl2, transaction);
                int n8 = Math.max(n, point.y + n7);
                pageView.scrollTo(transaction, new Point(point.x, n8));
            }
        } else {
            int n = pageView.getVScrollMax(transaction);
            if (n == 0 || point.y >= n) {
                int n9;
                int n10 = pageView.getNumColumns(transaction) * pageView.getNumRows(transaction);
                int n11 = pageView.getTopLeftPage(transaction);
                int n12 = n11 + n10;
                if (n12 < (n9 = pageView.getNumPages(transaction))) {
                    pageView.goToPageGalley(transaction, n12);
                    pageView.scrollTo(transaction, new Point(point.x, 0));
                }
            } else {
                int n13 = PVNavigation.computeDelta(pageView, bl2, transaction);
                int n14 = Math.min(n, point.y + n13);
                pageView.scrollTo(transaction, new Point(point.x, n14));
            }
        }
        pageView.resumeNavigation(transaction);
    }

    static boolean pageScrollEnabled(PageView pageView, boolean bl, Requester requester) throws Exception {
        Point point = pageView.getScrollPosition(requester);
        if (bl) {
            int n = 0;
            if (point.y <= n) {
                int n2 = pageView.getTopLeftPage(requester);
                return n2 > 0;
            }
        } else {
            int n = pageView.getVScrollMax(requester);
            if (point.y >= n) {
                int n3;
                int n4;
                int n5 = pageView.getTopLeftPage(requester);
                return n5 + (n4 = pageView.getNumColumns(requester) * pageView.getNumRows(requester)) < (n3 = pageView.getNumPages(requester));
            }
        }
        return true;
    }

    public Object provide(String string, Extensible extensible) {
        Assert.notFalse(extensible instanceof PageView);
        if (string.equals(PVNavigationVerbTable_K)) {
            return new Hashtable();
        }
        throw new ProviderNotFoundException(string);
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        PageView pageView = acroViewContext.getPageView();
        CommandRegistry.addCommand(PVNavigation.getUIVerb(pageView, "FirstPage"), acroViewContext, "FirstPage");
        CommandRegistry.addCommand(PVNavigation.getUIVerb(pageView, "LastPage"), acroViewContext, "LastPage");
        CommandRegistry.addCommand(PVNavigation.getUIVerb(pageView, "PrevPage"), acroViewContext, "PrevPage");
        CommandRegistry.addCommand(PVNavigation.getUIVerb(pageView, "NextPage"), acroViewContext, "NextPage");
        CommandRegistry.addCommand(PVNavigation.getUIVerb(pageView, "PageUp"), acroViewContext, "PageUp");
        CommandRegistry.addCommand(PVNavigation.getUIVerb(pageView, "PageDown"), acroViewContext, "PageDown");
        CommandRegistry.addCommand(PVNavigation.getUIVerb(pageView, "LineUp"), acroViewContext, "LineUp");
        CommandRegistry.addCommand(PVNavigation.getUIVerb(pageView, "LineDown"), acroViewContext, "LineDown");
        CommandRegistry.addCommand(PVNavigation.getUIVerb(pageView, "GoToPage"), acroViewContext, "GoToPage");
    }

    public static void scrollTo(Transaction transaction, PageView pageView, Point point) throws Exception {
        pageView.suspendNavigation(transaction);
        pageView.scrollTo(transaction, point);
        pageView.resumeNavigation(transaction);
    }
}

