/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.bytearray.MemByteArray;
import com.adobe.acrobat.gui.AnnotView;
import com.adobe.acrobat.gui.NotesFrame;
import com.adobe.acrobat.gui.VisiblePage;
import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.pdf.AppearancePainting;
import com.adobe.acrobat.pdf.VAnnotBoundingBox;
import com.adobe.acrobat.pdf.VPDFColorValue;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFDirectObj;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.PDFUnfilteredStreamFactory;
import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.util.Util;
import com.adobe.acrobat.vtypes.VColorValue;
import com.adobe.pe.awt.MouseTransactionClient;
import com.adobe.pe.awt.VRectangle;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.painting.Painting;
import com.adobe.pe.painting.VPainting;
import com.adobe.pe.util.PEUtil;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class NotesAnnotView
extends AnnotView
implements MouseTransactionClient {
    private static final String Popup_K = "Popup";
    private static final String C_K = "C";
    boolean hasAppearances;
    boolean hasPopup;
    private VString statusVString;
    private NotesFrame frame;
    private Frame parentFrame;
    VBoolean vHilite = new VBoolean(false);
    private static final String Dest_K = "Dest";
    private static final String A_K = "A";
    private static final String defaultTextAppearance1 = "q 0.5 g 0.75 G 0 i 4 M 2.0938 18.2158 m 2.0938 0.5 l 12.0962 0.5 l 17.1577 5.5615 l 17.1577 18.2158 l 2.0938 18.2158 l h B ";
    private static final String defaultTextAppearance2 = " rg 0 G 0.5 19.8096 m 0.5 2.0938 l 10.5024 2.0938 l 15.564 7.1553 l 15.564 19.8096 l 0.5 19.8096 l h B 10.46 2.1338 m 10.46 7.167 l 15.5225 7.208 l S 4.0537 15.9824 m 12.0537 15.9824 l S 4.0537 12.9824 m 12.0537 12.9824 l S 4.0537 9.9824 m 8.9912 9.9824 l S Q";
    private static final Rectangle defaultTextRect = new Rectangle(0, 0, 20, 24);

    NotesAnnotView(VisiblePage visiblePage, String string, PDFReference pDFReference, Requester requester) throws Exception {
        super(visiblePage, string, pDFReference, requester);
        PDFDict pDFDict = pDFReference.dictValue(requester);
        this.hasAppearances = pDFDict.hasKey("AP");
        this.hasPopup = pDFDict.hasKey(Popup_K);
    }

    protected Rectangle annotBoundsDeviceSpace(Requester requester) throws Exception {
        Rectangle rectangle = super.annotBoundsDeviceSpace(requester);
        if (!this.hasPopup) {
            rectangle.width = NotesAnnotView.defaultTextRect.width + 1;
            rectangle.height = NotesAnnotView.defaultTextRect.height + 1;
        }
        return rectangle;
    }

    protected FloatRect annotBoundsUserSpace(Requester requester) throws Exception {
        FloatRect floatRect;
        if (this.hasPopup) {
            floatRect = super.annotBoundsUserSpace(requester);
        } else {
            AffineTransform affineTransform = this.annotTransform(requester);
            AffineTransform affineTransform2 = affineTransform.getInverse();
            floatRect = new FloatRect(this.annotBoundsDeviceSpace(requester));
            floatRect = floatRect.transformRect(affineTransform2);
        }
        return floatRect;
    }

    protected Painting createAppearancePainting(Requester requester, String string) throws Exception {
        if (this.hasAppearances) {
            return super.createAppearancePainting(requester, string);
        }
        return this.defaultNoteAppearance(requester);
    }

    private Painting defaultNoteAppearance(Requester requester) throws Exception {
        Color color = this.highlightColor(requester);
        String string = String.valueOf((double)color.getRed() / 255.0) + " " + (double)color.getGreen() / 255.0 + " " + (double)color.getBlue() / 255.0;
        MemByteArray memByteArray = new MemByteArray(Util.rawBytesFromString(defaultTextAppearance1 + string + defaultTextAppearance2));
        PDFUnfilteredStreamFactory pDFUnfilteredStreamFactory = new PDFUnfilteredStreamFactory(memByteArray, 0, memByteArray.getLength(), true);
        String[] stringArray = new String[]{};
        PDFObj[] pDFObjArray = new PDFObj[]{};
        PDFDict pDFDict = new PDFDict(stringArray, pDFObjArray);
        PDFDirectObj pDFDirectObj = new PDFDirectObj(null, pDFDict);
        ContentArray contentArray = new ContentArray(pDFDirectObj, pDFUnfilteredStreamFactory, null);
        FloatRect floatRect = this.annotBoundsUserSpace(requester);
        AffineTransform affineTransform = this.annotTransform(requester);
        AffineTransform affineTransform2 = AffineTransform.getIdentityMatrix();
        FloatRect floatRect2 = new FloatRect(defaultTextRect);
        return new AppearancePainting(affineTransform, floatRect, contentArray, affineTransform2, floatRect2, requester);
    }

    public synchronized void finalize() throws Exception {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    public Cursor getCursor(Requester requester) throws Exception {
        return Cursor.getDefaultCursor();
    }

    protected boolean getFlag(int n, Requester requester) throws Exception {
        if (this.hasAppearances) {
            return super.getFlag(n, requester);
        }
        return (0x18 & n) != 0;
    }

    public VString getStatusVString() {
        if (this.statusVString == null) {
            this.statusVString = new VNotesAnnotStatusString();
        }
        return this.statusVString;
    }

    public VRectangle getVBounds() {
        if (this.vBounds == null) {
            this.vBounds = new VNotesAnnotDeviceRect();
        }
        return this.vBounds;
    }

    public VPainting getVPainting() {
        if (this.vPainting == null) {
            this.vPainting = new VNotesAnnotPainting();
        }
        return this.vPainting;
    }

    protected Color highlightColor(Requester requester) throws Exception {
        PDFDict pDFDict = this.annotRef.dictValue(requester);
        if (pDFDict.hasKey(C_K)) {
            VColorValue vColorValue = VPDFColorValue.getVPDFColorValue(pDFDict.get(C_K).pdfReferenceValue(requester));
            return vColorValue.colorValue(requester).getRGBColor();
        }
        return Color.yellow;
    }

    public synchronized void isInvisible(Requester requester) {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    public void mouseAborted(Transaction transaction) throws Exception {
        this.vHilite.setBooleanValue(transaction, false);
    }

    public void mouseDragged(Transaction transaction, Point point) throws Exception {
        Rectangle rectangle = this.getVBounds().rectangleValue(transaction);
        this.vHilite.setBooleanValue(transaction, rectangle.contains(point));
        transaction.notifyStrobes();
    }

    public boolean mouseHover(Requester requester, Point point) throws Exception {
        return true;
    }

    public void mousePressed(Transaction transaction, MouseEvent mouseEvent) throws Exception {
        this.vHilite.setBooleanValue(transaction, true);
    }

    public void mouseReleased(Transaction transaction, Point point) throws Exception {
        block4: {
            this.vHilite.setBooleanValue(transaction, false);
            Rectangle rectangle = this.getVBounds().rectangleValue(transaction);
            if (!rectangle.contains(point)) break block4;
            AffineTransform affineTransform = this.vp.vGalleyTransform.affineTransformValue(transaction);
            if (affineTransform == null) {
                this.perform(transaction);
            } else {
                try {
                    affineTransform = affineTransform.getInverse();
                    FloatRect floatRect = VAnnotBoundingBox.getVAnnotBoundingBox(this.annotRef).floatRectValue(transaction);
                    FloatPoint floatPoint = new FloatPoint(point).deltaTransform(affineTransform);
                    floatPoint.x -= floatRect.getxMin();
                    floatPoint.y = floatRect.getyMax() - floatPoint.y;
                    this.perform(transaction, floatPoint);
                }
                catch (AffineException affineException) {
                    this.perform(transaction);
                }
            }
        }
    }

    private void perform(Transaction transaction) throws Exception {
        this.perform(transaction, null);
    }

    private void perform(final Transaction transaction, FloatPoint floatPoint) throws Exception {
        PDFDict pDFDict = this.annotRef.dictValue(transaction);
        this.parentFrame = PEUtil.getFrame(this.vp.pv.getDisplayComponent());
        if (this.frame == null) {
            FloatRect floatRect;
            Object object;
            this.frame = new NotesFrame(PEUtil.getFrame(this.vp.pv.getDisplayComponent()));
            this.frame.setTitleColor(this.highlightColor(transaction));
            if (this.hasPopup) {
                object = pDFDict.get(Popup_K).dictValue(transaction).get("Rect").arrayValue(transaction);
                int n = (int)((PDFArray)object).get(0).floatValue(transaction);
                int n2 = (int)((PDFArray)object).get(1).floatValue(transaction);
                int n3 = (int)((PDFArray)object).get(2).floatValue(transaction);
                int n4 = (int)((PDFArray)object).get(3).floatValue(transaction);
                floatRect = new FloatRect(n, n2, n3, n4);
                floatRect = floatRect.upright();
            } else {
                floatRect = VAnnotBoundingBox.getVAnnotBoundingBox(this.annotRef).floatRectValue(transaction);
            }
            ((Component)this.frame).setBounds(this.toScreenSpace(transaction, floatRect));
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    try {
                        vHilite.setBooleanValue(transaction, false);
                        transaction.notifyStrobes();
                    }
                    catch (Exception exception) {}
                }
            });
            object = "";
            String string = "";
            if (pDFDict.hasKey("Contents")) {
                object = pDFDict.get("Contents").stringValue(transaction);
            }
            if (pDFDict.hasKey("T")) {
                string = pDFDict.get("T").stringValue(transaction);
            }
            this.frame.setTitle(string);
            this.frame.setContent((String)object);
        }
        if (this.frame.isVisible()) {
            this.frame.setVisible(false);
            this.setPopupWindow(null);
        } else {
            this.frame.setVisible(true);
            this.setPopupWindow(this.frame);
        }
    }

    public boolean sizeInUserSpace(Requester requester) throws Exception {
        return false;
    }

    private Rectangle toScreenSpace(Transaction transaction, FloatRect floatRect) throws Exception {
        AffineTransform affineTransform = this.vp.vGalleyTransform.affineTransformValue(transaction);
        FloatRect floatRect2 = floatRect.transformRect(affineTransform);
        Rectangle rectangle = floatRect2.toRect();
        Point point = this.parentFrame.getLocationOnScreen();
        rectangle.x += point.x;
        rectangle.y += point.y;
        return rectangle;
    }

    public MouseTransactionClient wantsMouseTransactionControl(Transaction transaction, MouseEvent mouseEvent) {
        return this;
    }

    class VNotesAnnotStatusString
    extends VString {
        VNotesAnnotStatusString() {
        }

        protected final String computeString(Requester requester) throws Exception {
            PDFDict pDFDict = NotesAnnotView.this.annotRef.dictValue(requester);
            return pDFDict.get("T").stringValue(requester);
        }
    }

    class VNotesAnnotPainting
    extends VPainting {
        VNotesAnnotPainting() {
        }

        public Painting computePainting(Requester requester) throws Exception {
            boolean bl = NotesAnnotView.this.vHilite.booleanValue(requester);
            return NotesAnnotView.this.createPainting(requester, bl);
        }
    }

    class VNotesAnnotDeviceRect
    extends VRectangle {
        VNotesAnnotDeviceRect() {
        }

        protected final Rectangle computeRectangle(Requester requester) throws Exception {
            return NotesAnnotView.this.annotBoundsDeviceSpace(requester);
        }
    }
}

