/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.ActionHandler;
import com.adobe.acrobat.gui.AnnotView;
import com.adobe.acrobat.gui.GoToActionHandler;
import com.adobe.acrobat.gui.VisiblePage;
import com.adobe.acrobat.pdf.VAnnotBoundingBox;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.pe.awt.MouseTransactionClient;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.painting.Painting;
import com.adobe.pe.painting.VPainting;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VString;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Dictionary;

class LinkAnnotView
extends AnnotView
implements MouseTransactionClient {
    private VString statusVString;
    private static final String GoTo_K = "GoTo";
    private VPainting vPainting = null;
    VBoolean vHilite = new VBoolean(false);
    private static final String Dest_K = "Dest";
    private static final String A_K = "A";

    LinkAnnotView(VisiblePage visiblePage, String string, PDFReference pDFReference, Requester requester) throws Exception {
        super(visiblePage, string, pDFReference, requester);
    }

    public Cursor getCursor(Requester requester) throws Exception {
        return Cursor.getPredefinedCursor(12);
    }

    public VString getStatusVString() {
        if (this.statusVString != null) {
            try {
                String string = this.statusVString.stringValue(null);
                if (string == null) {
                    this.statusVString = null;
                }
            }
            catch (Exception exception) {
                this.statusVString = null;
            }
        }
        if (this.statusVString == null) {
            this.statusVString = new VLinkAnnotStatusString();
        }
        return this.statusVString;
    }

    public VPainting getVPainting() {
        if (this.vPainting == null) {
            this.vPainting = new VLinkAnnotPainting();
        }
        return this.vPainting;
    }

    public void mouseAborted(Transaction transaction) throws Exception {
        this.vHilite.setBooleanValue(transaction, false);
    }

    public void mouseDragged(Transaction transaction, Point point) throws Exception {
        Rectangle rectangle = this.getVBounds().rectangleValue(transaction);
        this.vHilite.setBooleanValue(transaction, rectangle.contains(point));
        transaction.notifyStrobes();
    }

    public boolean mouseHover(Requester requester, Point point) throws Exception {
        return true;
    }

    public void mousePressed(Transaction transaction, MouseEvent mouseEvent) throws Exception {
        this.vHilite.setBooleanValue(transaction, true);
    }

    public void mouseReleased(Transaction transaction, Point point) throws Exception {
        block4: {
            this.vHilite.setBooleanValue(transaction, false);
            Rectangle rectangle = this.getVBounds().rectangleValue(transaction);
            if (!rectangle.contains(point)) break block4;
            AffineTransform affineTransform = this.vp.vGalleyTransform.affineTransformValue(transaction);
            if (affineTransform == null) {
                this.perform(transaction);
            } else {
                try {
                    affineTransform = affineTransform.getInverse();
                    FloatRect floatRect = VAnnotBoundingBox.getVAnnotBoundingBox(this.annotRef).floatRectValue(transaction);
                    FloatPoint floatPoint = new FloatPoint(point).deltaTransform(affineTransform);
                    floatPoint.x -= floatRect.getxMin();
                    floatPoint.y = floatRect.getyMax() - floatPoint.y;
                    this.perform(transaction, floatPoint);
                }
                catch (AffineException affineException) {
                    this.perform(transaction);
                }
            }
        }
    }

    private void perform(Transaction transaction) throws Exception {
        PDFDict pDFDict = this.annotRef.dictValue(transaction);
        if (pDFDict.hasKey(Dest_K)) {
            GoToActionHandler.goToDest(transaction, pDFDict.get(Dest_K), this.pv.getAcroViewContext());
        } else if (pDFDict.hasKey(A_K)) {
            Dictionary dictionary = this.createActionParamsDictionary(transaction);
            ActionHandler.performAction(transaction, pDFDict.get(A_K).pdfReferenceValue(transaction), dictionary);
        }
    }

    private void perform(Transaction transaction, FloatPoint floatPoint) throws Exception {
        PDFDict pDFDict = this.annotRef.dictValue(transaction);
        if (pDFDict.hasKey(Dest_K)) {
            GoToActionHandler.goToDest(transaction, pDFDict.get(Dest_K), this.vp.pageNum, this.pv.getAcroViewContext());
        } else if (pDFDict.hasKey(A_K)) {
            Dictionary dictionary = this.createActionParamsDictionary(transaction);
            dictionary.put("MouseLocation", new Point((int)Math.round(floatPoint.x), (int)Math.round(floatPoint.y)));
            ActionHandler.performAction(transaction, pDFDict.get(A_K).pdfReferenceValue(transaction), dictionary);
        }
    }

    public MouseTransactionClient wantsMouseTransactionControl(Transaction transaction, MouseEvent mouseEvent) {
        return this;
    }

    class VLinkAnnotStatusString
    extends VString {
        VLinkAnnotStatusString() {
        }

        protected final String computeString(Requester requester) throws Exception {
            PDFDict pDFDict = LinkAnnotView.this.annotRef.dictValue(requester);
            Dictionary dictionary = LinkAnnotView.this.createActionParamsDictionary(requester);
            if (pDFDict.hasKey(LinkAnnotView.Dest_K)) {
                return GoToActionHandler.getStatusText(LinkAnnotView.GoTo_K, pDFDict.get(LinkAnnotView.Dest_K), LinkAnnotView.this.vp.pageNum, LinkAnnotView.this.pv.getAcroViewContext(), requester);
            }
            if (pDFDict.hasKey(LinkAnnotView.A_K)) {
                return ActionHandler.getStatusText(pDFDict.get(LinkAnnotView.A_K).pdfReferenceValue(requester), dictionary, requester);
            }
            return "";
        }
    }

    class VLinkAnnotPainting
    extends VPainting {
        VLinkAnnotPainting() {
        }

        public Painting computePainting(Requester requester) throws Exception {
            boolean bl = LinkAnnotView.this.vHilite.booleanValue(requester);
            return LinkAnnotView.this.createPainting(requester, bl);
        }
    }
}

