/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ActionHandler;
import com.adobe.acrobat.gui.GoToActionInfo;
import com.adobe.acrobat.gui.PVNavigation;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.VGoToActionInfo;
import com.adobe.acrobat.gui.ViewerFrame;
import com.adobe.acrobat.gui.VisiblePage;
import com.adobe.acrobat.pdf.FileSpec;
import com.adobe.acrobat.pdf.NameTree;
import com.adobe.acrobat.pdf.VDestinationByName;
import com.adobe.acrobat.pdf.VNameTree;
import com.adobe.acrobat.pdf.VPageProps;
import com.adobe.acrobat.pdf.VPageRefByNum;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFNull;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import java.awt.Point;
import java.util.Dictionary;

public class GoToActionHandler
extends ActionHandler {
    private static final String Fit_K = "Fit";
    private static final String FitH_K = "FitH";
    private static final String FitV_K = "FitV";
    private static final String XYZ_K = "XYZ";
    private static final String FitR_K = "FitR";
    private static final String Dests_K = "Dests";
    public static final String GoTo_K = "GoTo";
    public static final String GoToR_K = "GoToR";
    public static final String Thread_K = "Thread";
    private static final String D_K = "D";
    private static final String I_K = "I";
    private static final String Title_K = "Title";

    private static float computeSide(Requester requester, PDFArray pDFArray, int n, float f) throws Exception {
        PDFObj pDFObj = GoToActionHandler.filterOutFixedNegativeInfinity(pDFArray.get(n), requester);
        if (pDFObj.type(requester) == 0) {
            return f;
        }
        return pDFObj.floatValue(requester);
    }

    private static PDFObj filterOutFixedNegativeInfinity(PDFObj pDFObj, Requester requester) throws Exception {
        float f;
        if (pDFObj.type(requester) != 0 && (double)(f = pDFObj.floatValue(requester)) == -32768.0) {
            return PDFNull.getPDFNull();
        }
        return pDFObj;
    }

    static GoToActionInfo getActionInfo(String string, PDFObjStore pDFObjStore, PDFObj pDFObj, Requester requester) throws Exception {
        int n = pDFObj.type(requester);
        VGoToActionInfo vGoToActionInfo = null;
        switch (n) {
            case 6: 
            case 7: {
                vGoToActionInfo = VGoToActionInfo.getVGoToActionInfo(pDFObj.pdfReferenceValue(requester));
                break;
            }
            case 5: {
                VPDFReference vPDFReference = VDestinationByName.getVDestinationByName(pDFObjStore, pDFObj.nameValue(requester));
                vGoToActionInfo = VGoToActionInfo.getVGoToActionInfo(vPDFReference.pdfReferenceValue(requester));
                break;
            }
            case 4: {
                if (string.equals(GoToR_K)) {
                    GoToActionInfo goToActionInfo = new GoToActionInfo();
                    goToActionInfo.destName = pDFObj.stringValue(requester);
                    return goToActionInfo;
                }
                NameTree nameTree = VNameTree.getVNameTreeNamed(pDFObjStore, Dests_K).nameTreeValue(requester);
                if (nameTree != null) {
                    VPDFObj vPDFObj = nameTree.getVPDFObjNamed(pDFObj.stringValue(requester));
                    PDFObj pDFObj2 = vPDFObj.pdfObjValue(requester);
                    vGoToActionInfo = VGoToActionInfo.getVGoToActionInfo(pDFObj2.pdfReferenceValue(requester));
                    break;
                }
                throw new Exception(Util.getErrorString("GoTo:MissingNameTree"));
            }
            default: {
                throw new Exception(Util.getErrorString("GoTo:UnknownDestinationType"));
            }
        }
        return vGoToActionInfo.goToActionInfoValue(requester);
    }

    public static String getStatusText(String string, PDFObj pDFObj, int n, AcroViewContext acroViewContext, Requester requester) throws Exception {
        Object object;
        Object object2;
        int n2 = pDFObj.type(requester);
        VGoToActionInfo vGoToActionInfo = null;
        switch (n2) {
            case 7: {
                PDFReference pDFReference = pDFObj.pdfReferenceValue(requester);
                if (VGoToActionInfo.vGoToActionInfoIsAvailable(pDFReference)) {
                    vGoToActionInfo = VGoToActionInfo.getVGoToActionInfo(pDFReference);
                    break;
                }
                return null;
            }
            case 6: {
                PDFReference pDFReference = pDFObj.pdfReferenceValue(requester);
                if (VGoToActionInfo.vGoToActionInfoIsAvailable(pDFReference)) {
                    vGoToActionInfo = VGoToActionInfo.getVGoToActionInfo(pDFReference);
                    break;
                }
                PDFDict pDFDict = pDFReference.dictValue(requester);
                if (string.equals(Thread_K)) {
                    if (pDFDict.hasKey(D_K) && (pDFObj = pDFDict.get(D_K)).type(requester) == 6 && (pDFDict = pDFObj.dictValue(requester)).hasKey(I_K) && (pDFObj = pDFDict.get(I_K)).type(requester) == 6 && (pDFDict = pDFObj.dictValue(requester)).hasKey(Title_K) && (pDFObj = pDFDict.get(Title_K)).type(requester) == 4) {
                        return pDFObj.stringValue(requester);
                    }
                } else if (pDFDict.hasKey("S") && pDFDict.hasKey("F") && (string = pDFDict.get("S").nameValue(requester)).equals(GoToR_K) && (pDFObj = pDFDict.get("F")).type(requester) == 4) {
                    String string2 = pDFObj.stringValue(requester);
                    return Util.getAcroViewContextString("StatusText:GoTo", string2);
                }
                return null;
            }
            case 5: {
                String string3 = pDFObj.nameValue(requester);
                object2 = VDestinationByName.getVDestinationByName(acroViewContext.getPDFObjStore(requester), string3);
                PDFReference pDFReference = ((VPDFReference)object2).pdfReferenceValue(requester);
                if (VGoToActionInfo.vGoToActionInfoIsAvailable(pDFReference)) {
                    vGoToActionInfo = VGoToActionInfo.getVGoToActionInfo(pDFReference);
                    break;
                }
                return Util.getAcroViewContextString("StatusText:GoTo", string3);
            }
            case 4: {
                VPDFObj vPDFObj;
                PDFObj pDFObj2;
                String string4 = pDFObj.stringValue(requester);
                if (!string.equals(GoToR_K) && (object = VNameTree.getVNameTreeNamed(acroViewContext.getPDFObjStore(requester), Dests_K).nameTreeValue(requester)) != null && ((NameTree)object).knowsVPDFObjNamed(string4) && VGoToActionInfo.vGoToActionInfoIsAvailable((pDFObj2 = (vPDFObj = ((NameTree)object).getVPDFObjNamed(string4)).pdfObjValue(requester)).pdfReferenceValue(requester))) {
                    vGoToActionInfo = VGoToActionInfo.getVGoToActionInfo(pDFObj2.pdfReferenceValue(requester));
                    break;
                }
                return Util.getAcroViewContextString("StatusText:GoTo", string4);
            }
            default: {
                throw new Exception(Util.getErrorString("GoTo:UnknownDestinationType"));
            }
        }
        object2 = vGoToActionInfo.goToActionInfoValue(requester);
        object = acroViewContext.getPageView();
        int n3 = n;
        int n4 = ((PageView)object).getNumPages(requester) - 1;
        PDFObjStore pDFObjStore = acroViewContext.getPDFObjStore(requester);
        if (object2 == null) {
            return "";
        }
        if (((GoToActionInfo)object2).destObj == null) {
            n3 = ((GoToActionInfo)object2).pageNumRelative ? (n3 += ((GoToActionInfo)object2).pageNum) : ((GoToActionInfo)object2).pageNum;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > n4) {
                n3 = n4;
            }
            return Util.getAcroViewContextString("StatusText:GoToPage", new Integer(n3 + 1));
        }
        String string5 = FileSpec.getFileString(((GoToActionInfo)object2).destObj, requester);
        if (((GoToActionInfo)object2).destName != null) {
            string5 = String.valueOf(string5) + ":  " + ((GoToActionInfo)object2).destName;
        }
        return Util.getAcroViewContextString("StatusText:GoTo", string5);
    }

    public String getStatusText(String string, PDFReference pDFReference, Dictionary dictionary, Requester requester) throws Exception {
        VisiblePage visiblePage = (VisiblePage)dictionary.get("VisiblePage");
        int n = 0;
        if (visiblePage != null) {
            n = visiblePage.pageNum;
        }
        return GoToActionHandler.getStatusText(string, pDFReference, n, (AcroViewContext)dictionary.get("AcroViewContext"), requester);
    }

    public static void goToDest(Transaction transaction, PDFObj pDFObj, int n, AcroViewContext acroViewContext) throws Exception {
        GoToActionHandler.goToDest(transaction, GoTo_K, n, GoToActionHandler.getActionInfo(GoTo_K, acroViewContext.getPDFObjStore(transaction), pDFObj, transaction), acroViewContext);
    }

    public static void goToDest(Transaction transaction, PDFObj pDFObj, AcroViewContext acroViewContext) throws Exception {
        int n = acroViewContext.getPageView().getCurrentPage(transaction);
        if (n == -1) {
            n = 0;
        }
        GoToActionHandler.goToDest(transaction, GoTo_K, n, GoToActionHandler.getActionInfo(GoTo_K, acroViewContext.getPDFObjStore(transaction), pDFObj, transaction), acroViewContext);
    }

    private static void goToDest(Transaction transaction, String string, int n, GoToActionInfo goToActionInfo, AcroViewContext acroViewContext) throws Exception {
        PDFArray pDFArray;
        Object object;
        Object object2;
        PageView pageView = acroViewContext.getPageView();
        int n2 = n;
        int n3 = pageView.getNumPages(transaction) - 1;
        FloatPoint floatPoint = pageView.getOriginForPage(n2, transaction);
        if (floatPoint == null) {
            floatPoint = new FloatPoint(0.0, 0.0);
        }
        FloatPoint floatPoint2 = new FloatPoint(0.0, 0.0);
        boolean bl = false;
        PDFObjStore pDFObjStore = pageView.getPDFObjStore(transaction);
        if (goToActionInfo.destObj != null) {
            NameTree nameTree;
            ByteArraySource byteArraySource = FileSpec.getByteArraySource(goToActionInfo.destObj, goToActionInfo.store, transaction);
            if (goToActionInfo.newWindow) {
                AcroViewContext acroViewContext2 = new AcroViewContext(transaction, byteArraySource);
                ViewerFrame viewerFrame = new ViewerFrame(acroViewContext2, transaction);
                GoToActionInfo goToActionInfo2 = new GoToActionInfo();
                goToActionInfo2.pageNum = goToActionInfo.pageNum;
                goToActionInfo2.pageNumRelative = goToActionInfo.pageNumRelative;
                goToActionInfo2.destArray = goToActionInfo.destArray;
                goToActionInfo2.destName = goToActionInfo.destName;
                GoToActionHandler.goToDest(transaction, string, n, goToActionInfo2, acroViewContext2);
                viewerFrame.show();
                return;
            }
            acroViewContext.setByteArraySource(transaction, byteArraySource);
            pDFObjStore = pageView.getPDFObjStore(transaction);
            n3 = pageView.getNumPages(transaction) - 1;
            if (goToActionInfo.destName != null && (nameTree = VNameTree.getVNameTreeNamed(pDFObjStore, Dests_K).nameTreeValue(transaction)) != null && (object2 = ((VPDFObj)(object = nameTree.getVPDFObjNamed(goToActionInfo.destName))).pdfObjValue(transaction)) != null) {
                VGoToActionInfo vGoToActionInfo = VGoToActionInfo.getVGoToActionInfo(((PDFObj)object2).pdfReferenceValue(transaction));
                goToActionInfo = vGoToActionInfo.goToActionInfoValue(transaction);
            }
            n2 = goToActionInfo.pageNumRelative ? (n2 += goToActionInfo.pageNum) : goToActionInfo.pageNum;
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > n3) {
                n2 = n3;
            }
        } else {
            pDFArray = goToActionInfo.destArray;
            n2 = goToActionInfo.pageNumRelative ? (n2 += goToActionInfo.pageNum) : goToActionInfo.pageNum;
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > n3) {
                n2 = n3;
            }
        }
        pDFArray = goToActionInfo.destArray;
        PDFReference pDFReference = VPageRefByNum.getVPageRefByNum(pDFObjStore, n2).pdfReferenceValue(transaction);
        pageView.goToPage(transaction, n2);
        if (pDFArray == null) {
            return;
        }
        int n4 = VPageProps.getRotate(pDFReference).intValue(transaction);
        boolean bl2 = n4 % 180 != 0;
        object = pDFArray.get(1).nameValue(transaction);
        if (((String)object).equals(Fit_K)) {
            pageView.setScaleType(transaction, "FitPage");
        } else if (((String)object).equals(FitH_K)) {
            pageView.setScaleType(transaction, "FitWidth");
            float f = GoToActionHandler.computeSide(transaction, pDFArray, 2, bl2 ? (float)floatPoint.x : (float)floatPoint.y);
            if (bl2) {
                floatPoint2.x = f;
            } else {
                floatPoint2.y = f;
            }
            bl = true;
        } else if (((String)object).equals(FitV_K)) {
            pageView.setScaleType(transaction, "FitHeight");
            float f = GoToActionHandler.computeSide(transaction, pDFArray, 2, bl2 ? (float)floatPoint.y : (float)floatPoint.x);
            if (bl2) {
                floatPoint2.y = f;
            } else {
                floatPoint2.x = f;
            }
            bl = true;
        } else if (((String)object).equals(XYZ_K)) {
            float f;
            object2 = pDFArray.get(4);
            if (((PDFObj)(object2 = GoToActionHandler.filterOutFixedNegativeInfinity((PDFObj)object2, transaction))).type(transaction) != 0 && (f = ((PDFObj)object2).floatValue(transaction)) != 0.0f) {
                pageView.setScale(transaction, f);
            }
            float f2 = GoToActionHandler.computeSide(transaction, pDFArray, 2, bl2 ? (float)floatPoint.y : (float)floatPoint.x);
            float f3 = GoToActionHandler.computeSide(transaction, pDFArray, 3, bl2 ? (float)floatPoint.x : (float)floatPoint.y);
            if (bl2) {
                floatPoint2.y = f2;
                floatPoint2.x = f3;
            } else {
                floatPoint2.x = f2;
                floatPoint2.y = f3;
            }
            bl = true;
        } else if (((String)object).equals(FitR_K)) {
            object2 = pageView.getAperturePageSpace(n2, transaction);
            float f = GoToActionHandler.computeSide(transaction, pDFArray, 2, (float)((FloatRect)object2).getxMin());
            float f4 = GoToActionHandler.computeSide(transaction, pDFArray, 3, (float)((FloatRect)object2).getyMin());
            float f5 = GoToActionHandler.computeSide(transaction, pDFArray, 4, (float)((FloatRect)object2).getxMax());
            float f6 = GoToActionHandler.computeSide(transaction, pDFArray, 5, (float)((FloatRect)object2).getyMax());
            pageView.scrollToPageSpaceRect(transaction, n2, new FloatRect(f, f4, f5, f6), true);
            bl = false;
        }
        if (bl) {
            AffineTransform affineTransform = pageView.getGalleyTransform(n2, transaction);
            affineTransform.transformPoint(floatPoint2, floatPoint2);
            PVNavigation.scrollTo(transaction, pageView, new Point((int)Math.round(floatPoint2.x), (int)Math.round(floatPoint2.y)));
        }
    }

    public void perform(Transaction transaction, String string, PDFReference pDFReference, Dictionary dictionary) throws Exception {
        GoToActionInfo goToActionInfo = VGoToActionInfo.getVGoToActionInfo(pDFReference).goToActionInfoValue(transaction);
        AcroViewContext acroViewContext = (AcroViewContext)dictionary.get("AcroViewContext");
        VisiblePage visiblePage = (VisiblePage)dictionary.get("VisiblePage");
        int n = 0;
        if (visiblePage != null) {
            n = visiblePage.pageNum;
        }
        GoToActionHandler.goToDest(transaction, string, n, goToActionInfo, acroViewContext);
    }

    public static void register() {
        GoToActionHandler goToActionHandler = new GoToActionHandler();
        ActionHandler.registerHandler(GoTo_K, goToActionHandler);
        ActionHandler.registerHandler(GoToR_K, goToActionHandler);
        ActionHandler.registerHandler(Thread_K, goToActionHandler);
    }
}

