/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.ErrorDialog;
import com.adobe.acrobat.gui.GroupBox;
import com.adobe.acrobat.util.FontCache;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.QuickSort;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.LightWeightPanel;
import com.adobe.util.MemUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class FontPolicyDialog
extends BasicDialog
implements ItemListener {
    private Label heading;
    private List list;
    private List remoteList;
    private Vector sc;
    private Vector userSc;
    private int maxLine = 0;
    private int userMaxLine = 0;
    private int[] tab;
    private int[] remoteTab;
    private Font mono;
    private int scSortIndex = 0;
    private int userScSortIndex = 0;
    private Button delete;
    private TextField dirs;
    private TextField exts;
    Frame parent;
    private Container pSys;
    private Container pUser;
    private Container pMain;
    private GridBagLayout gSys;
    private GridBagLayout gUser;
    private GridBagLayout gMain;
    private GridBagConstraints cSys;
    private GridBagConstraints cUser;
    private GridBagConstraints cMain;

    public FontPolicyDialog(Frame frame) {
        super(frame, Util.getDialogString("FontPolicy:Title"), true);
        this.parent = frame;
        this.setLayout(new BorderLayout(5, 5));
        this.sc = new Vector();
        this.userSc = new Vector();
        this.mono = new Font("Monospaced", 0, 12);
        this.createGridPanels();
        this.createLocalElements();
        this.addRowFill(this.pMain, this.gMain, this.cMain, this.pSys, 1);
        this.add((Component)this.pMain, "Center");
        this.add((Component)this.okCancelPanel, "East");
        this.initTabs();
        this.getLocalFonts();
        this.displayLocalFonts();
        this.setHeading();
        this.restoreLocation();
        this.pack();
        this.setVisible(true);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, Component component) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        Label label = new Label(string, 2);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        container.add(label);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRowFill(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, int n) {
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n, 4, 1, 4);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private String align(String[] stringArray) {
        if (this.maxLine == 0) {
            return "";
        }
        StringBuffer stringBuffer = MemUtil.allocStringBuffer(this.maxLine);
        int n = 0;
        while (n < this.maxLine) {
            stringBuffer.append(' ');
            ++n;
        }
        stringBuffer.insert(0, stringArray[0]);
        stringBuffer.insert(this.tab[0], stringArray[1]);
        return stringBuffer.toString().trim();
    }

    protected void arrangeButtons() {
        this.buttons.setLayout(new GridLayout(2, 1, 5, 5));
        this.buttons.add(this.ok);
        this.buttons.add(this.cancel);
    }

    public void cancel() {
        super.cancel();
    }

    private void computeRemoteTabs() {
        int n = 0;
        while (n < this.userSc.size()) {
            String[] stringArray = (String[])this.userSc.elementAt(n);
            this.remoteTab[0] = Math.max(this.remoteTab[0], stringArray[0].length() + 5);
            this.userMaxLine = Math.max(this.userMaxLine, this.remoteTab[0] + stringArray[1].length());
            ++n;
        }
    }

    private void computeTabs() {
        int n = 0;
        while (n < this.sc.size()) {
            String[] stringArray = (String[])this.sc.elementAt(n);
            this.tab[0] = Math.max(this.tab[0], stringArray[0].length() + 5);
            this.maxLine = Math.max(this.maxLine, this.tab[0] + stringArray[1].length());
            ++n;
        }
    }

    private void createGridPanels() {
        this.pSys = new GroupBox(Util.getDialogString("FontPolicy:LocalFonts"));
        this.gSys = new GridBagLayout();
        this.cSys = new GridBagConstraints();
        this.pSys.setLayout(this.gSys);
        this.cSys.insets = new Insets(1, 4, 1, 4);
        this.cSys.fill = 1;
        this.pUser = new GroupBox(Util.getDialogString("FontPolicy:RemoteFonts"));
        this.gUser = new GridBagLayout();
        this.cUser = new GridBagConstraints();
        this.pUser.setLayout(this.gUser);
        this.cUser.insets = new Insets(1, 4, 1, 4);
        this.cUser.fill = 1;
        this.pMain = new LightWeightPanel();
        this.gMain = new GridBagLayout();
        this.cMain = new GridBagConstraints();
        this.pMain.setLayout(this.gMain);
        this.cMain.fill = 1;
    }

    private void createLocalElements() {
        this.list = new List(10, false);
        this.list.setFont(this.mono);
        this.heading = new Label();
        this.heading.setFont(this.mono);
        this.heading.addMouseListener(this);
        this.addRow(this.pSys, this.gSys, this.cSys, this.heading);
        this.addRow(this.pSys, this.gSys, this.cSys, this.list);
        this.addRow(this.pSys, this.gSys, this.cSys, new Label(Util.getDialogString("Prefs:FontDirectories")));
        this.dirs = new TextField(FontCache.getTheFontCache().getSearchDirs(), 20);
        this.addRow(this.pSys, this.gSys, this.cSys, this.dirs);
        this.addRow(this.pSys, this.gSys, this.cSys, new Label(Util.getDialogString("Prefs:FontExtensions")));
        this.exts = new TextField(FontCache.getTheFontCache().getFontIgnoreFileExtensionList(), 20);
        this.addRow(this.pSys, this.gSys, this.cSys, this.exts);
    }

    private void displayLocalFonts() {
        this.list.removeAll();
        this.computeTabs();
        int n = 0;
        while (n < this.sc.size()) {
            String[] stringArray = (String[])this.sc.elementAt(n);
            this.list.add(this.align(stringArray));
            ++n;
        }
    }

    private void displayRemoteFonts() {
        this.remoteList.removeAll();
        this.computeRemoteTabs();
        int n = 0;
        while (n < this.userSc.size()) {
            String[] stringArray = (String[])this.userSc.elementAt(n);
            this.remoteList.add(this.align(stringArray));
            ++n;
        }
    }

    private void getLocalFonts() {
        this.sc.removeAllElements();
        Properties properties = FontCache.getTheFontCache().getLocalFonts();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.sc.addElement(new String[]{string, (String)((Hashtable)properties).get(string)});
        }
        if (this.sc.size() != 0) {
            FontPolicyDialog.sort(this.sc, this.scSortIndex);
        }
    }

    private void initTabs() {
        this.tab = new int[1];
        this.tab[0] = Util.getDialogString("FontPolicy:FontName").length() + 5;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.heading) {
            this.scSortIndex = this.scSortIndex == 0 ? 1 : 0;
            FontPolicyDialog.sort(this.sc, this.scSortIndex);
            this.displayLocalFonts();
        }
    }

    public void ok() {
        String string = this.dirs.getText().trim();
        String string2 = this.exts.getText().trim();
        if (string.equals(FontCache.getTheFontCache().getSearchDirs()) && string2.equals(FontCache.getTheFontCache().getFontIgnoreFileExtensionList())) {
            super.ok();
        } else {
            Vector vector = FontCache.getTheFontCache().areSearchDirsValid(string);
            if (vector.size() == 0) {
                FontCache.getTheFontCache().setSearchDirs(string);
                FontCache.getTheFontCache().setFontIgnoreFileExtensions(string2);
                FontCache.getTheFontCache().buildCache(true);
                super.ok();
            } else {
                String string3 = "";
                int n = 0;
                while (n < vector.size()) {
                    String string4 = (String)vector.elementAt(n);
                    string3 = String.valueOf(string3) + string4 + ";";
                    ++n;
                }
                new ErrorDialog(this.parent, Util.getErrorString(Util.getDialogString("FontPolicy:InvalidDirectories"), string3));
            }
        }
    }

    private void setHeading() {
        String string = this.align(new String[]{Util.getDialogString("FontPolicy:FontName"), Util.getDialogString("FontPolicy:FontFileName")});
        this.heading.setText(String.valueOf(string) + "     ");
    }

    private static void sort(Vector vector, int n) {
        try {
            String[][] stringArray = new String[vector.size()][2];
            vector.copyInto((Object[])stringArray);
            QuickSort.sort(stringArray, 0, stringArray.length - 1, n);
            vector.removeAllElements();
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
        }
        catch (Exception exception) {
            Log.log(exception.toString());
        }
    }
}

