/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.ImageLabel;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.MultilineLabel;
import com.adobe.pe.util.PEUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class ErrorDialog
extends BasicDialog {
    private Throwable exception;
    private MultilineLabel errorText;
    private TextArea moreText;

    public ErrorDialog(Frame frame, String string) {
        super(frame, Util.getAcroViewContextString("ErrorDialog:Title"), true);
        this.commonInit(string);
    }

    public ErrorDialog(Frame frame, Throwable throwable) {
        super(frame, Util.getAcroViewContextString("ErrorDialog:Title"), true);
        this.exceptionInit(throwable);
        this.commonInit(PEUtil.getThrowableMessage(throwable, true));
    }

    public ErrorDialog(String string) {
        this(new Frame(), string);
    }

    public ErrorDialog(Throwable throwable) {
        this(new Frame(), throwable);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ErrorDialog:TellMeMore")) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            if (this.exception != null) {
                this.exception.printStackTrace(printWriter);
            }
            printWriter.close();
            this.moreText.setText(((Object)byteArrayOutputStream).toString());
            this.moreText.setEditable(false);
            this.moreText.setVisible(true);
            this.invalidate();
            this.pack();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void arrangeButtons() {
        this.buttons.setLayout(new GridLayout(2, 1, 5, 5));
        this.buttons.add(this.ok);
    }

    protected void commonInit(String string) {
        this.setLayout(new BorderLayout(5, 5));
        Image image = Util.getResourceImage("icons/default/error.gif");
        ImageLabel imageLabel = new ImageLabel(image);
        this.add((Component)imageLabel, "West");
        this.errorText = new MultilineLabel(string);
        this.add((Component)this.errorText, "Center");
        this.moreText = new TextArea();
        this.add((Component)this.moreText, "South");
        this.moreText.setVisible(false);
        this.add((Component)this.okCancelPanel, "East");
        this.pack();
        this.setVisible(true);
    }

    protected void exceptionInit(Throwable throwable) {
        this.exception = throwable;
        if (throwable != null) {
            throwable.printStackTrace();
            Button button = new Button(Util.getDialogString("ErrorDialog:TellMeMore"));
            button.setActionCommand("ErrorDialog:TellMeMore");
            this.buttons.add(button);
            button.addActionListener(this);
        }
    }

    private static String getMessage(Throwable throwable) {
        String string = throwable.getLocalizedMessage();
        if (string == null) {
            return throwable.toString();
        }
        return string;
    }
}

