/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.Selection;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.util.Assert;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;

public class EditVerb
extends UIVerb {
    public static final int kUndo = 1;
    public static final int kCut = 2;
    public static final int kCopy = 3;
    public static final int kPaste = 4;
    public static final int kDelete = 5;
    public static final int kSelectAll = 6;
    private AcroViewContext context;
    private int selector;

    public EditVerb(AcroViewContext acroViewContext, int n) {
        this.selector = n;
        this.context = acroViewContext;
        this.setAttributes(new EditVerbTransactor(), new VEditVerbEnabledBoolean(), null);
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        CommandRegistry.addCommand(new EditVerb(acroViewContext, 1), acroViewContext, "EditUndo");
        CommandRegistry.addCommand(new EditVerb(acroViewContext, 2), acroViewContext, "EditCut");
        CommandRegistry.addCommand(new EditVerb(acroViewContext, 3), acroViewContext, "EditCopy");
        CommandRegistry.addCommand(new EditVerb(acroViewContext, 4), acroViewContext, "EditPaste");
        CommandRegistry.addCommand(new EditVerb(acroViewContext, 5), acroViewContext, "EditDelete");
        CommandRegistry.addCommand(new EditVerb(acroViewContext, 6), acroViewContext, "EditSelectAll");
    }

    private class EditVerbTransactor
    extends Transactor {
        EditVerbTransactor() {
        }

        protected final void buildChanges(Transaction transaction) throws Exception {
            switch (EditVerb.this.selector) {
                case 3: {
                    Selection selection;
                    if (!EditVerb.this.context.getPermission(transaction, "Copy") || (selection = EditVerb.this.context.getPageView().getSelection(transaction)) == null) break;
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = selection.copy(transaction);
                    clipboard.setContents(transferable, null);
                    break;
                }
                case 6: {
                    EditVerb.this.context.getVTool().toolValue(transaction).selectAll(EditVerb.this.context.getPageView(), transaction);
                    break;
                }
                default: {
                    Assert.notFalse(false);
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
            }
        }
    }

    private class VEditVerbEnabledBoolean
    extends VBoolean {
        VEditVerbEnabledBoolean() {
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            switch (EditVerb.this.selector) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    return false;
                }
                case 3: {
                    if (EditVerb.this.context.couldGetPermission(requester, "Copy")) {
                        Selection selection = EditVerb.this.context.getPageView().getSelection(requester);
                        return selection != null && selection.canCopy(requester);
                    }
                    return false;
                }
                case 6: {
                    return EditVerb.this.context.getVTool().toolValue(requester).canSelectAll(EditVerb.this.context.getPageView(), requester);
                }
            }
            Assert.notFalse(false);
            return false;
        }
    }
}

