/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.Viewer;
import com.adobe.acrobat.debug.ConsoleActionHandler;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.GoToActionHandler;
import com.adobe.acrobat.gui.LaunchActionHandler;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import java.util.Dictionary;
import java.util.Hashtable;

public abstract class ActionHandler {
    public static final String S_K = "S";
    private static Hashtable handlers = new Hashtable();

    static {
        GoToActionHandler.register();
        LaunchActionHandler.register();
        if (Viewer.enabledDebug()) {
            ConsoleActionHandler.register();
        }
    }

    public static String getStatusText(PDFReference pDFReference, Dictionary dictionary, Requester requester) throws Exception {
        String string = pDFReference.dictValue(requester).get(S_K).nameValue(requester);
        ActionHandler actionHandler = (ActionHandler)handlers.get(string);
        if (actionHandler != null) {
            return actionHandler.getStatusText(string, pDFReference, dictionary, requester);
        }
        return "";
    }

    public String getStatusText(String string, PDFReference pDFReference, Dictionary dictionary, Requester requester) throws Exception {
        return "";
    }

    public abstract void perform(Transaction var1, String var2, PDFReference var3, Dictionary var4) throws Exception;

    public static void performAction(Transaction transaction, PDFReference pDFReference, Dictionary dictionary) throws Exception {
        if (pDFReference != null && pDFReference.type(transaction) != 0) {
            if (pDFReference.type(transaction) == 7) {
                GoToActionHandler.goToDest(transaction, pDFReference, (AcroViewContext)dictionary.get("AcroViewContext"));
            } else {
                String string = pDFReference.dictValue(transaction).get(S_K).nameValue(transaction);
                ActionHandler actionHandler = (ActionHandler)handlers.get(string);
                if (actionHandler != null) {
                    actionHandler.perform(transaction, string, pDFReference, dictionary);
                }
            }
        }
    }

    public static void registerHandler(String string, ActionHandler actionHandler) {
        handlers.put(string, actionHandler);
    }
}

