/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.bytearray.VByteArray;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.URLByteArraySourceSpace;
import com.adobe.acrobat.file.VByteArraySource;
import com.adobe.acrobat.gui.ActionHandler;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.ErrorDialog;
import com.adobe.acrobat.gui.FullScreenVerb;
import com.adobe.acrobat.gui.GoToActionHandler;
import com.adobe.acrobat.gui.HandTool;
import com.adobe.acrobat.gui.ModalDialogManager;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.PasswordDialog;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.SplitPane;
import com.adobe.acrobat.gui.VSplitPane;
import com.adobe.acrobat.gui.VStatusTextProvider;
import com.adobe.acrobat.gui.VTool;
import com.adobe.acrobat.gui.ViewerPreferences;
import com.adobe.acrobat.gui.ZoomValueSpec;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.VPDFObjStore;
import com.adobe.acrobat.pdfobjstore.security.PDFObjStorePerms;
import com.adobe.acrobat.pdfobjstore.security.SecurityHandler;
import com.adobe.acrobat.pdfobjstore.security.VPDFObjStorePerms;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.StatusTextProvider;
import com.adobe.pe.awt.VDimension;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.ExtensibleProxy;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VSynchronizer;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.util.PEUtil;
import com.adobe.pe.vtypes.VObject;
import com.adobe.pe.vtypes.VString;
import java.awt.Component;
import java.awt.Cursor;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public class AcroViewContext
implements Extensible,
TransactionExecutionContext {
    private ModalDialogManager modalDialogManager = new ModalDialogManager();
    private Vector errorQueue = new Vector();
    private Thread errorThread = null;
    private VSynchronizer vNavigationSynchronizer;
    private VString statusVString;
    private ExtensibleProxy exProxy = null;
    private VByteArraySource vPDFObjStoreBASS = new VPDFObjStoreBASS();
    private static final String OpenAction_K = "OpenAction";
    private static final String PageMode_K = "PageMode";
    private static final String PageLayout_K = "PageLayout";
    private static final String UseNone_K = "UseNone";
    private static final String UseOutlines_K = "UseOutlines";
    private static final String UseThumbs_K = "UseThumbs";
    private static final String FullScreen_K = "FullScreen";
    private VDimension vTocDimension;
    private PageView pv;
    private VObject vPasswordHash;
    private VPDFObjStore vStore;
    private VTool vTool;
    private VStatusTextProvider vStatusTextProvider;
    private Component rootComponent;
    private Cursor rootCursor = null;
    private int rootCursorCount = 0;
    private FullScreenVerb fullScreenVerb;

    public AcroViewContext(Transaction transaction) throws Exception {
        this.vPasswordHash = new VObject(null);
        this.vStore = new VPDFObjStore(null);
        this.commonInit(transaction);
    }

    public AcroViewContext(Transaction transaction, ByteArraySource byteArraySource) throws Exception {
        VByteArraySource vByteArraySource = new VByteArraySource(byteArraySource);
        VByteArray vByteArray = vByteArraySource.getVByteArray();
        PDFObjStore pDFObjStore = new PDFObjStore(vByteArray, this.vPasswordHash);
        this.vStore = new VPDFObjStore(null);
        this.commonInit(transaction);
        this.setPDFObjStore(transaction, pDFObjStore);
    }

    public AcroViewContext(Transaction transaction, PDFObjStore pDFObjStore) throws Exception {
        this.vStore = new VPDFObjStore(null);
        this.vPasswordHash = new VObject(null);
        this.commonInit(transaction);
        this.setPDFObjStore(transaction, pDFObjStore);
    }

    public AcroViewContext(Transaction transaction, URL uRL) throws Exception {
        ByteArraySource byteArraySource = URLByteArraySourceSpace.createURLByteArraySource(uRL);
        VByteArraySource vByteArraySource = new VByteArraySource(byteArraySource);
        VByteArray vByteArray = vByteArraySource.getVByteArray();
        PDFObjStore pDFObjStore = new PDFObjStore(vByteArray, this.vPasswordHash);
        this.vStore = new VPDFObjStore(null);
        this.commonInit(transaction);
        this.setPDFObjStore(transaction, pDFObjStore);
    }

    public void abortTransaction(Transaction transaction) {
    }

    static /* synthetic */ Thread access$1(AcroViewContext acroViewContext) {
        return acroViewContext.errorThread;
    }

    public void beginTransaction(Transaction transaction) {
        if (this.rootCursorCount++ == 0) {
            this.rootCursor = null;
            if (this.rootComponent != null) {
                this.rootCursor = this.rootComponent.getCursor();
                this.rootComponent.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    private void commonInit(Transaction transaction) throws Exception {
        this.fullScreenVerb = new FullScreenVerb(this);
        this.vTocDimension = new VDimension(0, 0);
        this.vPasswordHash = new VObject(null);
        this.pv = new PageView(this, transaction);
        this.vTool = new VTool(HandTool.getHandTool());
        this.vStatusTextProvider = new VStatusTextProvider(null);
        this.vNavigationSynchronizer = new VSynchronizer(true, true);
        CommandRegistry.registerAllCommands(this);
    }

    public boolean couldGetPermission(Requester requester, String string) throws Exception {
        PDFObjStorePerms pDFObjStorePerms;
        boolean bl = false;
        PDFObjStore pDFObjStore = this.vStore.pdfObjStoreValue(requester);
        if (pDFObjStore != null && !(bl = (pDFObjStorePerms = pDFObjStore.getVPDFObjStorePerms().peObjStorePermsValue(requester)).get(string))) {
            bl = pDFObjStorePerms.haveOwner();
        }
        return bl;
    }

    public Dictionary createActionParamsDictionary(Requester requester) throws Exception {
        Hashtable<String, Extensible> hashtable = new Hashtable<String, Extensible>();
        hashtable.put("AcroViewContext", this);
        hashtable.put("PDFObjStore", this.getPDFObjStore(requester));
        return hashtable;
    }

    public void endTransaction(Transaction transaction) {
        if (--this.rootCursorCount == 0 && this.rootComponent != null) {
            if (this.rootCursor == null) {
                this.rootComponent.setCursor(Cursor.getDefaultCursor());
            } else {
                this.rootComponent.setCursor(this.rootCursor);
            }
        }
    }

    public boolean extensionDataIsAvailable(String string) {
        return this.exProxy != null && this.exProxy.extensionDataExistsFor(string);
    }

    public Object getExtensionData(String string) {
        if (this.exProxy == null) {
            this.exProxy = new ExtensibleProxy(this);
        }
        return this.exProxy.getExtensionDataFor(string);
    }

    public FullScreenVerb getFullScreenVerb() {
        return this.fullScreenVerb;
    }

    public PDFObjStore getPDFObjStore(Requester requester) throws Exception {
        return this.vStore.pdfObjStoreValue(requester);
    }

    public PageView getPageView() {
        return this.pv;
    }

    public boolean getPermission(Transaction transaction, String string) throws Exception {
        boolean bl = true;
        PDFObjStore pDFObjStore = this.vStore.pdfObjStoreValue(transaction);
        VPDFObjStorePerms vPDFObjStorePerms = pDFObjStore.getVPDFObjStorePerms();
        PDFObjStorePerms pDFObjStorePerms = vPDFObjStorePerms.peObjStorePermsValue(transaction);
        bl = pDFObjStorePerms.get(string);
        if (!bl && pDFObjStorePerms.haveOwner()) {
            Object object;
            String string2 = SecurityHandler.getEncryptionMethod(pDFObjStore).stringValue(transaction);
            while ((object = PasswordDialog.getPasswordHash(PEUtil.getFrame(this.rootComponent), string2, "Pass:Owner")) != null && !(bl = (pDFObjStorePerms = SecurityHandler.computePerms(string2, object, pDFObjStore, transaction)).get(string))) {
            }
            if (bl) {
                VObject vObject = pDFObjStore.getVPasswordHash();
                vObject.setObjectValue(transaction, object);
            }
        }
        return bl;
    }

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public VString getStatusVString() {
        if (this.statusVString == null) {
            this.statusVString = new VStatusString();
        }
        return this.statusVString;
    }

    public VDimension getTocDimension() {
        return this.vTocDimension;
    }

    public VByteArraySource getVByteArraySource() {
        return this.vPDFObjStoreBASS;
    }

    public VSynchronizer getVNavigationSynchronizer() {
        return this.vNavigationSynchronizer;
    }

    public VPDFObjStore getVPDFObjStore() {
        return this.vStore;
    }

    public VTool getVTool() {
        return this.vTool;
    }

    public boolean hasPermission(Requester requester, String string) throws Exception {
        boolean bl = false;
        PDFObjStore pDFObjStore = this.vStore.pdfObjStoreValue(requester);
        if (pDFObjStore != null) {
            PDFObjStorePerms pDFObjStorePerms = pDFObjStore.getVPDFObjStorePerms().peObjStorePermsValue(requester);
            bl = pDFObjStorePerms.get(string);
        }
        return bl;
    }

    public void hideTOC(Transaction transaction) throws Exception {
        if (this.vTocDimension.dimensionValue((Requester)transaction).width != 0) {
            SplitPane splitPane = VSplitPane.getVSplitPane(this).splitPaneValue(transaction);
            splitPane.closeLeftPane();
            this.vTocDimension.setDimensionValue(transaction, splitPane.getLeftPanel().getSize());
        }
    }

    public void reportError(Transaction transaction, Throwable throwable, boolean bl) {
        if (throwable instanceof WriteLockException || throwable instanceof InterruptedException || throwable instanceof InterruptedIOException) {
            return;
        }
        Log.clog("AcroViewContext.reportError(" + bl + "): " + throwable);
        Log.logStackTrace(throwable);
        if (bl) {
            return;
        }
        if (!this.errorQueue.contains(throwable)) {
            this.errorQueue.addElement(throwable);
        }
        if (this.errorThread == null) {
            this.errorThread = new Thread("AcroViewContext Error Dialog Display Thread"){

                public void run() {
                    while (!AcroViewContext.this.errorQueue.isEmpty()) {
                        Throwable throwable = (Throwable)AcroViewContext.this.errorQueue.firstElement();
                        AcroViewContext.this.errorQueue.removeElementAt(0);
                        ErrorDialog errorDialog = new ErrorDialog(PEUtil.getFrame(AcroViewContext.this.getRootComponent()), throwable);
                    }
                    AcroViewContext.this.errorThread = null;
                }
            };
            this.errorThread.start();
        }
    }

    public void retireStatusTextProvider(Transaction transaction, StatusTextProvider statusTextProvider) throws Exception {
        StatusTextProvider statusTextProvider2 = this.vStatusTextProvider.statusTextProviderValue(transaction);
        if (statusTextProvider2 == statusTextProvider) {
            this.vStatusTextProvider.setStatusTextProviderValue(transaction, null);
        }
    }

    public void setByteArraySource(Transaction transaction, ByteArraySource byteArraySource) throws Exception {
        VByteArraySource vByteArraySource = new VByteArraySource(byteArraySource);
        VObject vObject = new VObject(null);
        PDFObjStore pDFObjStore = new PDFObjStore(vByteArraySource.getVByteArray(), vObject);
        VPDFObjStorePerms vPDFObjStorePerms = pDFObjStore.getVPDFObjStorePerms();
        PDFObjStorePerms pDFObjStorePerms = vPDFObjStorePerms.peObjStorePermsValue(transaction);
        if (!pDFObjStorePerms.canRead()) {
            String string = SecurityHandler.getEncryptionMethod(pDFObjStore).stringValue(transaction);
            do {
                Object object;
                if ((object = PasswordDialog.getPasswordHash(PEUtil.getFrame(this.rootComponent), string, "Pass:Open")) == null) {
                    return;
                }
                vObject.setObjectValue(transaction, object);
            } while (!vPDFObjStorePerms.peObjStorePermsValue(transaction).canRead());
        }
        this.setPDFObjStore(transaction, pDFObjStore);
    }

    public void setModalDialogTransactor(Transactor transactor) {
        this.modalDialogManager.setDialogTransactor(transactor, this);
    }

    public void setPDFObjStore(Transaction transaction, PDFObjStore pDFObjStore) throws Exception {
        this.pv.suspendNavigation(transaction);
        PDFObjStore pDFObjStore2 = this.getPDFObjStore(transaction);
        if (pDFObjStore2 != null && this.pv.navigationSuspensionDepth(transaction) == 1) {
            this.pv.performDocumentCloseAction(transaction);
        }
        try {
            this.hideTOC(transaction);
            boolean bl = this.fullScreenVerb.getChecked();
            this.fullScreenVerb.fromFullScreen(transaction);
            this.vStore.setPDFObjStoreValue(transaction, pDFObjStore);
            if (pDFObjStore != null) {
                PDFObj pDFObj;
                Object object;
                ZoomValueSpec zoomValueSpec = ReaderPrefs.fDefaultZoom.zoomValueSpecValue(transaction);
                this.pv.setZoomValueSpec(transaction, zoomValueSpec);
                PDFDict pDFDict = pDFObjStore.getRootDict().pdfReferenceValue(transaction).dictValue(transaction);
                String string = ReaderPrefs.fDefPageLayout.stringValue(transaction);
                if (pDFDict.hasKey(PageLayout_K) && ((PDFObj)(object = pDFDict.get(PageLayout_K))).type(transaction) == 5) {
                    string = ((PDFObj)object).nameValue(transaction);
                }
                this.pv.setPageLayout(transaction, string);
                ViewerPreferences.applyViewerPreferences(transaction, this);
                Object object2 = object = bl ? FullScreen_K : "";
                if (pDFDict.hasKey(PageMode_K) && (pDFObj = pDFDict.get(PageMode_K)).type(transaction) == 5) {
                    object = pDFObj.nameValue(transaction);
                }
                if (((String)object).equals(UseOutlines_K)) {
                    this.showTOC(transaction);
                } else if (((String)object).equals(FullScreen_K)) {
                    this.fullScreenVerb.toFullScreen(transaction);
                }
                this.pv.goToPage(transaction, 0);
                if (pDFDict.hasKey(OpenAction_K)) {
                    pDFObj = pDFDict.get(OpenAction_K);
                    switch (pDFObj.type(transaction)) {
                        case 6: {
                            ActionHandler.performAction(transaction, pDFObj.pdfReferenceValue(transaction), this.createActionParamsDictionary(transaction));
                            break;
                        }
                        case 7: {
                            GoToActionHandler.goToDest(transaction, pDFObj, this);
                            break;
                        }
                    }
                }
                pDFObjStore.incRefCount(transaction);
            }
            if (pDFObjStore2 != null) {
                pDFObjStore2.decRefCount(transaction);
            }
            this.pv.resumeNavigation(transaction);
        }
        catch (Exception exception) {
            throw new Exception(Util.getErrorString("Error:PDFObjStore:CantRebuildXRef"));
        }
    }

    public void setRootComponent(Component component) {
        this.rootComponent = component;
    }

    public void setStatusTextProvider(Transaction transaction, StatusTextProvider statusTextProvider) throws WriteLockException {
        this.vStatusTextProvider.setStatusTextProviderValue(transaction, statusTextProvider);
    }

    public void showTOC(Transaction transaction) throws Exception {
        if (this.vTocDimension.dimensionValue((Requester)transaction).width == 0) {
            SplitPane splitPane = VSplitPane.getVSplitPane(this).splitPaneValue(transaction);
            splitPane.resetDivider();
            this.vTocDimension.setDimensionValue(transaction, splitPane.getLeftPanel().getSize());
        }
    }

    class VStatusString
    extends VString {
        VStatusString() {
        }

        protected final String computeString(Requester requester) throws Exception {
            StatusTextProvider statusTextProvider = AcroViewContext.this.vStatusTextProvider.statusTextProviderValue(requester);
            if (statusTextProvider != null) {
                return statusTextProvider.provideStatusString(requester);
            }
            return null;
        }
    }

    class VPDFObjStoreBASS
    extends VByteArraySource {
        VPDFObjStoreBASS() {
        }

        protected final ByteArraySource computeByteArraySource(Requester requester) throws Exception {
            PDFObjStore pDFObjStore = AcroViewContext.this.vStore.pdfObjStoreValue(requester);
            if (pDFObjStore != null) {
                ByteArray byteArray = pDFObjStore.getVByteArray().byteArrayValue(requester);
                return byteArray.getByteArraySource();
            }
            return null;
        }
    }
}

