/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.file;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.ByteArraySourceSpace;
import com.adobe.acrobat.file.FileByteArray;
import com.adobe.acrobat.file.FileByteArraySourceException;
import com.adobe.acrobat.util.Session;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import netscape.security.PrivilegeManager;

class FileByteArraySource
extends ByteArraySource {
    private RandomAccessFile rf = null;
    private ByteArray fileByteArray = null;
    private File file;

    public FileByteArraySource(File file) {
        this.file = file;
    }

    public void close() throws IOException {
        if (this.rf != null) {
            this.rf.close();
        }
        this.fileByteArray = null;
    }

    public ByteArray getByteArray() throws Exception {
        if (this.fileByteArray == null) {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            if (!this.file.isFile() || !this.file.canRead()) {
                throw new FileByteArraySourceException(this, "Error:File:FileNotFound");
            }
            this.rf = new RandomAccessFile(this.file, "r");
            this.fileByteArray = new FileByteArray(this.rf, this);
        }
        return this.fileByteArray;
    }

    public ByteArraySource getByteArraySourceRelative(String string) throws Exception {
        return this.getSourceSpace().getByteArraySourceRelative(this.file.getPath(), string);
    }

    public String getFullName() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.file.getAbsolutePath();
        }
    }

    public ByteArraySourceSpace getSourceSpace() {
        return ByteArraySourceSpace.getDefaultSourceSpace();
    }

    public String getTitle() {
        return this.file.getName();
    }
}

