/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.GalleyScroller;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.VPaintingCanvas;
import com.adobe.pe.awt.VToggleString;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VString;
import com.adobe.util.Assert;
import java.awt.Component;
import java.awt.Container;

class PageFlipper
implements VObserver,
StrobeContainer {
    private static final String VPageFlipper_K = "VPageFlipper";
    private static ExtensionDataProvider provider = null;
    private VBoolean drawingBoolean;
    VBoolean flippingBoolean;
    private AcroViewContext context;
    private PageFlipperThread thread;
    private VStrobe strobe;
    private boolean drawingIsHappening = false;
    private boolean flipping = false;

    PageFlipper(AcroViewContext acroViewContext) {
        this.context = acroViewContext;
        this.flippingBoolean = new VBoolean(false);
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            boolean bl = this.flipping;
            this.flipping = this.flippingBoolean.booleanValue(requester);
            if (this.drawingBoolean == null) {
                GalleyScroller galleyScroller = this.findGalleyScroller(this.context.getRootComponent());
                if (galleyScroller == null) {
                    return;
                }
                VPaintingCanvas vPaintingCanvas = galleyScroller.getGalleyView();
                this.drawingBoolean = vPaintingCanvas.getVDrawingBoolean();
            }
            this.setDrawingIsHappening(this.drawingBoolean.booleanValue(requester));
            if (this.flipping != bl) {
                if (this.thread != null) {
                    this.thread.stopFlipping = true;
                }
                this.thread = null;
                if (this.flipping) {
                    this.thread = new PageFlipperThread();
                    this.thread.start();
                }
            }
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            this.setDrawingIsHappening(false);
            Log.clog("PageFlipperThread.change: " + exception.toString());
        }
    }

    static VString createPageFlipperTitle(AcroViewContext acroViewContext) {
        VString vString = Util.getMenuVString("StopFlippingPages");
        VString vString2 = Util.getMenuVString("FlipPages");
        VBoolean vBoolean = PageFlipper.getFlippingVBoolean(acroViewContext);
        return new VToggleString(vString, vString2, vBoolean);
    }

    private GalleyScroller findGalleyScroller(Component component) {
        if (component instanceof GalleyScroller) {
            return (GalleyScroller)component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                Component component2 = container.getComponent(n);
                GalleyScroller galleyScroller = this.findGalleyScroller(component2);
                if (galleyScroller != null) {
                    return galleyScroller;
                }
                ++n;
            }
        }
        return null;
    }

    private boolean getDrawingIsHappening() {
        return this.drawingIsHappening;
    }

    public static VBoolean getFlippingVBoolean(AcroViewContext acroViewContext) {
        return PageFlipper.getPageFlipper((AcroViewContext)acroViewContext).flippingBoolean;
    }

    static PageFlipper getPageFlipper(AcroViewContext acroViewContext) {
        PageFlipper.initProvider();
        return (PageFlipper)acroViewContext.getExtensionData(VPageFlipper_K);
    }

    int getRandomNumber(int n) {
        return (int)Math.floor(Math.random() * (double)(n + 1));
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    if (string.equals(PageFlipper.VPageFlipper_K)) {
                        Assert.notFalse(extensible instanceof AcroViewContext);
                        AcroViewContext acroViewContext = (AcroViewContext)extensible;
                        return new PageFlipper(acroViewContext);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VPageFlipper_K, provider);
        }
    }

    private synchronized void setDrawingIsHappening(boolean bl) {
        this.drawingIsHappening = bl;
        this.notifyAll();
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    class PageFlipperThread
    extends Thread {
        boolean stopFlipping = false;

        PageFlipperThread() {
        }

        public void run() {
            while (!this.stopFlipping) {
                PageFlipTransactor pageFlipTransactor = new PageFlipTransactor();
                try {
                    pageFlipTransactor.commit();
                    this.waitUntilNoDrawing();
                }
                catch (Exception exception) {
                    Log.clog("PageFlipperThread.run: " + exception.toString());
                }
            }
        }

        private void waitUntilNoDrawing() throws InterruptedException {
            PageFlipper pageFlipper = PageFlipper.this;
            synchronized (pageFlipper) {
                while (!PageFlipper.this.getDrawingIsHappening()) {
                    PageFlipper.this.wait();
                }
                while (PageFlipper.this.getDrawingIsHappening()) {
                    PageFlipper.this.wait();
                }
            }
        }

        class PageFlipTransactor
        extends Transactor {
            PageFlipTransactor() {
            }

            public void buildChanges(Transaction transaction) throws Exception {
                int n = PageFlipper.this.context.getPageView().getNumPages(transaction);
                if (n > 1) {
                    int n2;
                    while ((n2 = PageFlipper.this.getRandomNumber(n - 1)) == PageFlipper.this.context.getPageView().getCurrentPage(transaction)) {
                    }
                    PageFlipper.this.context.getPageView().goToPage(transaction, n2);
                    Log.clog("flipping to page " + n2);
                }
            }
        }
    }
}

