/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.debug.VContentPainting;
import com.adobe.acrobat.page.VContentArray;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.vtypes.VAffineTransform;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.awt.VComponentDimension;
import com.adobe.pe.awt.VPaintingCanvas;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VInt;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class ContentView
extends Panel
implements ItemListener {
    private static final Font cbFont = new Font("Helvetica", 0, 11);
    private Checkbox allContentCB;
    private Checkbox zoomToContentCB;
    private Checkbox showBBCB;
    private Checkbox showClipCB;
    private VPaintingCanvas contentCanvas;
    private VBoolean vAllContent;
    private VBoolean vZoomToContent;
    private VBoolean vShowBB;
    private VBoolean vShowClip;

    ContentView(VFloatRect vFloatRect, VAffineTransform vAffineTransform, VContentArray vContentArray, VInt vInt) throws Exception {
        this.setLayout(new BorderLayout());
        this.vAllContent = new VBoolean(false);
        this.vZoomToContent = new VBoolean(false);
        this.vShowBB = new VBoolean(false);
        this.vShowClip = new VBoolean(false);
        this.contentCanvas = new VPaintingCanvas(null);
        VComponentDimension vComponentDimension = new VComponentDimension(this.contentCanvas);
        VContentPainting vContentPainting = new VContentPainting(vComponentDimension, vFloatRect, vAffineTransform, vContentArray, vInt, this.vAllContent, this.vZoomToContent, this.vShowBB, this.vShowClip);
        this.contentCanvas.setVPainting(vContentPainting);
        this.add((Component)this.contentCanvas, "Center");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 2));
        this.allContentCB = new Checkbox("Display lower content");
        this.allContentCB.setFont(cbFont);
        this.allContentCB.addItemListener(this);
        panel.add(this.allContentCB);
        this.zoomToContentCB = new Checkbox("Zoom to content");
        this.zoomToContentCB.addItemListener(this);
        this.zoomToContentCB.setFont(cbFont);
        panel.add(this.zoomToContentCB);
        this.showBBCB = new Checkbox("Show bounding boxes");
        this.showBBCB.addItemListener(this);
        this.showBBCB.setFont(cbFont);
        panel.add(this.showBBCB);
        this.showClipCB = new Checkbox("Show clip");
        this.showClipCB.addItemListener(this);
        this.showClipCB.setFont(cbFont);
        panel.add(this.showClipCB);
        this.add((Component)panel, "South");
    }

    public void itemStateChanged(final ItemEvent itemEvent) {
        try {
            Transactor transactor = new Transactor(){

                public void buildChanges(Transaction transaction) throws Exception {
                    if (itemEvent.getSource() == allContentCB) {
                        vAllContent.setBooleanValue(transaction, allContentCB.getState());
                    } else if (itemEvent.getSource() == zoomToContentCB) {
                        vZoomToContent.setBooleanValue(transaction, zoomToContentCB.getState());
                    } else if (itemEvent.getSource() == showBBCB) {
                        vShowBB.setBooleanValue(transaction, showBBCB.getState());
                    } else if (itemEvent.getSource() == showClipCB) {
                        vShowClip.setBooleanValue(transaction, showClipCB.getState());
                    }
                }
            };
            transactor.commit();
        }
        catch (Exception exception) {
            Log.clog("ContentView.actionPerformed: " + exception.toString());
        }
    }
}

