/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.ContentInspectorFriend;
import com.adobe.acrobat.page.VContentArray;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.VStrobeAsync;
import com.adobe.pe.vtypes.VInt;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;

class ContentSelectorGrid
extends Canvas
implements VObserver,
StrobeContainer {
    private static final int kRowHeight = 12;
    public VInt vHeight;
    private static final int kFontSize = 11;
    private static final int kInset = 2;
    private static Font indexFont = new Font("Helvetica", 1, 11);
    private static Font descFont = new Font("Helvetica", 0, 11);
    static Font unknownDescFont = new Font("Helvetica", 2, 11);
    private MouseAdapter mouseAdapter = new ContentSelectorGridMouseAdapter();
    private VContentArray vContent;
    private VInt vSelectionIndex;
    private VStrobe strobe;
    private int lastSelectedCell = -1;
    private ContentArray contentArray;
    private Vector contentCells = new Vector();

    ContentSelectorGrid(VContentArray vContentArray, VInt vInt) throws Exception {
        this.vContent = vContentArray;
        this.vSelectionIndex = vInt;
        this.vHeight = new VContentSelectorGridHeight();
        this.strobe = new VStrobeAsync(this);
        this.addMouseListener(this.mouseAdapter);
    }

    static /* synthetic */ VInt access$1(ContentSelectorGrid contentSelectorGrid) {
        return contentSelectorGrid.vSelectionIndex;
    }

    public void change(Requester requester) {
        try {
            Rectangle rectangle;
            ContentArray contentArray = this.vContent.contentArrayValue(requester);
            if (contentArray != this.contentArray) {
                this.repaint();
            }
            this.contentArray = contentArray;
            if (this.lastSelectedCell != -1) {
                rectangle = this.getRectangleForCell(this.lastSelectedCell);
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.lastSelectedCell = this.vSelectionIndex.intValue(requester);
            if (this.lastSelectedCell != -1) {
                rectangle = this.getRectangleForCell(this.lastSelectedCell);
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        catch (Exception exception) {
            Log.clog("ContentSelectorGrid.change: " + exception.toString());
        }
    }

    private void drawCell(Graphics graphics, Rectangle rectangle, int n) throws Exception {
        String string;
        Object object;
        if (n == this.lastSelectedCell) {
            graphics.setColor(Color.green);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.black);
        }
        Content content = this.contentArray.nthContent(n);
        graphics.setFont(indexFont);
        graphics.drawString(String.valueOf(n), rectangle.x + 2, rectangle.y + rectangle.height - 2);
        if (content instanceof ContentInspectorFriend) {
            object = (ContentInspectorFriend)((Object)content);
            string = object.getShortDescription();
            graphics.setFont(descFont);
        } else {
            string = "<< unknown content >>";
            graphics.setFont(unknownDescFont);
        }
        object = graphics.getFontMetrics();
        int n2 = ((FontMetrics)object).stringWidth(string);
        graphics.drawString(string, rectangle.x + rectangle.width - n2 - 2, rectangle.y + rectangle.height - 2);
    }

    int getCellAtY(int n) throws Exception {
        int n2 = n / 12;
        if (n2 < 0 || n2 >= this.contentArray.numElements()) {
            return -1;
        }
        return n2;
    }

    private Rectangle getRectangleForCell(int n) {
        return new Rectangle(0, n * 12, this.getSize().width, 12);
    }

    public void paint(Graphics graphics) {
        try {
            if (this.contentArray != null) {
                Rectangle rectangle = graphics.getClipBounds();
                int n = this.getCellAtY(rectangle.y);
                int n2 = this.getCellAtY(rectangle.y + rectangle.height);
                if (n < 0) {
                    n = 0;
                }
                if (n2 == -1) {
                    n2 = this.contentArray.numElements() - 1;
                }
                int n3 = n;
                while (n3 <= n2) {
                    Rectangle rectangle2 = this.getRectangleForCell(n3);
                    this.drawCell(graphics, rectangle2, n3);
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            Log.clog("ContentSelectorGrid.paint: " + exception.toString());
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    class VContentSelectorGridHeight
    extends VInt {
        VContentSelectorGridHeight() {
        }

        protected final int computeInt(Requester requester) throws Exception {
            int n = ContentSelectorGrid.this.vContent.contentArrayValue(requester).numElements();
            return n * 12;
        }
    }

    class ContentSelectorGridMouseAdapter
    extends MouseAdapter {
        ContentSelectorGridMouseAdapter() {
        }

        static /* synthetic */ ContentSelectorGrid access$0(ContentSelectorGridMouseAdapter contentSelectorGridMouseAdapter) {
            return contentSelectorGridMouseAdapter.ContentSelectorGrid.this;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            try {
                Transactor transactor = new Transactor(mouseEvent, this){
                    private final /* synthetic */ ContentSelectorGridMouseAdapter this$1;
                    private final /* synthetic */ MouseEvent val$evt;
                    {
                        this.val$evt = mouseEvent;
                        this.this$1 = contentSelectorGridMouseAdapter;
                    }

                    public void buildChanges(Transaction transaction) throws Exception {
                        int n = ContentSelectorGridMouseAdapter.access$0(this.this$1).getCellAtY(this.val$evt.getY());
                        ContentSelectorGrid.access$1(ContentSelectorGridMouseAdapter.access$0(this.this$1)).setIntValue(transaction, n);
                    }
                };
                transactor.commit();
            }
            catch (Exception exception) {
                Log.clog("ContentSelectorGrid.mouseClicked: " + exception.toString());
            }
        }
    }
}

