/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.HheaTable;
import com.sun.pdfview.font.ttf.MaxpTable;
import com.sun.pdfview.font.ttf.TrueTypeFont;
import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;

public class HmtxTable
extends TrueTypeTable {
    short[] advanceWidths;
    short[] leftSideBearings;

    protected HmtxTable(TrueTypeFont ttf) {
        super(1752003704);
        MaxpTable maxp = (MaxpTable)ttf.getTable("maxp");
        short numGlyphs = maxp.getNumGlyphs();
        HheaTable hhea = (HheaTable)ttf.getTable("hhea");
        short numOfLongHorMetrics = hhea.getNumOfLongHorMetrics();
        this.advanceWidths = new short[numOfLongHorMetrics];
        this.leftSideBearings = new short[numGlyphs];
    }

    public short getAdvance(int glyphID) {
        if (glyphID < this.advanceWidths.length) {
            return this.advanceWidths[glyphID];
        }
        return this.advanceWidths[this.advanceWidths.length - 1];
    }

    public short getLeftSideBearing(int glyphID) {
        return this.leftSideBearings[glyphID];
    }

    public ByteBuffer getData() {
        int size = this.getLength();
        ByteBuffer buf = ByteBuffer.allocate(size);
        for (int i = 0; i < this.leftSideBearings.length; ++i) {
            if (i < this.advanceWidths.length) {
                buf.putShort(this.advanceWidths[i]);
            }
            buf.putShort(this.leftSideBearings[i]);
        }
        buf.flip();
        return buf;
    }

    public void setData(ByteBuffer data) {
        for (int i = 0; i < this.leftSideBearings.length; ++i) {
            if (i < this.advanceWidths.length) {
                this.advanceWidths[i] = data.getShort();
            }
            this.leftSideBearings[i] = data.getShort();
        }
    }

    public int getLength() {
        return this.advanceWidths.length * 2 + this.leftSideBearings.length * 2;
    }
}

