/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TextInput
extends JFrame {
    JPanel contentPane;
    JPanel jPanel1 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    GridLayout gridLayout1 = new GridLayout();
    JLabel keyLabel = new JLabel();
    JTextField keyText = new JTextField();
    JLabel focusLabel = new JLabel();
    JTextField focusText = new JTextField();
    JLabel inputLabel = new JLabel();
    JTextField inputText = new JTextField();
    JLabel modelLabel = new JLabel();
    JTextField modelText = new JTextField();
    IntegerDocument integerDocument1 = new IntegerDocument();

    public TextInput() {
        this.setDefaultCloseOperation(3);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.flowLayout1);
        this.setSize(new Dimension(400, 300));
        this.setTitle("Input Validation");
        this.jPanel1.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(4);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(20);
        this.keyLabel.setText("Key Listener");
        this.modelLabel.setText("Model");
        this.focusLabel.setText("Focus Listener");
        this.inputLabel.setText("Input Verifier");
        this.keyText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    TextInput.this.getToolkit().beep();
                    e.consume();
                }
            }
        });
        this.focusText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField textField = (JTextField)e.getSource();
                String content = textField.getText();
                if (content.length() != 0) {
                    try {
                        Integer.parseInt(content);
                    }
                    catch (NumberFormatException nfe) {
                        TextInput.this.getToolkit().beep();
                        textField.requestFocus();
                    }
                }
            }
        });
        this.inputText.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent comp) {
                boolean returnValue = true;
                JTextField textField = (JTextField)comp;
                String content = textField.getText();
                if (content.length() != 0) {
                    try {
                        Integer.parseInt(textField.getText());
                    }
                    catch (NumberFormatException e) {
                        TextInput.this.getToolkit().beep();
                        returnValue = false;
                    }
                }
                return returnValue;
            }
        });
        this.modelText.setDocument(this.integerDocument1);
        this.contentPane.add(this.jPanel1);
        this.jPanel1.add(this.keyLabel);
        this.jPanel1.add(this.keyText);
        this.jPanel1.add(this.focusLabel);
        this.jPanel1.add(this.focusText);
        this.jPanel1.add(this.inputLabel);
        this.jPanel1.add(this.inputText);
        this.jPanel1.add(this.modelLabel);
        this.jPanel1.add(this.modelText);
    }

    public static void main(String[] args) {
        TextInput frame = new TextInput();
        frame.pack();
        frame.show();
    }

    static class IntegerDocument
    extends PlainDocument {
        IntegerDocument() {
        }

        @Override
        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            String newValue;
            if (string == null) {
                return;
            }
            int length = this.getLength();
            if (length == 0) {
                newValue = string;
            } else {
                String currentContent = this.getText(0, length);
                StringBuffer currentBuffer = new StringBuffer(currentContent);
                currentBuffer.insert(offset, string);
                newValue = currentBuffer.toString();
            }
            try {
                Integer.parseInt(newValue);
                super.insertString(offset, string, attributes);
            }
            catch (NumberFormatException exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

