/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class PDFPrinter
extends JFrame
implements Printable {
    PDFFile pdfFile;

    public PDFPrinter(String title) {
        super(title);
        this.setDefaultCloseOperation(3);
        JMenu menu = new JMenu("File");
        JMenuItem mi = new JMenuItem("Print...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    PDFPrinter.this.doPrint();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(PDFPrinter.this, e.getMessage());
                }
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Exit");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PDFPrinter.this.dispose();
            }
        });
        menu.add(mi);
        JMenuBar mb = new JMenuBar();
        mb.add(menu);
        this.setJMenuBar(mb);
        this.setSize(200, 200);
        this.setVisible(true);
    }

    void doPrint() throws Exception {
        JFileChooser fcOpen = new JFileChooser();
        fcOpen.setCurrentDirectory(new File(System.getProperty("user.dir")));
        fcOpen.setAcceptAllFileFilterUsed(false);
        fcOpen.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String ext;
                if (f.isDirectory()) {
                    return true;
                }
                String s = f.getName();
                int i = s.lastIndexOf(46);
                return i > 0 && i < s.length() - 1 && (ext = s.substring(i + 1).toLowerCase()).equals("pdf");
            }

            @Override
            public String getDescription() {
                return "Accepts .pdf files";
            }
        });
        if (fcOpen.showOpenDialog(this) != 0) {
            return;
        }
        RandomAccessFile raf = new RandomAccessFile(fcOpen.getSelectedFile(), "r");
        FileChannel fc = raf.getChannel();
        MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        this.pdfFile = new PDFFile((ByteBuffer)buf);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        try {
            HashPrintRequestAttributeSet attset = new HashPrintRequestAttributeSet();
            attset.add(new PageRanges(1, this.pdfFile.getNumPages()));
            if (job.printDialog(attset)) {
                job.print(attset);
            }
        }
        catch (PrinterException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage());
        }
    }

    @Override
    public int print(Graphics g, PageFormat format, int index) throws PrinterException {
        int pagenum = index + 1;
        if (pagenum < 1 || pagenum > this.pdfFile.getNumPages()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform at = g2d.getTransform();
        PDFPage pdfPage = this.pdfFile.getPage(pagenum);
        Dimension dim = pdfPage.getUnstretchedSize((int)format.getImageableWidth(), (int)format.getImageableHeight(), pdfPage.getBBox());
        Rectangle bounds = new Rectangle((int)format.getImageableX(), (int)format.getImageableY(), dim.width, dim.height);
        PDFRenderer rend = new PDFRenderer(pdfPage, (Graphics2D)g, bounds, null, null);
        try {
            pdfPage.waitForFinish();
            rend.run();
        }
        catch (InterruptedException ie) {
            JOptionPane.showMessageDialog(this, ie.getMessage());
        }
        g2d.setTransform(at);
        g2d.draw(new Rectangle2D.Double(format.getImageableX(), format.getImageableY(), format.getImageableWidth(), format.getImageableHeight()));
        return 0;
    }

    public static void main(String[] args) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                new PDFPrinter("PDF Printer");
            }
        };
        EventQueue.invokeLater(r);
    }
}

