/*
 * Decompiled with CFR 0.152.
 */
package Sign;

import Sign.AddCertificatesFrame;
import Sign.ScribaSignFrame;
import Sign.ViewCertificateFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import sun.misc.BASE64Encoder;

public class SelectCertificateFrame
extends JFrame {
    KeyStore ks;
    FileInputStream fis;
    private JLabel KsSize;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButtonAddID;
    private JButton jButtonCancel;
    private JButton jButtonExport;
    private JButton jButtonHelp;
    private JButton jButtonRemoveID;
    private JButton jButtonSign;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTableID;

    public SelectCertificateFrame() {
        this.initComponents();
        try {
            this.verifKeyStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        try {
            this.verifKeyStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void verifKeyStore() throws Exception {
        this.clear();
        this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
        this.fis = new FileInputStream(".keystore");
        this.ks.load(this.fis, "scriba".toCharArray());
        this.fis.close();
        if (this.ks.size() == 0) {
            this.KsSize.setText(ResourceBundle.getBundle("Sign/Bundle").getString("NO_ID_IN_YOUR_KEY_STORE"));
        } else {
            this.KsSize.setText("");
        }
        Enumeration<String> aliases = this.ks.aliases();
        int i = 0;
        boolean i1 = false;
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        this.jTableID.getTableHeader().setReorderingAllowed(false);
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!this.ks.isKeyEntry(alias)) continue;
            X509Certificate cert = (X509Certificate)this.ks.getCertificate(alias);
            ((DefaultTableModel)this.jTableID.getModel()).addRow(new Vector());
            this.jTableID.setValueAt(alias, i, 0);
            if (cert.getIssuerDN().getName().split("CN=")[1].split(",") != null) {
                this.jTableID.setValueAt(cert.getIssuerDN().getName().split("CN=")[1].split(",")[0], i, 1);
                this.jTableID.setValueAt(cert.getSubjectDN().getName().split("CN=")[1].split(",")[0], i, 2);
            } else {
                this.jTableID.setValueAt(cert.getIssuerDN().getName().split("CN=")[1], i, 1);
                this.jTableID.setValueAt(cert.getSubjectDN().getName().split("CN=")[1], i, 2);
            }
            this.jTableID.setValueAt(format.format(cert.getNotAfter()), i, 3);
            this.jTableID.setValueAt(cert.getSigAlgName(), i, 4);
            ++i;
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.KsSize = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableID = new JTable();
        this.jPanel3 = new JPanel();
        this.jButtonAddID = new JButton();
        this.jButtonRemoveID = new JButton();
        this.jButton1 = new JButton();
        this.jButtonExport = new JButton();
        this.jPanel4 = new JPanel();
        this.jButtonHelp = new JButton();
        this.jButtonSign = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("Sign/Bundle");
        this.setTitle(bundle.getString("SelectCertificateFrame.title"));
        this.jPanel1.setMaximumSize(new Dimension(700, 440));
        this.jPanel1.setMinimumSize(new Dimension(700, 440));
        this.jPanel1.setPreferredSize(new Dimension(700, 440));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 1));
        this.jPanel5.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.jPanel5.setPreferredSize(new Dimension(100, 30));
        this.jPanel5.setLayout(new GridLayout(1, 0));
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText(bundle.getString("SelectCertificateFrame.jLabel1.text"));
        this.jPanel5.add(this.jLabel1);
        this.KsSize.setMinimumSize(new Dimension(200, 20));
        this.KsSize.setPreferredSize(new Dimension(200, 20));
        this.jPanel5.add(this.KsSize);
        this.jPanel6.add(this.jPanel5);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("SelectCertificateFrame.jPanel2.border.title")));
        this.jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 350));
        this.jPanel2.setMinimumSize(new Dimension(700, 350));
        this.jPanel2.setPreferredSize(new Dimension(1600, 350));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(650, 280));
        this.jScrollPane1.setPreferredSize(new Dimension(650, 280));
        this.jTableID.setModel(new DefaultTableModel(new Object[0][], new String[]{ResourceBundle.getBundle("Sign/Bundle").getString("NAME"), ResourceBundle.getBundle("Sign/Bundle").getString("ISSUER"), ResourceBundle.getBundle("Sign/Bundle").getString("OWNER"), ResourceBundle.getBundle("Sign/Bundle").getString("EXPIRES"), ResourceBundle.getBundle("Sign/Bundle").getString("ALGORITHM")}));
        this.jScrollPane1.setViewportView(this.jTableID);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 59, 0, 59);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.jPanel3.setMinimumSize(new Dimension(499, 30));
        this.jPanel3.setPreferredSize(new Dimension(499, 30));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jButtonAddID.setText(bundle.getString("SelectCertificateFrame.jButtonAddID.text"));
        this.jButtonAddID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectCertificateFrame.this.jButtonAddIDActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel3.add((Component)this.jButtonAddID, gridBagConstraints);
        this.jButtonRemoveID.setText(bundle.getString("SelectCertificateFrame.jButtonRemoveID.text"));
        this.jButtonRemoveID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectCertificateFrame.this.jButtonRemoveIDActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 20);
        this.jPanel3.add((Component)this.jButtonRemoveID, gridBagConstraints);
        this.jButton1.setText(bundle.getString("SelectCertificateFrame.jButton1.text"));
        this.jButton1.setMaximumSize(new Dimension(100, 23));
        this.jButton1.setMinimumSize(new Dimension(100, 23));
        this.jButton1.setPreferredSize(new Dimension(100, 23));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectCertificateFrame.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 20, 12, 5);
        this.jPanel3.add((Component)this.jButton1, gridBagConstraints);
        this.jButtonExport.setText(bundle.getString("SelectCertificateFrame.jButtonExport.text"));
        this.jButtonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectCertificateFrame.this.jButtonExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 5, 12, 200);
        this.jPanel3.add((Component)this.jButtonExport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 59, 0, 59);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel6.add(this.jPanel2);
        this.jTabbedPane1.addTab(bundle.getString("SelectCertificateFrame.jPanel6.TabConstraints.tabTitle"), this.jPanel6);
        this.jPanel1.add(this.jTabbedPane1);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonHelp.setText(bundle.getString("SelectCertificateFrame.jButtonHelp.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel4.add((Component)this.jButtonHelp, gridBagConstraints);
        this.jButtonSign.setText(bundle.getString("SelectCertificateFrame.jButtonSign.text"));
        this.jButtonSign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectCertificateFrame.this.jButtonSignActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel4.add((Component)this.jButtonSign, gridBagConstraints);
        this.jButtonCancel.setText(bundle.getString("SelectCertificateFrame.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectCertificateFrame.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel4.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jLabel3.setMinimumSize(new Dimension(250, 0));
        this.jLabel3.setPreferredSize(new Dimension(250, 0));
        this.jLabel3.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        this.jPanel1.add(this.jPanel4);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSignActionPerformed(ActionEvent evt) {
        if (this.jTableID.getSelectedRows().length == 1) {
            String alias = (String)this.jTableID.getValueAt(this.jTableID.getSelectedRow(), 0);
            ScribaSignFrame frame = new ScribaSignFrame("MainDeclaration", "MainDeclaration", alias);
            frame.setVisible(true);
        }
    }

    private void jButtonAddIDActionPerformed(ActionEvent evt) {
        new AddCertificatesFrame(this).setVisible(true);
    }

    private void jButtonRemoveIDActionPerformed(ActionEvent evt) {
        if (this.jTableID.getSelectedRows().length > 0 && JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("DO_YOU_REALLY_WANT_TO_REMOVE_THIS_ENTRY?")) == 0) {
            int row = 0;
            while (row < this.jTableID.getSelectedRows().length) {
                String alias = (String)this.jTableID.getValueAt(this.jTableID.getSelectedRows()[row], 0);
                try {
                    this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    this.fis = new FileInputStream(".keystore");
                    this.ks.load(this.fis, "scriba".toCharArray());
                    this.fis.close();
                    this.ks.deleteEntry(alias);
                    FileOutputStream fout = new FileOutputStream(".keystore");
                    this.ks.store(fout, "scriba".toCharArray());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, String.valueOf(ResourceBundle.getBundle("Sign/Bundle").getString("ERROR")) + e.getMessage(), "Error", 0);
                    System.out.println(e.getMessage());
                }
                ++row;
            }
            int count = this.jTableID.getRowCount();
            int i = 0;
            while (i < count) {
                ((DefaultTableModel)this.jTableID.getModel()).removeRow(0);
                ++i;
            }
            try {
                this.verifKeyStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.jTableID.getSelectedRow() > -1) {
            String alias = (String)this.jTableID.getValueAt(this.jTableID.getSelectedRow(), 0);
            new ViewCertificateFrame(alias).setVisible(true);
        }
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        if (this.jTableID.getSelectedRow() > -1) {
            String alias = (String)this.jTableID.getValueAt(this.jTableID.getSelectedRow(), 0);
            JFileChooser fileDlg = new JFileChooser(new File(".").getAbsolutePath());
            if (fileDlg.showSaveDialog(this) == 0) {
                try {
                    X509Certificate cert = (X509Certificate)this.ks.getCertificate(alias);
                    File file = fileDlg.getSelectedFile();
                    FileOutputStream os = new FileOutputStream(file);
                    PrintStream ps = new PrintStream(os);
                    BASE64Encoder encoder = new BASE64Encoder();
                    ps.println("-----BEGIN CERTIFICATE-----");
                    encoder.encodeBuffer(cert.getEncoded(), (OutputStream)ps);
                    ps.println("-----END CERTIFICATE-----");
                    JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("CERTIFICATE_EXPORTED"));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("CAN_NOT_GENERATE_CERTIFICATE"));
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SelectCertificateFrame().setVisible(true);
            }
        });
    }

    private void clear() {
        int row = this.jTableID.getRowCount();
        int i = 0;
        while (i < row) {
            ((DefaultTableModel)this.jTableID.getModel()).removeRow(0);
            ++i;
        }
    }
}

