/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import RepeateTables.AttachementTable;
import RepeateTables.RepeatTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ButtonEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    JButton button;
    RepeatTable repeat;
    String action;

    public ButtonEditor(RepeatTable table, String action) {
        this.action = action;
        this.repeat = table;
        this.button = new JButton();
        this.button.setActionCommand(action);
        this.button.addActionListener(this);
        this.button.setBorderPainted(true);
        this.button.setOpaque(true);
        this.button.setBackground(Color.gray);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireEditingStopped();
        int row = this.repeat.table.getSelectedRow();
        int col = this.repeat.table.getSelectedColumn();
        int rowCount = row;
        if ("+".equals(e.getActionCommand())) {
            if (row != this.repeat.table.getRowCount() - 1) {
                while (row != this.repeat.table.getRowCount() - 1 && this.repeat.table.getValueAt(row + 1, col) == null) {
                    ++row;
                }
            }
            this.repeat.insertRow(row + 1, col);
            this.fireEditingStopped();
        } else if ("-".equals(e.getActionCommand())) {
            if (row != 0) {
                this.repeat.deleteRow(row);
                while (row <= this.repeat.table.getRowCount() - 1 && this.repeat.table.getValueAt(row, col) == null) {
                    this.repeat.deleteRow(row);
                    this.fireEditingCanceled();
                    if (row > this.repeat.table.getRowCount() - 1) break;
                }
                this.fireEditingCanceled();
            } else {
                boolean last;
                block21: {
                    do {
                        if (rowCount != this.repeat.table.getRowCount() - 1) continue;
                        last = false;
                        break block21;
                    } while (this.repeat.table.getValueAt(++rowCount, col) == null);
                    last = true;
                }
                if (last) {
                    this.repeat.deleteRow(row);
                    while (row <= this.repeat.table.getRowCount() - 1 && this.repeat.table.getValueAt(row, col) == null) {
                        this.repeat.deleteRow(row);
                        this.fireEditingCanceled();
                        if (row > this.repeat.table.getRowCount() - 1) break;
                    }
                    this.fireEditingCanceled();
                }
            }
        } else if (ResourceBundle.getBundle("RepeateTables/Bundle").getString("ATTACH").equals(e.getActionCommand())) {
            JFileChooser fileDlg = new JFileChooser(new File(".").getAbsolutePath());
            fileDlg.setSelectedFile(null);
            if (fileDlg.showOpenDialog(null) == 0) {
                File file = fileDlg.getSelectedFile();
                if (file == null) {
                    return;
                }
                ((AttachementTable)this.repeat).encodeFileData(row, file.getAbsolutePath());
                String filename = file.getName();
                String ext = filename.lastIndexOf(".") == -1 ? "" : filename.substring(filename.lastIndexOf(".") + 1, filename.length());
                String name = filename.substring(0, filename.length() - ext.length() - 1);
                this.repeat.table.setValueAt(name, row, 2);
                this.repeat.table.setValueAt(ext, row, 3);
            }
            this.fireEditingStopped();
        } else {
            if (ResourceBundle.getBundle("RepeateTables/Bundle").getString("SAVE").equals(e.getActionCommand())) {
                if (this.repeat.model.getValueAt(row, 2).equals("")) {
                    return;
                }
                JFileChooser fileDlg = new JFileChooser();
                fileDlg.setSelectedFile(new File(this.repeat.table.getValueAt(row, 2) + "." + this.repeat.table.getValueAt(row, 3)));
                if (fileDlg.showSaveDialog(null) == 0) {
                    int result;
                    File file = fileDlg.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    if (file.exists() && (result = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("RepeateTables/Bundle").getString("DO_YOU_WANT_TO_REPLACE_THE_EXISTING_FILE_?"), ResourceBundle.getBundle("RepeateTables/Bundle").getString("SAVE_FILE"), 0)) != 0) {
                        return;
                    }
                    ((AttachementTable)this.repeat).decodetoFile(row, file.getAbsolutePath());
                }
            }
            this.fireEditingStopped();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.action;
    }
}

