/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.util.Hashtable;

public class ImageMonitor
implements ImageConsumer,
ImageObserver {
    private Image image;
    private boolean productionStarted;
    private boolean frameOK;
    private volatile boolean imageDone;
    private volatile int height;
    private volatile int width;

    public ImageMonitor(Image image) {
        this.image = image;
        this.productionStarted = false;
        this.imageDone = false;
        this.height = -1;
        this.width = -1;
        this.frameOK = true;
    }

    private void doStartProduction() {
        if (!this.productionStarted) {
            this.productionStarted = true;
            this.image.getSource().startProduction(this);
        }
    }

    public synchronized int getHeight() throws InterruptedException {
        if (this.height < 0) {
            this.doStartProduction();
            while (this.height < 0 && !this.imageDone) {
                this.wait();
            }
        }
        return this.height;
    }

    public synchronized int getWidth() throws InterruptedException {
        if (this.width < 0) {
            this.doStartProduction();
            while (this.width < 0 && !this.imageDone) {
                this.wait();
            }
        }
        return this.width;
    }

    public void imageComplete(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 16;
                break;
            }
            case 3: {
                n2 = 32;
                break;
            }
            case 1: {
                n2 = 64;
                break;
            }
            case 4: {
                n2 = 128;
                break;
            }
        }
        this.imageUpdate(this.image, n2, 0, 0, 0, 0);
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        this.productionStarted = true;
        if ((n & 2) != 0 && this.height != n5) {
            this.height = n5;
            bl = true;
        }
        if ((n & 1) != 0 && this.width != n4) {
            this.width = n4;
            bl = true;
        }
        int n6 = 224;
        if (this.frameOK) {
            n6 += 16;
        }
        if ((n & n6) != 0) {
            this.imageDone = true;
        }
        if (bl || this.imageDone) {
            this.notifyAll();
        }
        return this.imageDone ^ true;
    }

    public void setColorModel(ColorModel colorModel) {
        this.imageUpdate(this.image, 0, 0, 0, 0, 0);
    }

    public void setDimensions(int n, int n2) {
        this.imageUpdate(this.image, 3, 0, 0, n, n2);
    }

    public void setHints(int n) {
        this.imageUpdate(this.image, 0, 0, 0, 0, 0);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        this.imageUpdate(this.image, 8, n, n2, n3, n4);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        this.imageUpdate(this.image, 8, n, n2, n3, n4);
    }

    public void setProperties(Hashtable hashtable) {
        this.imageUpdate(this.image, 4, 0, 0, 0, 0);
    }

    public synchronized void waitForAll() {
        this.frameOK = false;
        if (!this.imageDone) {
            this.doStartProduction();
            try {
                while (!this.imageDone) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public synchronized void waitForFrame() {
        this.frameOK = true;
        if (!this.imageDone) {
            this.doStartProduction();
            try {
                while (!this.imageDone) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

