/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.painting;

import com.adobe.pe.painting.Painting;
import com.adobe.pe.painting.PaintingSampler;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class TranslatedPainting
extends Painting {
    Painting srcPainting;
    private int hDelta;
    private int vDelta;

    public TranslatedPainting(Painting painting, int n, int n2) {
        super(TranslatedPainting.computeBounds(painting, n, n2), false, true);
        this.srcPainting = painting;
        this.hDelta = n;
        this.vDelta = n2;
    }

    public PaintingSampler acquireSampler(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        final Point point = new Point(this.hDelta, this.vDelta);
        rectangle2.translate(-this.hDelta, -this.vDelta);
        final PaintingSampler paintingSampler = this.srcPainting.acquireSampler(rectangle2);
        return new PaintingSampler(this, rectangle){

            public void stopDrawing() {
                paintingSampler.stopDrawing();
            }

            public boolean waitAndSample(Graphics graphics, boolean bl, long l) throws Throwable {
                return paintingSampler.waitAndSample(graphics, bl, l, point);
            }
        };
    }

    private static Rectangle computeBounds(Painting painting, int n, int n2) {
        Rectangle rectangle = painting.getBounds();
        if (rectangle == null) {
            return null;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.translate(n, n2);
        return rectangle2;
    }

    public void draw(Graphics graphics) throws Exception {
        this.srcPainting.draw(graphics, new Point(this.hDelta, this.vDelta));
    }
}

