/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.VSynchronizer;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.util.PEUtil;
import com.adobe.pe.vtypes.VString;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.InterruptedIOException;

public class VTextField
extends TextField
implements VObserver,
ActionListener,
FocusListener,
TextListener,
StrobeContainer {
    private TransactionExecutionContext exContext;
    private VString vIn;
    private VString vOut;
    private VStrobe strobe;
    private VSynchronizer textSynchronizer = new VSynchronizer();

    public VTextField(TransactionExecutionContext transactionExecutionContext, VString vString, VString vString2, int n, boolean bl) {
        super("", n);
        this.exContext = transactionExecutionContext;
        this.vIn = vString;
        this.vOut = vString2;
        if (bl) {
            this.addTextListener(this);
        } else {
            this.addActionListener(this);
            this.addFocusListener(this);
        }
        this.strobe = new VStrobe(this);
    }

    public VTextField(TransactionExecutionContext transactionExecutionContext, VString vString, VString vString2, boolean bl) {
        this(transactionExecutionContext, vString, vString2, 0, bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.flushValue();
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            String string = this.vOut.stringValue(requester);
            if (!this.getText().equals(string)) {
                this.setText(string);
            }
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (Exception exception) {
            this.setText(PEUtil.getThrowableMessage(exception, true));
        }
    }

    private void flushValue() {
        final String string = this.getText();
        Transactor transactor = new Transactor(){

            protected final void buildChanges(Transaction transaction) throws Exception {
                vIn.setStringValue(transaction, string);
            }
        };
        this.textSynchronizer.setTransactor(this.exContext, transactor);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.flushValue();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    public void textValueChanged(TextEvent textEvent) {
        this.flushValue();
    }
}

