/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.DeviceRGBColorModel;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.MultiPath;
import com.adobe.acrobat.sidecar.PolygonADV;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.acrobat.util.Session;
import com.adobe.util.ImageMonitor;
import com.adobe.util.ImageUtil;
import com.adobe.util.MemUtil;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import netscape.security.PrivilegeManager;

public class ImageGraphics
extends Graphics
implements Cloneable {
    SidecarImage image;
    Rectangle imageRect;
    int scanSize;
    int offset;
    Object pixels;
    byte[] bytePix;
    int[] intPix;
    boolean premultipliedAlpha;
    Point origin;
    Rectangle clip;
    Color foreColor = Color.black;
    int foreColorRGB = this.foreColor.getRGB();
    int xorColorRGB = Color.white.getRGB();
    int useColorRGB;
    int useColorR;
    int useColorG;
    int useColorB;
    int useColorAlpha;
    int useColorRGBp;
    int useColorRp;
    int useColorGp;
    int useColorBp;
    boolean doXOR = false;
    Font font;

    public ImageGraphics(SidecarImage sidecarImage) {
        this.setUseColor();
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
            }
            this.font = Font.getFont("Serif");
        }
        catch (Exception exception) {}
        this.image = sidecarImage;
        sidecarImage.startProduction(null);
        this.imageRect = sidecarImage.getRect();
        this.origin = new Point(-this.imageRect.x, -this.imageRect.y);
        this.imageRect.y = 0;
        this.imageRect.x = 0;
        this.clip = this.imageRect;
        this.scanSize = sidecarImage.getScanSize();
        this.offset = sidecarImage.getPixelOffset();
        this.pixels = sidecarImage.getPixels();
        if (this.pixels instanceof byte[]) {
            this.bytePix = (byte[])this.pixels;
            this.intPix = null;
        } else if (this.pixels instanceof int[]) {
            this.bytePix = null;
            this.intPix = (int[])this.pixels;
        }
        this.premultipliedAlpha = sidecarImage.getPremultipliedAlpha();
    }

    public void clearAll() {
        if (this.bytePix != null) {
            MemUtil.arraySet(this.bytePix, 0, this.bytePix.length, new Byte(0));
        } else if (this.intPix != null) {
            MemUtil.arraySet(this.intPix, 0, this.intPix.length, new Integer(0));
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        int n5;
        Rectangle rectangle = this.clip.intersection(new Rectangle(n += this.origin.x, n2 += this.origin.y, n3, n4));
        if (rectangle.isEmpty()) {
            return;
        }
        n = rectangle.x;
        n2 = rectangle.y;
        int n6 = this.offset + n2 * this.scanSize + n;
        if (this.bytePix != null) {
            n5 = 0;
            while (n5 < rectangle.width) {
                this.bytePix[n6 + n5] = 0;
                ++n5;
            }
        } else if (this.intPix != null) {
            n5 = 0;
            while (n5 < rectangle.width) {
                this.intPix[n6 + n5] = 0;
                ++n5;
            }
        }
        int n7 = n6;
        int n8 = 1;
        while (n8 < rectangle.height) {
            System.arraycopy(this.pixels, n6, this.pixels, n7 += this.scanSize, rectangle.width);
            ++n8;
        }
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip = this.clip.intersection(new Rectangle(n += this.origin.x, n2 += this.origin.y, n3, n4));
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        block6: {
            if (n5 == 0 && n6 == 0) {
                return;
            }
            Rectangle rectangle = new Rectangle(n += this.origin.x, n2 += this.origin.y, n3, n4);
            rectangle = rectangle.intersection(this.imageRect);
            rectangle.translate(n5, n6);
            rectangle = rectangle.intersection(this.clip);
            rectangle.translate(-n5, -n6);
            if (rectangle.isEmpty()) {
                return;
            }
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.width;
            n4 = rectangle.height;
            if (this.pixels == null) break block6;
            int n7 = this.offset + n2 * this.scanSize + n;
            int n8 = this.offset + (n2 + n6) * this.scanSize + (n + n5);
            if (n6 <= 0) {
                int n9 = 0;
                while (n9 < n4) {
                    System.arraycopy(this.pixels, n7, this.pixels, n8, n3);
                    n7 += this.scanSize;
                    n8 += this.scanSize;
                    ++n9;
                }
            } else {
                n7 += n4 * this.scanSize;
                n8 += n4 * this.scanSize;
                int n10 = 0;
                while (n10 < n4) {
                    System.arraycopy(this.pixels, n7 -= this.scanSize, this.pixels, n8 -= this.scanSize, n3);
                    ++n10;
                }
            }
        }
    }

    public Graphics create() {
        try {
            return (Graphics)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dispose() {
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new RuntimeException("drawArc(...) not implemented");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        throw new RuntimeException("drawImage(Image, int, int, int, int, int, int, int, int, Color, ImageObserver) not implemented");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        throw new RuntimeException("drawImage(Image, int, int, int, int, int, int, int, int, ImageObserver) not implemented");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        throw new RuntimeException("drawImage(Image, int, int, int, int, Color, ImageObserver) not implemented");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        throw new RuntimeException("drawImage(Image, int, int, int, int, ImageObserver) not implemented");
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        throw new RuntimeException("drawImage(Image, int, int, Color, ImageObserver) not implemented");
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.image.startProduction(null);
        ImageProxy imageProxy = new ImageProxy(image, n += this.origin.x, n2 += this.origin.y, imageObserver);
        imageProxy.start();
        return imageProxy.finished();
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine(n, n2, n3, n4, true);
    }

    /*
     * Unable to fully structure code
     */
    private void drawLine(int var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        block24: {
            block25: {
                block22: {
                    block23: {
                        var3_3 += this.origin.x;
                        if ((var1_1 += this.origin.x) < this.clip.x && var3_3 < this.clip.x || var1_1 >= this.clip.x + this.clip.width && var3_3 >= this.clip.x + this.clip.width || var2_2 < this.clip.y && var4_4 < this.clip.y || (var2_2 += this.origin.y) >= this.clip.y + this.clip.height && (var4_4 += this.origin.y) >= this.clip.y + this.clip.height) {
                            return;
                        }
                        var6_6 = var1_1;
                        var8_7 = var2_2;
                        var10_8 = var3_3;
                        var12_9 = var4_4;
                        var14_10 = var10_8 - var6_6;
                        var16_11 = var14_10 >= 0.0 ? var14_10 : -var14_10;
                        var18_12 = var12_9 - var8_7;
                        var20_13 = var18_12 >= 0.0 ? var18_12 : -var18_12;
                        var22_14 = 0.0;
                        var24_15 = 0.0;
                        v0 = var26_16 = var5_5 != false ? 1 : 0;
                        if (var14_10 != 0.0 || var18_12 != 0.0) {
                            if (var16_11 < var20_13) {
                                var22_14 = var14_10 / var20_13;
                                var24_15 = var18_12 < 0.0 ? -1.0 : 1.0;
                                var10_8 = var6_6 + (double)((var26_16 += (int)var20_13) - 1) * var22_14;
                                var12_9 = var8_7 + (double)(var26_16 - 1) * var24_15;
                                if (var12_9 < var8_7) {
                                    var27_17 = var6_6;
                                    var6_6 = var10_8;
                                    var10_8 = var27_17;
                                    var27_17 = var8_7;
                                    var8_7 = var12_9;
                                    var12_9 = var27_17;
                                    var22_14 = -var22_14;
                                    var24_15 = -var24_15;
                                }
                                if (var8_7 < (double)this.clip.y) {
                                    var27_18 = this.clip.y - (int)var8_7;
                                    var8_7 = this.clip.y;
                                    var6_6 += (double)var27_18 * var22_14;
                                    var26_16 -= var27_18;
                                }
                                if (var12_9 >= (double)(this.clip.y + this.clip.height)) {
                                    var26_16 -= (int)var12_9 - (this.clip.y + this.clip.height) + 1;
                                }
                            } else {
                                var24_15 = var18_12 / var16_11;
                                var22_14 = var14_10 < 0.0 ? -1.0 : 1.0;
                                var10_8 = var6_6 + (double)((var26_16 += (int)var16_11) - 1) * var22_14;
                                var12_9 = var8_7 + (double)(var26_16 - 1) * var24_15;
                                if (var10_8 < var6_6) {
                                    var27_19 = var6_6;
                                    var6_6 = var10_8;
                                    var10_8 = var27_19;
                                    var27_19 = var8_7;
                                    var8_7 = var12_9;
                                    var12_9 = var27_19;
                                    var22_14 = -var22_14;
                                    var24_15 = -var24_15;
                                }
                                if (var6_6 < (double)this.clip.x) {
                                    var27_20 = this.clip.x - (int)var6_6;
                                    var6_6 = this.clip.x;
                                    var8_7 += (double)var27_20 * var24_15;
                                    var26_16 -= var27_20;
                                }
                                if (var10_8 >= (double)(this.clip.x + this.clip.width)) {
                                    var26_16 -= (int)var10_8 - (this.clip.x + this.clip.width) + 1;
                                }
                            }
                        }
                        if (this.bytePix == null) break block22;
                        if (!this.doXOR) break block23;
                        var33_27 = (byte)this.useColorAlpha;
                        while (var26_16-- > 0) {
                            var28_31 = (int)Math.round(var6_6);
                            var29_37 = (int)Math.round(var8_7);
                            if (var28_31 >= this.clip.x && var28_31 < this.clip.x + this.clip.width && var29_37 >= this.clip.y && var29_37 < this.clip.y + this.clip.height) {
                                v1 = var27_21 = this.offset + var29_37 * this.scanSize + var28_31;
                                this.bytePix[v1] = (byte)(this.bytePix[v1] ^ var33_27);
                            }
                            var6_6 += var22_14;
                            var8_7 += var24_15;
                        }
                        break block24;
                    }
                    if (this.useColorAlpha != 255) ** GOTO lbl92
                    var33_28 = -1;
                    while (var26_16-- > 0) {
                        var28_32 = (int)Math.round(var6_6);
                        var29_38 = (int)Math.round(var8_7);
                        if (var28_32 >= this.clip.x && var28_32 < this.clip.x + this.clip.width && var29_38 >= this.clip.y && var29_38 < this.clip.y + this.clip.height) {
                            var27_22 = this.offset + var29_38 * this.scanSize + var28_32;
                            this.bytePix[var27_22] = var33_28;
                        }
                        var6_6 += var22_14;
                        var8_7 += var24_15;
                    }
                    break block24;
lbl-1000:
                    // 1 sources

                    {
                        var28_33 = (int)Math.round(var6_6);
                        var29_39 = (int)Math.round(var8_7);
                        if (var28_33 >= this.clip.x && var28_33 < this.clip.x + this.clip.width && var29_39 >= this.clip.y && var29_39 < this.clip.y + this.clip.height) {
                            var27_23 = this.offset + var29_39 * this.scanSize + var28_33;
                            var33_29 = this.bytePix[var27_23];
                            this.bytePix[var27_23] = this.mergeColor(var33_29, 255);
                        }
                        var6_6 += var22_14;
                        var8_7 += var24_15;
lbl92:
                        // 2 sources

                        ** while (var26_16-- > 0)
                    }
lbl93:
                    // 1 sources

                    break block24;
                }
                if (this.intPix == null) break block24;
                if (!this.doXOR) break block25;
                while (var26_16-- > 0) {
                    var28_34 = (int)Math.round(var6_6);
                    var29_40 = (int)Math.round(var8_7);
                    if (var28_34 >= this.clip.x && var28_34 < this.clip.x + this.clip.width && var29_40 >= this.clip.y && var29_40 < this.clip.y + this.clip.height) {
                        v2 = var27_24 = this.offset + var29_40 * this.scanSize + var28_34;
                        this.intPix[v2] = this.intPix[v2] ^ this.useColorRGB;
                    }
                    var6_6 += var22_14;
                    var8_7 += var24_15;
                }
                break block24;
            }
            if (this.useColorAlpha != 255) ** GOTO lbl127
            while (var26_16-- > 0) {
                var28_35 = (int)Math.round(var6_6);
                var29_41 = (int)Math.round(var8_7);
                if (var28_35 >= this.clip.x && var28_35 < this.clip.x + this.clip.width && var29_41 >= this.clip.y && var29_41 < this.clip.y + this.clip.height) {
                    var27_25 = this.offset + var29_41 * this.scanSize + var28_35;
                    this.intPix[var27_25] = this.useColorRGBp;
                }
                var6_6 += var22_14;
                var8_7 += var24_15;
            }
            break block24;
lbl-1000:
            // 1 sources

            {
                var28_36 = (int)Math.round(var6_6);
                var29_42 = (int)Math.round(var8_7);
                if (var28_36 >= this.clip.x && var28_36 < this.clip.x + this.clip.width && var29_42 >= this.clip.y && var29_42 < this.clip.y + this.clip.height) {
                    var27_26 = this.offset + var29_42 * this.scanSize + var28_36;
                    var33_30 = this.intPix[var27_26];
                    this.intPix[var27_26] = this.mergeColor(var33_30, 255);
                }
                var6_6 += var22_14;
                var8_7 += var24_15;
lbl127:
                // 2 sources

                ** while (var26_16-- > 0)
            }
        }
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawRoundRect(n, n2, n3, n4, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        if (n == 1) {
            this.drawLine(nArray[0], nArray2[0], nArray[0], nArray2[0]);
        } else if (n > 1) {
            int n2 = 0;
            while (n2 < n - 1) {
                this.drawLine(nArray[n2], nArray2[n2], nArray[n2 + 1], nArray2[n2 + 1], false);
                ++n2;
            }
            if (nArray[n2] != nArray[0] || nArray2[n2] != nArray2[0]) {
                this.drawLine(nArray[n2], nArray2[n2], nArray[0], nArray2[0], false);
            }
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n == 1) {
            this.drawLine(nArray[0], nArray2[0], nArray[0], nArray2[0]);
        } else if (n > 1) {
            int n2 = 0;
            while (n2 < n - 2) {
                this.drawLine(nArray[n2], nArray2[n2], nArray[n2 + 1], nArray2[n2 + 1], false);
                ++n2;
            }
            this.drawLine(nArray[n2], nArray2[n2], nArray[n2 + 1], nArray2[n2 + 1], true);
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            return;
        }
        if (n4 == 0 || n3 == 0) {
            this.drawLine(n, n2, n + n3, n2 + n4);
        } else {
            this.drawLine(n, n2, n + n3 - 1, n2, false);
            this.drawLine(n + n3, n2, n + n3, n2 + n4 - 1, false);
            this.drawLine(n + n3, n2 + n4, n + 1, n2 + n4, false);
            this.drawLine(n, n2 + n4, n, n2 + 1, false);
        }
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        ComplexPolygon complexPolygon = this.roundRectPoly(n, n2, n3, n4, n5, n6);
        int n7 = complexPolygon.size();
        int n8 = 0;
        while (n8 < n7) {
            PolygonADV polygonADV = (PolygonADV)complexPolygon.elementAt(n8);
            this.drawPolygon(polygonADV.toPolygon());
            ++n8;
        }
    }

    public void drawString(String string, int n, int n2) {
        block13: {
            SidecarImage sidecarImage;
            Rectangle rectangle;
            Rectangle rectangle2;
            block12: {
                int n3;
                FontMetrics fontMetrics = this.getFontMetrics(this.font);
                int n4 = fontMetrics.getMaxAscent() + 1;
                int n5 = fontMetrics.getMaxDescent() + 1;
                int n6 = fontMetrics.getMaxAdvance();
                rectangle2 = new Rectangle((n += this.origin.x) - n6, (n2 += this.origin.y) - n4, n3 = fontMetrics.stringWidth(string) + 2 * n6, n4 + n5);
                rectangle = this.clip.intersection(rectangle2);
                if (rectangle.isEmpty()) {
                    return;
                }
                Image image = ImageUtil.createImage(rectangle.width, rectangle.height);
                Graphics graphics = image.getGraphics();
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, rectangle2.width, rectangle2.height);
                graphics.setColor(Color.white);
                graphics.setFont(this.font);
                graphics.drawString(string, n6 - rectangle.x + rectangle2.x, n4 - rectangle.y + rectangle2.y);
                graphics.dispose();
                sidecarImage = SidecarImage.clipFromImage(image);
                sidecarImage.setOrigin(rectangle.x, rectangle.y);
                if (this.doXOR) break block12;
                float[] fArray = new float[3];
                int n7 = this.foreColorRGB;
                fArray[0] = (float)(n7 >> 16 & 0xFF) / 255.0f;
                fArray[1] = (float)(n7 >> 8 & 0xFF) / 255.0f;
                fArray[2] = (float)(n7 & 0xFF) / 255.0f;
                ColorValue colorValue = new ColorValue(DeviceRGBColorModel.DefaultColorModel, fArray);
                colorValue.setOpacity((float)(n7 >>> 24) / 255.0f);
                ImageMonitor imageMonitor = new ImageMonitor(sidecarImage);
                if (this.drawImage(sidecarImage, rectangle.x, rectangle.y, imageMonitor)) break block13;
                imageMonitor.waitForFrame();
                break block13;
            }
            int n8 = this.foreColorRGB ^ this.xorColorRGB;
            if (n8 == 0) {
                return;
            }
            int n9 = sidecarImage.getScanSize();
            int n10 = sidecarImage.getPixelOffset();
            byte[] byArray = (byte[])sidecarImage.getPixels();
            n = rectangle.x;
            n2 = rectangle.y;
            int n11 = n10;
            int n12 = this.offset + rectangle2.y * this.scanSize + rectangle2.x;
            if (this.bytePix != null) {
                byte by = (byte)(n8 >>> 24);
                if (by == 0) {
                    return;
                }
                int n13 = 0;
                while (n13 < rectangle2.height) {
                    int n14 = 0;
                    while (n14 < rectangle2.width) {
                        int n15 = byArray[n11 + n14] & 0xFF;
                        if (n15 > 127) {
                            int n16 = n12 + n14;
                            this.bytePix[n16] = (byte)(this.bytePix[n16] ^ by);
                        }
                        ++n14;
                    }
                    n11 += n9;
                    n12 += this.scanSize;
                    ++n13;
                }
            } else if (this.intPix != null) {
                int n17 = 0;
                while (n17 < rectangle2.height) {
                    int n18 = 0;
                    while (n18 < rectangle2.width) {
                        int n19 = byArray[n11 + n18] & 0xFF;
                        if (n19 > 127) {
                            int n20 = n12 + n18;
                            this.intPix[n20] = this.intPix[n20] ^ n8;
                        }
                        ++n18;
                    }
                    n11 += n9;
                    n12 += this.scanSize;
                    ++n17;
                }
            }
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new RuntimeException("fillArc(...) not implemented");
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillRoundRect(n, n2, n3, n4, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        PolygonADV polygonADV = new PolygonADV(nArray, nArray2, n);
        polygonADV.translate(this.origin.x, this.origin.y);
        MultiPath multiPath = new MultiPath(polygonADV, 2);
        multiPath.fillPath(this, true);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        block22: {
            int n5;
            Rectangle rectangle;
            block21: {
                rectangle = this.clip.intersection(new Rectangle(n += this.origin.x, n2 += this.origin.y, n3, n4));
                if (rectangle.isEmpty()) {
                    return;
                }
                n = rectangle.x;
                n2 = rectangle.y;
                n5 = this.offset + n2 * this.scanSize + n;
                if (this.bytePix == null) break block21;
                if (this.doXOR) {
                    byte by = (byte)this.useColorAlpha;
                    int n6 = 0;
                    while (n6 < rectangle.height) {
                        int n7 = 0;
                        while (n7 < rectangle.width) {
                            int n8 = n5 + n7;
                            this.bytePix[n8] = (byte)(this.bytePix[n8] ^ by);
                            ++n7;
                        }
                        n5 += this.scanSize;
                        ++n6;
                    }
                } else if (this.useColorAlpha == 255) {
                    int n9 = -1;
                    int n10 = 0;
                    while (n10 < rectangle.width) {
                        this.bytePix[n5 + n10] = n9;
                        ++n10;
                    }
                    int n11 = n5;
                    int n12 = 1;
                    while (n12 < rectangle.height) {
                        System.arraycopy(this.pixels, n5, this.pixels, n11 += this.scanSize, rectangle.width);
                        ++n12;
                    }
                } else {
                    int n13 = 0;
                    while (n13 < rectangle.height) {
                        int n14 = 0;
                        while (n14 < rectangle.width) {
                            byte by = this.bytePix[n5 + n14];
                            this.bytePix[n5 + n14] = this.mergeColor(by, 255);
                            ++n14;
                        }
                        n5 += this.scanSize;
                        ++n13;
                    }
                }
                break block22;
            }
            if (this.intPix == null) break block22;
            if (this.doXOR) {
                int n15 = 0;
                while (n15 < rectangle.height) {
                    int n16 = 0;
                    while (n16 < rectangle.width) {
                        int n17 = n5 + n16;
                        this.intPix[n17] = this.intPix[n17] ^ this.useColorRGB;
                        ++n16;
                    }
                    n5 += this.scanSize;
                    ++n15;
                }
            } else if (this.useColorAlpha == 255) {
                int n18 = 0;
                while (n18 < rectangle.width) {
                    this.intPix[n5 + n18] = this.useColorRGBp;
                    ++n18;
                }
                int n19 = n5;
                int n20 = 1;
                while (n20 < rectangle.height) {
                    System.arraycopy(this.pixels, n5, this.pixels, n19 += this.scanSize, rectangle.width);
                    ++n20;
                }
            } else {
                int n21 = 0;
                while (n21 < rectangle.height) {
                    int n22 = 0;
                    while (n22 < rectangle.width) {
                        int n23 = this.intPix[n5 + n22];
                        this.intPix[n5 + n22] = this.mergeColor(n23, 255);
                        ++n22;
                    }
                    n5 += this.scanSize;
                    ++n21;
                }
            }
        }
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        ComplexPolygon complexPolygon = this.roundRectPoly(n, n2, n3, n4, n5, n6);
        MultiPath multiPath = new MultiPath(complexPolygon, 2);
        multiPath.fillPath(this, true);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        return new Rectangle(this.clip.x - this.origin.x, this.clip.y - this.origin.y, this.clip.width, this.clip.height);
    }

    public Color getColor() {
        return this.foreColor;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Point getOrigin() {
        return new Point(this.origin);
    }

    private byte mergeColor(byte by, int n) {
        n *= this.useColorAlpha;
        n = n + (n >>> 8) + 1 >>> 8;
        if (by != 0) {
            int n2 = (by & 0xFF) * (255 - n);
            return (byte)(n + (n2 + (n2 >>> 8) + 1 >>> 8));
        }
        return (byte)n;
    }

    private int mergeColor(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = n >>> 24;
        if (n6 == 0) {
            if (n2 == 255) {
                return this.useColorRGBp;
            }
            n2 *= this.useColorAlpha;
            n2 = n2 + (n2 >>> 8) + 1 >>> 8;
            if (!this.premultipliedAlpha) {
                return (n2 << 24) + (this.useColorRGB & 0xFFFFFF);
            }
            int n7 = this.useColorR * n2;
            n7 += (n7 >>> 8) + 1;
            int n8 = this.useColorG * n2;
            n8 += (n8 >>> 8) + 1;
            int n9 = this.useColorB * n2;
            n9 += (n9 >>> 8) + 1;
            return (n2 << 24) + ((n7 & 0xFF00) << 8) + (n8 & 0xFF00) + ((n9 & 0xFF00) >> 8);
        }
        if (n2 == 255) {
            n2 = this.useColorAlpha;
            n5 = this.useColorRp;
            n4 = this.useColorGp;
            n3 = this.useColorBp;
        } else {
            n2 *= this.useColorAlpha;
            n2 = n2 + (n2 >>> 8) + 1 >>> 8;
            n5 = this.useColorR * n2;
            n5 += (n5 >>> 8) + 1;
            n4 = this.useColorG * n2;
            n4 += (n4 >>> 8) + 1;
            n3 = this.useColorB * n2;
            n3 += (n3 >>> 8) + 1;
        }
        n6 *= 255 - n2;
        n6 = n6 + (n6 >>> 8) + 1 >>> 8;
        n2 += n6;
        int n10 = n >> 16 & 0xFF;
        n10 *= n6;
        n10 += (n10 >> 8) + 1 + n5;
        int n11 = n >> 8 & 0xFF;
        n11 *= n6;
        n11 += (n11 >> 8) + 1 + n4;
        int n12 = n & 0xFF;
        n12 *= n6;
        n12 += (n12 >> 8) + 1 + n3;
        if (!this.premultipliedAlpha && n2 != 255) {
            n10 = ((n10 << 8) - n10) / n2;
            n11 = ((n11 << 8) - n11) / n2;
            n12 = ((n12 << 8) - n12) / n2;
        }
        return (n2 << 24) + ((n10 & 0xFF00) << 8) + (n11 & 0xFF00) + ((n12 & 0xFF00) >> 8);
    }

    private ComplexPolygon roundRectPoly(int n, int n2, int n3, int n4, int n5, int n6) {
        FloatRect floatRect = new FloatRect(n += this.origin.x, n2 += this.origin.y, n + n3, n2 + n4);
        BezierPath bezierPath = new BezierPath(floatRect, (double)n5 * 0.5, (double)n6 * 0.5);
        return bezierPath.flattenBezierPath();
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.clip = this.imageRect.intersection(new Rectangle(n += this.origin.x, n2 += this.origin.y, n3, n4));
    }

    public void setClip(Shape shape) {
        this.setRectClip(shape.getBounds());
    }

    public void setColor(Color color) {
        if (color != null) {
            this.foreColor = color;
            this.foreColorRGB = this.foreColor.getRGB();
            this.setUseColor();
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPaintMode() {
        this.doXOR = false;
        this.setUseColor();
    }

    public final void setPixel(int n, int n2, int n3) {
        if ((n += this.origin.x) < this.clip.x || n >= this.clip.x + this.clip.width || (n2 += this.origin.y) < this.clip.y || n2 >= this.clip.y + this.clip.height || n3 == 0) {
            return;
        }
        int n4 = this.offset + n2 * this.scanSize + n;
        if (this.intPix != null) {
            if (this.doXOR) {
                int n5 = n4;
                this.intPix[n5] = this.intPix[n5] ^ this.useColorRGB;
            } else if (n3 != 0) {
                if (this.useColorAlpha == 255 && n3 == 255) {
                    this.intPix[n4] = this.useColorRGBp;
                } else {
                    int n6 = this.intPix[n4];
                    this.intPix[n4] = this.mergeColor(n6, n3);
                }
            }
        } else if (this.bytePix != null) {
            if (this.doXOR) {
                int n7 = n4;
                this.bytePix[n7] = (byte)(this.bytePix[n7] ^ (byte)this.useColorAlpha);
            } else if (n3 != 0) {
                if (this.useColorAlpha == 255 && n3 == 255) {
                    this.bytePix[n4] = (byte)this.useColorAlpha;
                } else {
                    byte by = this.bytePix[n4];
                    this.bytePix[n4] = this.mergeColor(by, n3);
                }
            }
        }
    }

    private void setRectClip(Rectangle rectangle) {
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void setUseColor() {
        this.useColorRGB = this.foreColorRGB;
        if (this.doXOR) {
            this.useColorRGB ^= this.xorColorRGB;
        }
        this.useColorRGBp = this.useColorRGB;
        this.useColorAlpha = this.useColorRGB >>> 24;
        this.useColorR = this.useColorRGB >>> 16 & 0xFF;
        this.useColorG = this.useColorRGB >>> 8 & 0xFF;
        this.useColorB = this.useColorRGB & 0xFF;
        if (this.useColorAlpha == 255) {
            this.useColorRp = this.useColorR << 8;
            this.useColorGp = this.useColorG << 8;
            this.useColorBp = this.useColorB << 8;
        }
        if (this.useColorAlpha != 255) {
            this.useColorRp *= this.useColorAlpha;
            this.useColorRp += (this.useColorRp >>> 8) + 1;
            this.useColorGp *= this.useColorAlpha;
            this.useColorGp += (this.useColorGp >>> 8) + 1;
            this.useColorBp *= this.useColorAlpha;
            this.useColorBp += (this.useColorBp >>> 8) + 1;
            if (this.premultipliedAlpha) {
                this.useColorRGBp = (this.useColorAlpha << 24) + (this.useColorRp << 8) + this.useColorGp + (this.useColorBp >> 8);
            }
        }
    }

    public void setXORMode(Color color) {
        if (color != null) {
            this.xorColorRGB = color.getRGB();
        }
        this.doXOR = true;
        this.setUseColor();
    }

    public void translate(int n, int n2) {
        this.origin.x += n;
        this.origin.y += n2;
    }

    class ImageProxy
    implements ImageConsumer {
        private volatile boolean imageDone = false;
        private Image image;
        private int xOrg;
        private int yOrg;
        private int width = -1;
        private int height = -1;
        private ImageObserver observer = null;
        private ImageProducer src = null;
        private boolean goodRGBModel = false;
        private boolean stitchBand = false;

        public ImageProxy(Image image, int n, int n2, ImageObserver imageObserver) {
            this.image = image;
            this.xOrg = n;
            this.yOrg = n2;
            this.observer = imageObserver;
        }

        protected boolean finished() {
            return this.imageDone;
        }

        public void imageComplete(int n) {
            int n2 = 0;
            switch (n) {
                case 2: {
                    n2 = 16;
                    break;
                }
                case 3: {
                    n2 = 32;
                    break;
                }
                case 1: {
                    n2 = 64;
                    break;
                }
                case 4: {
                    n2 = 128;
                    break;
                }
            }
            this.imageUpdate(n2, 0, 0, 0, 0);
        }

        private void imageUpdate(int n, int n2, int n3, int n4, int n5) {
            if (this.observer != null && n != 0 && !this.observer.imageUpdate(this.image, n, n2, n3, n4, n5)) {
                this.imageDone = true;
            }
            if ((n & 0xF0) != 0) {
                this.imageDone = true;
            }
            if (this.imageDone && this.src != null) {
                this.src.removeConsumer(this);
            }
        }

        public void setColorModel(ColorModel colorModel) {
            if (colorModel instanceof DirectColorModel) {
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                if (directColorModel.getAlphaMask() == -16777216 && directColorModel.getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255) {
                    this.goodRGBModel = true;
                }
            } else if (colorModel == DeviceRGBColorModel.DefaultColorModel) {
                this.goodRGBModel = true;
            }
        }

        public void setDimensions(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.imageUpdate(3, 0, 0, n, n2);
        }

        public void setHints(int n) {
            if ((n & 0x10000) != 0) {
                this.stitchBand = true;
            }
            this.imageUpdate(0, 0, 0, 0, 0);
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            Rectangle rectangle = ImageGraphics.this.clip.intersection(new Rectangle(n += this.xOrg, n2 += this.yOrg, n3, n4));
            int n7 = n5 + (rectangle.y - n2) * n6 + (rectangle.x - n);
            int n8 = ImageGraphics.this.offset + rectangle.y * ImageGraphics.this.scanSize + rectangle.x;
            if (ImageGraphics.this.bytePix != null) {
                int[] nArray = new int[256];
                int n9 = 0;
                while (n9 < 256) {
                    nArray[n9] = colorModel.getAlpha(n9);
                    ++n9;
                }
                n9 = 0;
                while (n9 < rectangle.height) {
                    int n10 = 0;
                    while (n10 < rectangle.width) {
                        int n11 = nArray[byArray[n7 + n10] & 0xFF];
                        int n12 = ImageGraphics.this.bytePix[n8 + n10] & 0xFF;
                        if (n11 == 255 || n12 == 0) {
                            ImageGraphics.this.bytePix[n8 + n10] = (byte)n11;
                        } else if (n11 != 0) {
                            int n13 = n12 * (255 - n11);
                            n13 += (n13 >> 8) + 1;
                            ImageGraphics.this.bytePix[n8 + n10] = (byte)(n11 + (n13 >>= 8));
                        }
                        ++n10;
                    }
                    n7 += n6;
                    n8 += ImageGraphics.this.scanSize;
                    ++n9;
                }
            } else if (ImageGraphics.this.intPix != null) {
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25;
                int[] nArray = new int[256];
                int n26 = 0;
                while (n26 < 256) {
                    nArray[n26] = colorModel.getRGB(n26);
                    ++n26;
                }
                if (n2 == this.yOrg && this.stitchBand) {
                    n25 = 0;
                    while (n25 < rectangle.width) {
                        n24 = nArray[byArray[n7 + n25] & 0xFF];
                        n23 = ImageGraphics.this.intPix[n8 + n25];
                        n22 = n24 >>> 24;
                        n21 = n23 >>> 24;
                        if (n22 == 255 && n21 == 255) {
                            n20 = (n24 >> 16 & 0xFF) + (n23 >> 16 & 0xFF) - 255;
                            if (n20 < 0) {
                                n20 = 0;
                            }
                            if ((n19 = (n24 >> 8 & 0xFF) + (n23 >> 8 & 0xFF) - 255) < 0) {
                                n19 = 0;
                            }
                            if ((n18 = (n24 & 0xFF) + (n23 & 0xFF) - 255) < 0) {
                                n18 = 0;
                            }
                            ImageGraphics.this.intPix[n8 + n25] = -16777216 + (n20 << 16) + (n19 << 8) + n18;
                        } else if (n22 == 255 || n21 == 0) {
                            if (ImageGraphics.this.premultipliedAlpha && n22 != 255) {
                                n20 = n22 * (n24 >> 16 & 0xFF);
                                n20 += (n20 >> 8) + 1;
                                n19 = n22 * (n24 >> 8 & 0xFF);
                                n19 += (n19 >> 8) + 1;
                                n18 = n22 * (n24 & 0xFF);
                                n18 += (n18 >> 8) + 1;
                                n24 = (n22 << 24) + ((n20 & 0xFF00) << 8) + (n19 & 0xFF00) + ((n18 & 0xFF00) >> 8);
                            }
                            ImageGraphics.this.intPix[n8 + n25] = n24;
                        } else if (n22 != 0) {
                            n20 = n22 * (n24 >> 16 & 0xFF);
                            n20 += (n20 >> 8) + 1;
                            n19 = n22 * (n24 >> 8 & 0xFF);
                            n19 += (n19 >> 8) + 1;
                            n18 = n22 * (n24 & 0xFF);
                            n18 += (n18 >> 8) + 1;
                            n17 = n21 * (255 - n22);
                            n17 += (n17 >> 8) + 1;
                            n17 >>= 8;
                            if (ImageGraphics.this.premultipliedAlpha) {
                                n16 = n17 * (n23 >> 8 & 0xFF00) / n21;
                                n15 = n17 * (n23 & 0xFF) / n21;
                                n14 = n17 * (n23 << 8 & 0xFF00) / n21;
                            } else {
                                n16 = n17 * (n23 >> 16 & 0xFF);
                                n16 += (n16 >> 8) + 1;
                                n15 = n17 * (n23 >> 8 & 0xFF);
                                n15 += (n15 >> 8) + 1;
                                n14 = n17 * (n23 & 0xFF);
                                n14 += (n14 >> 8) + 1;
                            }
                            n20 += n16;
                            n19 += n15;
                            n18 += n14;
                            if (!ImageGraphics.this.premultipliedAlpha && (n17 += n22) != 255) {
                                n20 = ((n20 << 8) - n20) / n17;
                                n19 = ((n19 << 8) - n19) / n17;
                                n18 = ((n18 << 8) - n18) / n17;
                            }
                            ImageGraphics.this.intPix[n8 + n25] = n24 = (n17 << 24) + ((n20 & 0xFF00) << 8) + (n19 & 0xFF00) + ((n18 & 0xFF00) >> 8);
                        }
                        ++n25;
                    }
                    n7 += n6;
                    n8 += ImageGraphics.this.scanSize;
                    --rectangle.height;
                }
                n26 = 0;
                while (n26 < rectangle.height) {
                    n25 = 0;
                    while (n25 < rectangle.width) {
                        n24 = nArray[byArray[n7 + n25] & 0xFF];
                        n23 = ImageGraphics.this.intPix[n8 + n25];
                        n22 = n24 >>> 24;
                        n21 = n23 >>> 24;
                        if (n22 == 255 || n21 == 0) {
                            if (ImageGraphics.this.premultipliedAlpha && n22 != 255) {
                                n20 = n22 * (n24 >> 16 & 0xFF);
                                n20 += (n20 >> 8) + 1;
                                n19 = n22 * (n24 >> 8 & 0xFF);
                                n19 += (n19 >> 8) + 1;
                                n18 = n22 * (n24 & 0xFF);
                                n18 += (n18 >> 8) + 1;
                                n24 = (n22 << 24) + ((n20 & 0xFF00) << 8) + (n19 & 0xFF00) + ((n18 & 0xFF00) >> 8);
                            }
                            ImageGraphics.this.intPix[n8 + n25] = n24;
                        } else if (n22 != 0) {
                            n20 = n22 * (n24 >> 16 & 0xFF);
                            n20 += (n20 >> 8) + 1;
                            n19 = n22 * (n24 >> 8 & 0xFF);
                            n19 += (n19 >> 8) + 1;
                            n18 = n22 * (n24 & 0xFF);
                            n18 += (n18 >> 8) + 1;
                            n17 = n21 * (255 - n22);
                            n17 += (n17 >> 8) + 1;
                            n17 >>= 8;
                            if (ImageGraphics.this.premultipliedAlpha) {
                                n16 = n17 * (n23 >> 8 & 0xFF00) / n21;
                                n15 = n17 * (n23 & 0xFF) / n21;
                                n14 = n17 * (n23 << 8 & 0xFF00) / n21;
                            } else {
                                n16 = n17 * (n23 >> 16 & 0xFF);
                                n16 += (n16 >> 8) + 1;
                                n15 = n17 * (n23 >> 8 & 0xFF);
                                n15 += (n15 >> 8) + 1;
                                n14 = n17 * (n23 & 0xFF);
                                n14 += (n14 >> 8) + 1;
                            }
                            n20 += n16;
                            n19 += n15;
                            n18 += n14;
                            if (!ImageGraphics.this.premultipliedAlpha && (n17 += n22) != 255) {
                                n20 = ((n20 << 8) - n20) / n17;
                                n19 = ((n19 << 8) - n19) / n17;
                                n18 = ((n18 << 8) - n18) / n17;
                            }
                            ImageGraphics.this.intPix[n8 + n25] = n24 = (n17 << 24) + ((n20 & 0xFF00) << 8) + (n19 & 0xFF00) + ((n18 & 0xFF00) >> 8);
                        }
                        ++n25;
                    }
                    n7 += n6;
                    n8 += ImageGraphics.this.scanSize;
                    ++n26;
                }
            }
            this.imageUpdate(8, n, n2, n3, n4);
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            Rectangle rectangle = ImageGraphics.this.clip.intersection(new Rectangle(n += this.xOrg, n2 += this.yOrg, n3, n4));
            int n7 = n5 + (rectangle.y - n2) * n6 + (rectangle.x - n);
            int n8 = ImageGraphics.this.offset + rectangle.y * ImageGraphics.this.scanSize + rectangle.x;
            if (ImageGraphics.this.bytePix != null) {
                int n9 = 0;
                while (n9 < rectangle.height) {
                    int n10 = 0;
                    while (n10 < rectangle.width) {
                        int n11 = colorModel.getAlpha(nArray[n7 + n10]);
                        int n12 = ImageGraphics.this.bytePix[n8 + n10] & 0xFF;
                        if (n11 == 255 || n12 == 0) {
                            ImageGraphics.this.bytePix[n8 + n10] = (byte)n11;
                        } else if (n11 != 0) {
                            int n13 = n12 * (255 - n11);
                            n13 += (n13 >> 8) + 1;
                            ImageGraphics.this.bytePix[n8 + n10] = (byte)(n11 + (n13 >>= 8));
                        }
                        ++n10;
                    }
                    n7 += n6;
                    n8 += ImageGraphics.this.scanSize;
                    ++n9;
                }
            } else if (ImageGraphics.this.intPix != null) {
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25;
                if (n2 == this.yOrg && this.stitchBand) {
                    n25 = 0;
                    while (n25 < rectangle.width) {
                        n24 = nArray[n7 + n25];
                        if (!this.goodRGBModel) {
                            n24 = colorModel.getRGB(n24);
                        }
                        n23 = ImageGraphics.this.intPix[n8 + n25];
                        n22 = n24 >>> 24;
                        n21 = n23 >>> 24;
                        if (n22 == 255 && n21 == 255) {
                            n20 = (n24 >> 16 & 0xFF) + (n23 >> 16 & 0xFF) - 255;
                            if (n20 < 0) {
                                n20 = 0;
                            }
                            if ((n19 = (n24 >> 8 & 0xFF) + (n23 >> 8 & 0xFF) - 255) < 0) {
                                n19 = 0;
                            }
                            if ((n18 = (n24 & 0xFF) + (n23 & 0xFF) - 255) < 0) {
                                n18 = 0;
                            }
                            ImageGraphics.this.intPix[n8 + n25] = -16777216 + (n20 << 16) + (n19 << 8) + n18;
                        } else if (n22 == 255 || n21 == 0) {
                            if (ImageGraphics.this.premultipliedAlpha && n22 != 255) {
                                n20 = n22 * (n24 >> 16 & 0xFF);
                                n20 += (n20 >> 8) + 1;
                                n19 = n22 * (n24 >> 8 & 0xFF);
                                n19 += (n19 >> 8) + 1;
                                n18 = n22 * (n24 & 0xFF);
                                n18 += (n18 >> 8) + 1;
                                n24 = (n22 << 24) + ((n20 & 0xFF00) << 8) + (n19 & 0xFF00) + ((n18 & 0xFF00) >> 8);
                            }
                            ImageGraphics.this.intPix[n8 + n25] = n24;
                        } else if (n22 != 0) {
                            n20 = n22 * (n24 >> 16 & 0xFF);
                            n20 += (n20 >> 8) + 1;
                            n19 = n22 * (n24 >> 8 & 0xFF);
                            n19 += (n19 >> 8) + 1;
                            n18 = n22 * (n24 & 0xFF);
                            n18 += (n18 >> 8) + 1;
                            n17 = n21 * (255 - n22);
                            n17 += (n17 >> 8) + 1;
                            n17 >>= 8;
                            if (ImageGraphics.this.premultipliedAlpha) {
                                n16 = n17 * (n23 >> 8 & 0xFF00) / n21;
                                n15 = n17 * (n23 & 0xFF) / n21;
                                n14 = n17 * (n23 << 8 & 0xFF00) / n21;
                            } else {
                                n16 = n17 * (n23 >> 16 & 0xFF);
                                n16 += (n16 >> 8) + 1;
                                n15 = n17 * (n23 >> 8 & 0xFF);
                                n15 += (n15 >> 8) + 1;
                                n14 = n17 * (n23 & 0xFF);
                                n14 += (n14 >> 8) + 1;
                            }
                            n20 += n16;
                            n19 += n15;
                            n18 += n14;
                            if (!ImageGraphics.this.premultipliedAlpha && (n17 += n22) != 255) {
                                n20 = ((n20 << 8) - n20) / n17;
                                n19 = ((n19 << 8) - n19) / n17;
                                n18 = ((n18 << 8) - n18) / n17;
                            }
                            ImageGraphics.this.intPix[n8 + n25] = n24 = (n17 << 24) + ((n20 & 0xFF00) << 8) + (n19 & 0xFF00) + ((n18 & 0xFF00) >> 8);
                        }
                        ++n25;
                    }
                    n7 += n6;
                    n8 += ImageGraphics.this.scanSize;
                    --rectangle.height;
                }
                int n26 = 0;
                while (n26 < rectangle.height) {
                    n25 = 0;
                    while (n25 < rectangle.width) {
                        n24 = nArray[n7 + n25];
                        if (!this.goodRGBModel) {
                            n24 = colorModel.getRGB(n24);
                        }
                        n23 = ImageGraphics.this.intPix[n8 + n25];
                        n22 = n24 >>> 24;
                        n21 = n23 >>> 24;
                        if (n22 == 255 || n21 == 0) {
                            if (ImageGraphics.this.premultipliedAlpha && n22 != 255) {
                                n20 = n22 * (n24 >> 16 & 0xFF);
                                n20 += (n20 >> 8) + 1;
                                n19 = n22 * (n24 >> 8 & 0xFF);
                                n19 += (n19 >> 8) + 1;
                                n18 = n22 * (n24 & 0xFF);
                                n18 += (n18 >> 8) + 1;
                                n24 = (n22 << 24) + ((n20 & 0xFF00) << 8) + (n19 & 0xFF00) + ((n18 & 0xFF00) >> 8);
                            }
                            ImageGraphics.this.intPix[n8 + n25] = n24;
                        } else if (n22 != 0) {
                            n20 = n22 * (n24 >> 16 & 0xFF);
                            n20 += (n20 >> 8) + 1;
                            n19 = n22 * (n24 >> 8 & 0xFF);
                            n19 += (n19 >> 8) + 1;
                            n18 = n22 * (n24 & 0xFF);
                            n18 += (n18 >> 8) + 1;
                            n17 = n21 * (255 - n22);
                            n17 += (n17 >> 8) + 1;
                            n17 >>= 8;
                            if (ImageGraphics.this.premultipliedAlpha) {
                                n16 = n17 * (n23 >> 8 & 0xFF00) / n21;
                                n15 = n17 * (n23 & 0xFF) / n21;
                                n14 = n17 * (n23 << 8 & 0xFF00) / n21;
                            } else {
                                n16 = n17 * (n23 >> 16 & 0xFF);
                                n16 += (n16 >> 8) + 1;
                                n15 = n17 * (n23 >> 8 & 0xFF);
                                n15 += (n15 >> 8) + 1;
                                n14 = n17 * (n23 & 0xFF);
                                n14 += (n14 >> 8) + 1;
                            }
                            n20 += n16;
                            n19 += n15;
                            n18 += n14;
                            if (!ImageGraphics.this.premultipliedAlpha && (n17 += n22) != 255) {
                                n20 = ((n20 << 8) - n20) / n17;
                                n19 = ((n19 << 8) - n19) / n17;
                                n18 = ((n18 << 8) - n18) / n17;
                            }
                            ImageGraphics.this.intPix[n8 + n25] = n24 = (n17 << 24) + ((n20 & 0xFF00) << 8) + (n19 & 0xFF00) + ((n18 & 0xFF00) >> 8);
                        }
                        ++n25;
                    }
                    n7 += n6;
                    n8 += ImageGraphics.this.scanSize;
                    ++n26;
                }
            }
            this.imageUpdate(8, n, n2, n3, n4);
        }

        public void setProperties(Hashtable hashtable) {
            this.imageUpdate(4, 0, 0, 0, 0);
        }

        protected void start() {
            if (!this.imageDone) {
                this.src = this.image.getSource();
                this.src.startProduction(this);
            }
        }
    }
}

