/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.ImageMaskColorModel;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.SmoothBitsImageFilter;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.ClipShape;
import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.ImageGraphics;
import com.adobe.acrobat.sidecar.PolygonADV;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.util.ImageMonitor;
import com.adobe.util.ImageUtil;
import com.adobe.util.MemUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;

public class GraphicsUtils {
    public static Image createClipImage(int n, int n2) {
        n = Math.max(n, 1);
        n2 = Math.max(n2, 1);
        byte[] byArray = MemUtil.allocByte(n * n2);
        ImageMaskColorModel imageMaskColorModel = new ImageMaskColorModel(9);
        return new SidecarImage(n, n2, (ColorModel)imageMaskColorModel, byArray, 0, n);
    }

    public static Image createImage(int n, int n2) {
        n = Math.max(n, 1);
        n2 = Math.max(n2, 1);
        int[] nArray = MemUtil.allocInt(n * n2);
        return new SidecarImage(n, n2, nArray, 0, n);
    }

    public static void drawImage(AWTGraphics aWTGraphics, Image image, AffineTransform affineTransform, ClipShape clipShape, boolean bl) {
        block9: {
            if (image == null || aWTGraphics == null) break block9;
            try {
                Object object;
                boolean bl2;
                Object object2;
                SidecarImage sidecarImage = GraphicsUtils.prepareImage(aWTGraphics, image, affineTransform, clipShape, bl);
                if (sidecarImage == null) {
                    return;
                }
                PDFColorModel pDFColorModel = sidecarImage.getColorModel();
                if (pDFColorModel != null && pDFColorModel instanceof ImageMaskColorModel && ((ColorValue)(object2 = pDFColorModel.getPaintColor())).paintIsComplex()) {
                    Rectangle rectangle = sidecarImage.getRect();
                    try {
                        if (affineTransform != null) {
                            SidecarImage sidecarImage2 = ((ColorValue)object2).patternImage(aWTGraphics.getInitialTransform(), rectangle);
                            sidecarImage2.mergeMask(sidecarImage);
                            sidecarImage.flush();
                            sidecarImage = sidecarImage2;
                        }
                    }
                    catch (Exception exception) {}
                }
                if (sidecarImage == null) break block9;
                object2 = aWTGraphics.getGraphics();
                boolean bl3 = object2 instanceof ImageGraphics;
                boolean bl4 = bl2 = !bl3 && sidecarImage.checkAntiAlias();
                if (bl2 && (object = aWTGraphics.getImage()) != null) {
                    Point point = aWTGraphics.getOrigin();
                    Rectangle rectangle = sidecarImage.getRect();
                    int[] nArray = MemUtil.allocInt(rectangle.width * rectangle.height);
                    Image image2 = GraphicsUtils.subImage((Image)object, rectangle.x + point.x, rectangle.y + point.y, rectangle.width, rectangle.height);
                    PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, rectangle.width, rectangle.height, nArray, 0, rectangle.width);
                    pixelGrabber.grabPixels();
                    image2.flush();
                    SidecarImage sidecarImage3 = new SidecarImage(rectangle.width, rectangle.height, nArray, 0, rectangle.width);
                    sidecarImage3.setOrigin(rectangle.x, rectangle.y);
                    sidecarImage3.applyImageMask(sidecarImage);
                    sidecarImage = sidecarImage3;
                }
                if (!sidecarImage.getRect().isEmpty()) {
                    object = sidecarImage.getOrigin();
                    GraphicsUtils.drawToNative((Graphics)object2, sidecarImage, ((Point)object).x, ((Point)object).y);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void drawPolygons(Graphics graphics, ComplexPolygon complexPolygon) {
        int n = complexPolygon.size();
        int n2 = 0;
        while (n2 < n) {
            PolygonADV polygonADV = (PolygonADV)complexPolygon.elementAt(n2);
            Polygon polygon = polygonADV.toPolygon();
            if (polygon.npoints > 2) {
                graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
            } else if (polygon.npoints == 2) {
                graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[1], polygon.ypoints[1]);
            } else if (polygon.npoints == 1) {
                graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[0], polygon.ypoints[0]);
            }
            ++n2;
        }
    }

    public static void drawToNative(Graphics graphics, Image image, int n, int n2) {
        if (image instanceof SidecarImage && !(graphics instanceof ImageGraphics)) {
            Object object;
            SidecarImage sidecarImage = (SidecarImage)image;
            Rectangle rectangle = graphics.getClipBounds();
            Rectangle rectangle2 = new Rectangle(n, n2, sidecarImage.getWidth(), sidecarImage.getHeight());
            if (rectangle != null) {
                rectangle2 = rectangle2.intersection(rectangle);
                object = sidecarImage.getOrigin();
                Rectangle rectangle3 = new Rectangle(rectangle2.x + ((Point)object).x - n, rectangle2.y + ((Point)object).y - n2, rectangle2.width, rectangle2.height);
                sidecarImage = sidecarImage.setRect(rectangle3);
            }
            if (!rectangle2.isEmpty()) {
                sidecarImage.sendJavaColorModel(true);
                image = ImageUtil.createImage(sidecarImage.getSource());
                object = new ImageMonitor(image);
                if (!graphics.drawImage(image, rectangle2.x, rectangle2.y, (ImageObserver)object)) {
                    ((ImageMonitor)object).waitForFrame();
                }
                image.flush();
                sidecarImage.sendJavaColorModel(false);
            }
        } else {
            ImageMonitor imageMonitor = new ImageMonitor(image);
            if (!graphics.drawImage(image, n, n2, imageMonitor)) {
                imageMonitor.waitForFrame();
            }
        }
    }

    public static void fillPolygons(Graphics graphics, ComplexPolygon complexPolygon) {
        int n = complexPolygon.size();
        int n2 = 0;
        while (n2 < n) {
            PolygonADV polygonADV = (PolygonADV)complexPolygon.elementAt(n2);
            Polygon polygon = polygonADV.toPolygon();
            graphics.fillPolygon(polygon);
            ++n2;
        }
    }

    private static SidecarImage prepareImage(AWTGraphics aWTGraphics, Image image, AffineTransform affineTransform, ClipShape clipShape, boolean bl) throws InterruptedException {
        Rectangle rectangle;
        Object object;
        Rectangle rectangle2;
        SidecarImage sidecarImage = null;
        SidecarImage sidecarImage2 = null;
        if (image instanceof SidecarImage) {
            sidecarImage2 = ((SidecarImage)image).getMaskImage();
            rectangle2 = ((SidecarImage)image).getRect();
            if (rectangle2.width < 0 || rectangle2.height < 0) {
                ((SidecarImage)image).startProduction(null);
                rectangle2 = ((SidecarImage)image).getRect();
            }
        } else {
            object = new ImageMonitor(image);
            rectangle2 = new Rectangle(0, 0, image.getWidth((ImageObserver)object), image.getHeight((ImageObserver)object));
            object = null;
        }
        if (rectangle2.width < 0 || rectangle2.height < 0) {
            return null;
        }
        if (affineTransform != null) {
            rectangle2.y = 0;
            rectangle2.x = 0;
            double d = affineTransform.geta();
            double d2 = affineTransform.getb();
            double d3 = affineTransform.getc();
            double d4 = affineTransform.getd();
            double d5 = affineTransform.getx();
            double d6 = affineTransform.gety();
            double d7 = d + d3;
            double d8 = d2 + d4;
            double d9 = d5;
            double d10 = d6;
            double d11 = d7;
            double d12 = d8;
            if (d7 > 0.0) {
                d9 = Math.floor(d5);
                d11 = Math.ceil(d5 + d7 - d9);
            } else if (d7 < 0.0) {
                d9 = Math.ceil(d5);
                d11 = Math.floor(d5 + d7 - d9);
            }
            if (d8 > 0.0) {
                d10 = Math.floor(d6);
                d12 = Math.ceil(d6 + d8 - d10);
            } else if (d8 < 0.0) {
                d10 = Math.ceil(d6);
                d12 = Math.floor(d6 + d8 - d10);
            }
            if (d7 != 0.0) {
                d7 = d11 / d7;
                d *= d7;
                d3 *= d7;
            }
            if (d8 != 0.0) {
                d8 = d12 / d8;
                d2 *= d8;
                d4 *= d8;
            }
            affineTransform = new AffineTransform(d, d2, d3, d4, d9, d10);
            object = new FloatRect(0.0, 0.0, 1.0, 1.0).transformRect(affineTransform);
            rectangle = ((FloatRect)object).toRect();
        } else {
            object = new FloatRect(rectangle2);
            rectangle = rectangle2;
        }
        ImageProducer imageProducer = image.getSource();
        Rectangle rectangle3 = aWTGraphics.getClipBounds().intersection(rectangle);
        if (clipShape != null) {
            Rectangle rectangle4 = clipShape.getClipBounds();
            if (rectangle4 == null) {
                return null;
            }
            if ((rectangle3 = rectangle3.intersection(rectangle4)).isEmpty()) {
                return null;
            }
        }
        AffineTransform affineTransform2 = affineTransform;
        boolean bl2 = false;
        boolean bl3 = false;
        if (affineTransform != null) {
            affineTransform2 = new AffineTransform(1.0 / (double)rectangle2.width, 0.0, 0.0, -1.0 / (double)rectangle2.height, 0.0, 1.0);
            affineTransform2 = affineTransform2.appendTransform(affineTransform);
            double d = affineTransform2.geta();
            double d13 = affineTransform2.getb();
            double d14 = affineTransform2.getc();
            double d15 = affineTransform2.getd();
            double d16 = Math.sqrt(d * d + d13 * d13);
            double d17 = Math.sqrt(d14 * d14 + d15 * d15);
            bl2 = d13 != 0.0 || d14 != 0.0 || d < 0.0 || d15 < 0.0;
            int n = Math.max(1, (int)Math.round((double)rectangle2.width * d16));
            int n2 = Math.max(1, (int)Math.round((double)rectangle2.height * d17));
            boolean bl4 = n < rectangle2.width || n2 < rectangle2.height;
            boolean bl5 = bl3 = n > rectangle2.width || n2 > rectangle2.height;
            if (bl4) {
                rectangle2.width = Math.min(rectangle2.width, n);
                rectangle2.height = Math.min(rectangle2.height, n2);
                SmoothBitsImageFilter smoothBitsImageFilter = new SmoothBitsImageFilter(rectangle2.width, rectangle2.height, bl);
                imageProducer = new FilteredImageSource(imageProducer, smoothBitsImageFilter);
                affineTransform2 = new AffineTransform(1.0 / (double)rectangle2.width, 0.0, 0.0, -1.0 / (double)rectangle2.height, 0.0, 1.0);
                affineTransform2 = affineTransform2.preTranslate(-rectangle2.x, -rectangle2.y);
                affineTransform2 = affineTransform2.appendTransform(affineTransform);
            }
        }
        sidecarImage = image instanceof SidecarImage && image == imageProducer ? (SidecarImage)((SidecarImage)image).clone() : new SidecarImage(imageProducer);
        sidecarImage.startProduction(null);
        sidecarImage.setOrigin(rectangle2.x, rectangle2.y);
        image.flush();
        if (sidecarImage.getStatus(null) != 3 && sidecarImage.getStatus(null) != 2) {
            return null;
        }
        if (affineTransform2 != null && (bl2 || bl3)) {
            try {
                sidecarImage = sidecarImage.Rotate(rectangle3, affineTransform2, bl);
            }
            catch (AffineException affineException) {}
        } else {
            sidecarImage.setOrigin(rectangle.x, rectangle.y);
            sidecarImage = sidecarImage.setRect(rectangle3);
        }
        if (clipShape != null && !clipShape.isRectangular()) {
            SidecarImage sidecarImage3 = clipShape.getClipImage();
            SidecarImage sidecarImage4 = sidecarImage.Resample(sidecarImage3, bl);
            sidecarImage3.flush();
            sidecarImage.flush();
            sidecarImage = sidecarImage4;
        }
        if (sidecarImage2 != null) {
            sidecarImage2 = GraphicsUtils.prepareImage(aWTGraphics, sidecarImage2, affineTransform, clipShape, bl);
            sidecarImage.mergeMask(sidecarImage2);
            sidecarImage2.flush();
        }
        return sidecarImage;
    }

    public static Image subImage(Image image, int n, int n2, int n3, int n4) {
        ImageMonitor imageMonitor;
        if (image instanceof SidecarImage) {
            ImageMonitor imageMonitor2;
            Image image2 = GraphicsUtils.createImage(n3, n4);
            Graphics graphics = image2.getGraphics();
            if (!graphics.drawImage(image, -n, -n2, imageMonitor2 = new ImageMonitor(image))) {
                imageMonitor2.waitForFrame();
            }
            graphics.dispose();
            return image2;
        }
        Image image3 = ImageUtil.createImage(n3, n4);
        Graphics graphics = image3.getGraphics();
        if (!graphics.drawImage(image, -n, -n2, imageMonitor = new ImageMonitor(image))) {
            imageMonitor.waitForFrame();
        }
        graphics.dispose();
        return image3;
    }
}

