/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.GraphicsUtils;
import com.adobe.acrobat.sidecar.MultiPath;
import com.adobe.acrobat.sidecar.PolygonADV;
import com.adobe.acrobat.sidecar.Region;
import com.adobe.acrobat.sidecar.SidecarImage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class ClipShape
implements Cloneable {
    private SidecarImage fClipImg = null;
    private MultiPath fMultiPath = new MultiPath();
    private FloatRect fClipRect = null;
    private SidecarImage fClipImgShadow = null;

    private ClipShape() {
    }

    public ClipShape(FloatRect floatRect, Region region) {
        this();
        this.setClip(floatRect);
        this.setClip(region);
    }

    public ClipShape(Region region) {
        this();
        this.setClip(region);
    }

    public ClipShape(Rectangle rectangle, Region region) {
        this();
        this.setClip(rectangle);
        this.setClip(region);
    }

    public Object clone() {
        ClipShape clipShape = new ClipShape();
        clipShape.fClipRect = this.fClipRect;
        if (this.fMultiPath != null) {
            clipShape.fMultiPath = (MultiPath)this.fMultiPath.clone();
        }
        if (this.fClipImg != null) {
            clipShape.fClipImg = (SidecarImage)this.fClipImg.clone();
        }
        if (this.fClipImgShadow != null) {
            clipShape.fClipImgShadow = (SidecarImage)this.fClipImgShadow.clone();
        }
        return clipShape;
    }

    public void fillClipPath(AWTGraphics aWTGraphics, boolean bl) {
        Graphics graphics = aWTGraphics.getGraphics();
        Rectangle rectangle = this.getClipBounds();
        if (this.isRectangular()) {
            if (rectangle == null) {
                return;
            }
            if (!rectangle.isEmpty()) {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else if (this.fClipImg == null) {
            this.fMultiPath.addPath(this.fClipRect);
            this.fMultiPath.fillPath(graphics, bl);
        } else if (this.fMultiPath.isNull()) {
            SidecarImage sidecarImage = this.fClipImg.setRect(rectangle);
            sidecarImage.setPaintColor(aWTGraphics.getFillColor());
            aWTGraphics.drawImage(sidecarImage, null, false);
        } else {
            Image image = GraphicsUtils.createClipImage(rectangle.width, rectangle.height);
            Graphics graphics2 = image.getGraphics();
            try {
                graphics2.setColor(Color.white);
                graphics2.translate(-rectangle.x, -rectangle.y);
                this.fMultiPath.fillPath(graphics2, bl);
            }
            finally {
                Object var8_8 = null;
                graphics2.dispose();
            }
            SidecarImage sidecarImage = (SidecarImage)image;
            sidecarImage.setOrigin(rectangle.x, rectangle.y);
            try {
                this.fClipImg = this.fClipImg.Resample8(sidecarImage);
                this.fClipImg.setPaintColor(aWTGraphics.getFillColor());
                aWTGraphics.drawImage(this.fClipImg, null, false);
            }
            catch (InterruptedException interruptedException) {}
            this.fMultiPath.reset();
        }
    }

    public Rectangle getClipBounds() {
        Rectangle rectangle = null;
        rectangle = this.fClipRect != null ? this.fClipRect.toEnclosingRect() : new Rectangle(-1073741823, -1073741823, Integer.MAX_VALUE, Integer.MAX_VALUE);
        return rectangle;
    }

    public SidecarImage getClipImage() {
        if (this.fClipImg != null) {
            return this.fClipImg;
        }
        if (this.fClipImgShadow == null) {
            Rectangle rectangle = this.getClipBounds();
            if (rectangle.isEmpty()) {
                return null;
            }
            AWTGraphics aWTGraphics = new AWTGraphics(rectangle.width, rectangle.height);
            try {
                Graphics graphics = aWTGraphics.getGraphics();
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, rectangle.width, rectangle.height);
                graphics.setColor(Color.white);
                graphics.translate(-rectangle.x, -rectangle.y);
                this.fillClipPath(aWTGraphics, true);
            }
            finally {
                Object var4_4 = null;
                aWTGraphics.dispose();
            }
            this.fClipImgShadow = SidecarImage.clipFromImage(aWTGraphics.getImage());
            this.fClipImgShadow.setOrigin(rectangle.x, rectangle.y);
        }
        return this.fClipImgShadow;
    }

    public FloatRect getFloatClipBounds() {
        if (this.fClipRect != null) {
            return this.fClipRect;
        }
        return FloatRect.getFullRect();
    }

    public boolean isRectangular() {
        return this.fClipImg == null && this.fMultiPath.isNull();
    }

    public boolean rectVisible(FloatRect floatRect) {
        boolean bl = true;
        if (this.fClipRect != null) {
            bl = this.fClipRect.overlap(floatRect);
        }
        return bl;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        if (n3 >= 0 && n4 >= 0) {
            this.setClip(new FloatRect(n, n2, n + n3, n2 + n4));
        }
    }

    public void setClip(ClipShape clipShape) {
        if (clipShape != null && clipShape != this) {
            this.setClip(clipShape.fClipRect);
            this.setClip(clipShape.fMultiPath);
            this.setClip(clipShape.fClipImg);
        }
    }

    public void setClip(ComplexPolygon complexPolygon, int n) {
        if (complexPolygon != null) {
            this.setClip(complexPolygon.getBoundingBox());
            if (this.fClipRect.isEmpty() || complexPolygon.isRectangular()) {
                return;
            }
            this.fMultiPath.addPath(complexPolygon, n);
        }
    }

    public void setClip(FloatRect floatRect) {
        if (floatRect != null) {
            this.fClipRect = this.fClipRect == null ? floatRect : this.fClipRect.intersect(floatRect);
            if (this.fClipRect.isReallyEmpty()) {
                this.fClipImg = null;
                this.fMultiPath.reset();
            }
            this.fClipImgShadow = null;
        }
    }

    public void setClip(MultiPath multiPath) {
        if (multiPath != null && multiPath != this.fMultiPath) {
            this.setClip(multiPath.getBoundingBox());
            if (this.fClipRect.isEmpty()) {
                return;
            }
            this.fMultiPath.addPath(multiPath);
        }
    }

    public void setClip(PolygonADV polygonADV, int n) {
        if (polygonADV != null) {
            this.setClip(polygonADV.getBoundingBox());
            if (this.fClipRect.isEmpty() || polygonADV.isRectangular()) {
                return;
            }
            this.fMultiPath.addPath(polygonADV, n);
        }
    }

    public void setClip(Region region) {
        if (region != null) {
            this.setClip(region.getPolys(), 1);
        }
    }

    public void setClip(SidecarImage sidecarImage) {
        block4: {
            if (sidecarImage == null || sidecarImage == this.fClipImg) break block4;
            this.setClip(sidecarImage.getRect());
            if (this.fClipRect.isEmpty()) {
                return;
            }
            try {
                if (this.fClipImg == null) {
                    this.fClipImg = (SidecarImage)sidecarImage.clone();
                    break block4;
                }
                this.fClipImg = this.fClipImg.Resample8(sidecarImage);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setClip(Rectangle rectangle) {
        if (rectangle != null && rectangle.width >= 0 && rectangle.height >= 0) {
            this.setClip(new FloatRect(rectangle));
        }
    }

    public void setPathClip(ComplexPolygon complexPolygon) {
        int n = 0;
        while (n < complexPolygon.size()) {
            PolygonADV polygonADV = (PolygonADV)complexPolygon.elementAt(n);
            if (polygonADV != null) {
                int n2 = polygonADV.npoints - 1;
                while (n2-- > 0) {
                    polygonADV.addPoint(polygonADV.xpoints[n2], polygonADV.ypoints[n2]);
                }
            }
            ++n;
        }
        this.setClip(complexPolygon, 1);
    }
}

