/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.pdfobjstore.DictEntryNFExc;
import com.adobe.acrobat.pdfobjstore.PDFContainer;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.pe.notify.Requester;
import com.adobe.util.Assert;
import java.util.Enumeration;

public class PDFDict
extends PDFContainer {
    String[] keys;
    PDFObj[] vals;
    ByteArray ba;
    int baOffset;

    public PDFDict(PDFDict pDFDict, String string, PDFObj pDFObj) {
        Assert.notFalse(pDFObj instanceof PDFContainer ^ true);
        boolean bl = pDFDict.hasKey(string);
        int n = bl ? pDFDict.keys.length : pDFDict.keys.length + 1;
        this.keys = new String[n];
        this.vals = new PDFObj[n];
        int n2 = 0;
        while (n2 < n) {
            if (n2 == n - 1 && !bl) {
                this.keys[n2] = string;
                this.vals[n2] = pDFObj;
            } else {
                this.keys[n2] = pDFDict.keys[n2];
                this.vals[n2] = pDFDict.keys[n2].equals(string) ? pDFObj : pDFDict.vals[n2];
            }
            ++n2;
        }
        this.ba = pDFDict.ba;
        this.baOffset = pDFDict.baOffset;
    }

    public PDFDict(PDFDict pDFDict, String[] stringArray, PDFObj[] pDFObjArray, boolean bl, ByteArray byteArray, int n) {
        int n2;
        int n3 = pDFDict.keys.length;
        int n4 = 0;
        while (n4 < stringArray.length) {
            int n5 = n2 = pDFObjArray[n4] != null ? 0 : 1;
            if (pDFDict.hasKey(stringArray[n4])) {
                if (n2 != 0) {
                    --n3;
                }
            } else if (n2 == 0) {
                ++n3;
            }
            ++n4;
        }
        this.keys = new String[n3];
        n2 = n3;
        this.vals = new PDFObj[n3];
        int n6 = 0;
        while (n6 < stringArray.length) {
            if (pDFObjArray[n6] != null && !pDFDict.hasKey(stringArray[n6])) {
                this.keys[--n2] = stringArray[n6];
                this.vals[n2] = pDFObjArray[n6];
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < pDFDict.keys.length) {
            boolean bl2 = false;
            int n8 = 0;
            while (n8 < stringArray.length) {
                if (pDFDict.keys[n7].equals(stringArray[n8])) {
                    bl2 = true;
                    if (pDFObjArray[n8] == null) break;
                    this.keys[--n2] = stringArray[n8];
                    this.vals[n2] = pDFObjArray[n8];
                    break;
                }
                ++n8;
            }
            if (!bl2) {
                this.keys[--n2] = pDFDict.keys[n7];
                this.vals[n2] = pDFDict.vals[n7];
            }
            ++n7;
        }
        Assert.notFalse(n2 == 0);
        if (bl) {
            this.ba = byteArray;
            this.baOffset = n;
        } else {
            this.ba = pDFDict.ba;
            this.baOffset = pDFDict.baOffset;
        }
    }

    public PDFDict(String[] stringArray, PDFObj[] pDFObjArray) {
        this(stringArray, pDFObjArray, null, -1);
    }

    PDFDict(String[] stringArray, PDFObj[] pDFObjArray, ByteArray byteArray, int n) {
        this.keys = stringArray;
        this.vals = pDFObjArray;
        this.ba = byteArray;
        this.baOffset = n;
    }

    public boolean contains(PDFObj pDFObj) {
        return this.indexOfValue(pDFObj) != -1;
    }

    public PDFDict dictValue(Requester requester) {
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PDFDict)) {
            return false;
        }
        PDFDict pDFDict = (PDFDict)object;
        if (pDFDict.keys.length != this.keys.length) {
            return false;
        }
        int n = this.keys.length;
        while (n-- > 0) {
            int n2 = pDFDict.indexOfKey(this.keys[n]);
            if (n2 == -1) {
                return false;
            }
            if (this.vals[n].equals(pDFDict.vals[n2])) continue;
            return false;
        }
        return true;
    }

    public PDFObj get(String string) throws DictEntryNFExc {
        int n = this.indexOfKey(string);
        if (n == -1) {
            throw new DictEntryNFExc(string);
        }
        return this.vals[n];
    }

    ByteArray getByteArray() {
        return this.ba;
    }

    int getByteArrayOffset() {
        return this.baOffset;
    }

    public boolean hasAnyKey(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            if (!this.hasKey(stringArray[n])) continue;
            return true;
        }
        return false;
    }

    public boolean hasKey(String string) {
        return this.indexOfKey(string) != -1;
    }

    public int hashCode() {
        throw new RuntimeException("PDFDict.hashCode() not yet implemented!");
    }

    private int indexOfKey(String string) {
        int n = this.keys.length;
        while (n-- > 0) {
            if (!this.keys[n].equals(string)) continue;
            return n;
        }
        return -1;
    }

    private int indexOfValue(PDFObj pDFObj) {
        int n = this.vals.length;
        while (n-- > 0) {
            if (!this.vals[n].equals(pDFObj)) continue;
            return n;
        }
        return -1;
    }

    public String keyOf(PDFObj pDFObj) {
        int n = this.indexOfValue(pDFObj);
        return n == -1 ? null : this.keys[n];
    }

    public Enumeration keys() {
        return new PDFDictEnumeration();
    }

    public String nthKey(int n) {
        return this.keys[n];
    }

    public PDFObj nthValue(int n) {
        return this.vals[n];
    }

    PDFDict put(String string, PDFObj pDFObj) {
        int n;
        int n2 = this.indexOfKey(string);
        if (n2 == -1) {
            n2 = this.keys.length;
            n = this.keys.length + 1;
        } else {
            n = this.keys.length;
        }
        String[] stringArray = new String[n];
        PDFObj[] pDFObjArray = new PDFObj[n];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.vals, 0, pDFObjArray, 0, this.vals.length);
        stringArray[n2] = string;
        pDFObjArray[n2] = pDFObj;
        return new PDFDict(stringArray, pDFObjArray);
    }

    public int size() {
        return this.keys.length;
    }

    public String toString() {
        String string = "<<\r";
        int n = 0;
        while (n < this.keys.length) {
            try {
                string = String.valueOf(string) + "\t" + this.keys[n] + " " + this.vals[n].toString() + "\r";
            }
            catch (Exception exception) {
                string = String.valueOf(string) + "\t" + this.keys[n] + " " + exception.toString() + "\r";
            }
            ++n;
        }
        string = String.valueOf(string) + ">>";
        return string;
    }

    public int type(Requester requester) {
        return 6;
    }

    class PDFDictEnumeration
    implements Enumeration {
        int i = 0;
        String[] keys;

        PDFDictEnumeration() {
            this.keys = PDFDict.this.keys;
        }

        public boolean hasMoreElements() {
            while (this.i < this.keys.length && this.keys[this.i] == null) {
                ++this.i;
            }
            return this.i < this.keys.length;
        }

        public Object nextElement() {
            String string = null;
            if (this.hasMoreElements()) {
                string = this.keys[this.i++];
            }
            return string;
        }
    }
}

