/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import com.adobe.util.MemUtil;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class ImageMaskColorModel
extends PDFColorModel {
    private byte[] alpha;
    private boolean isOrdered;
    private ColorValue paintColor;
    private ColorModel javaColorModel;

    public ImageMaskColorModel() {
        this(new PDFColorParams(7));
    }

    public ImageMaskColorModel(int n) {
        this(new PDFColorParams(n));
    }

    public ImageMaskColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams);
        float f;
        float f2;
        float[] fArray = pDFColorParams.getDecode();
        this.alpha = MemUtil.allocByte(256);
        if (fArray != null && fArray.length >= 2) {
            f2 = fArray[0];
            f = fArray[1] - fArray[0];
        } else {
            f2 = 0.0f;
            f = 1.0f;
        }
        f2 *= 255.0f;
        this.isOrdered = true;
        int n = 0;
        while (n < 256) {
            this.alpha[n] = (byte)(255 - Math.max(0, Math.min(255, Math.round(f2 + (float)n * f))));
            if ((this.alpha[n] & 0xFF) != n) {
                this.isOrdered = false;
            }
            ++n;
        }
        this.setPaintColor(ColorValue.black);
    }

    public boolean canBlend() {
        return true;
    }

    public int getAlpha(int n) {
        return this.alpha[n & 0xFF] & 0xFF;
    }

    public PDFColorModel getBlendModel() {
        ImageMaskColorModel imageMaskColorModel = new ImageMaskColorModel(9);
        ((PDFColorModel)imageMaskColorModel).setPaintColor(this.paintColor);
        return imageMaskColorModel;
    }

    public int getBlue(int n) {
        return this.paintColor.getBlue();
    }

    public int getGreen(int n) {
        return this.paintColor.getGreen();
    }

    public ColorModel getJavaColorModel() {
        if (this.javaColorModel == null) {
            if (this.paintColor == null) {
                this.paintColor = ColorValue.black;
            }
            byte[] byArray = MemUtil.allocByte(256);
            byte[] byArray2 = MemUtil.allocByte(256);
            byte[] byArray3 = MemUtil.allocByte(256);
            int n = this.paintColor.getRGB();
            byte by = (byte)(n >>> 16);
            byte by2 = (byte)(n >>> 8);
            byte by3 = (byte)n;
            int n2 = 0;
            while (n2 < 256) {
                byArray[n2] = by;
                byArray2[n2] = by2;
                byArray3[n2] = by3;
                ++n2;
            }
            this.javaColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3, this.alpha);
        }
        return this.javaColorModel;
    }

    public ColorValue getPaintColor() {
        return this.paintColor;
    }

    public int getRGB() {
        return -16777216 + (this.paintColor.getRGB() & 0xFFFFFF);
    }

    public int getRGB(int n) {
        return ((this.alpha[n & 0xFF] & 0xFF) << 24) + (this.paintColor.getRGB() & 0xFFFFFF);
    }

    public int getRGB(float[] fArray) {
        if (fArray.length >= 1) {
            return this.getRGB(fArray[0]);
        }
        throw new RuntimeException("ImageMaskColorModel.getRGB(c[]) -- arrayToShort");
    }

    public int getRed(int n) {
        return this.paintColor.getRed();
    }

    public boolean setPaintColor(ColorValue colorValue) {
        boolean bl = colorValue.equals(this.paintColor) ^ true;
        if (bl) {
            this.paintColor = colorValue;
            this.javaColorModel = null;
        }
        return bl;
    }

    public void toBlend(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (!this.isOrdered) {
            while (n3-- > 0) {
                byArray2[n2++] = this.alpha[byArray[n++] & 0xFF];
            }
        } else if (byArray != byArray2 || n != n2) {
            System.arraycopy(byArray, n, byArray2, n2, n3);
        }
    }

    public String toString() {
        return "ImageMask";
    }
}

