/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.Function;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.Shading;
import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.util.MemUtil;
import java.awt.Rectangle;

public class BlendShading
extends Shading {
    protected float[] coords;
    protected float[] domain;
    protected boolean[] extend;
    protected AffineTransform matrix;
    protected Function[] funcs;

    public BlendShading(int n, PDFColorModel pDFColorModel, float[] fArray, FloatRect floatRect, boolean bl, float[] fArray2, AffineTransform affineTransform, Function[] functionArray) {
        super(n, pDFColorModel, fArray, floatRect, bl);
        this.coords = null;
        this.domain = fArray2;
        this.matrix = affineTransform;
        this.funcs = functionArray;
        this.extend = null;
    }

    public BlendShading(int n, PDFColorModel pDFColorModel, float[] fArray, FloatRect floatRect, boolean bl, float[] fArray2, float[] fArray3, Function[] functionArray, boolean[] blArray) {
        super(n, pDFColorModel, fArray, floatRect, bl);
        this.coords = fArray2;
        this.domain = fArray3;
        this.matrix = null;
        this.funcs = functionArray;
        this.extend = blArray;
    }

    private int getFuncColor(double d) {
        int n;
        int n2 = this.colorModel.getNumComponents();
        float[] fArray = new float[n2];
        if (this.funcs != null) {
            if (this.funcs.length == 1) {
                n = this.colorModel.getRGB(this.funcs[0].value(d));
            } else {
                int n3 = 0;
                while (n3 < n2) {
                    fArray[n3] = this.funcs[n3].value(d)[0];
                    ++n3;
                }
                n = this.colorModel.getRGB(fArray);
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                fArray[n4] = (float)d;
                ++n4;
            }
            n = this.colorModel.getRGB(fArray);
        }
        return n;
    }

    public SidecarImage shadingImage(AffineTransform affineTransform, Rectangle rectangle) {
        int[] nArray;
        int n;
        int n2;
        block59: {
            int n3;
            n2 = Math.max(0, rectangle.height);
            n = Math.max(0, rectangle.width);
            int n4 = n * n2;
            nArray = MemUtil.allocInt(n4);
            if (n4 > 0) {
                int n5;
                double d;
                int n6 = this.colorModel.getNumComponents();
                float[] fArray = new float[n6];
                if (this.background != null) {
                    int n7 = this.colorModel.getRGB(this.background);
                    MemUtil.arraySet(nArray, new Integer(n7));
                }
                AffineTransform affineTransform2 = affineTransform;
                int[] nArray2 = null;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                double d12 = 1.0;
                double d13 = 1.0;
                double d14 = 0.0;
                double d15 = 0.0;
                double d16 = 256.0;
                double d17 = 256.0;
                switch (this.subtype) {
                    case 1: {
                        if (this.domain != null) {
                            d11 = this.domain[0];
                            d13 = this.domain[1];
                            d10 = this.domain[2];
                            d12 = this.domain[3];
                        } else {
                            d10 = 0.0;
                            d11 = 0.0;
                            d12 = 1.0;
                            d13 = 1.0;
                        }
                        if (this.matrix == null) break;
                        affineTransform2 = this.matrix.appendTransform(affineTransform2);
                        break;
                    }
                    case 2: {
                        d9 = this.coords[0];
                        d8 = this.coords[1];
                        d7 = (double)this.coords[2] - d9;
                        d6 = (double)this.coords[3] - d8;
                        AffineTransform affineTransform3 = new AffineTransform(d7 / 256.0, d6 / 256.0, -d6 / 256.0, d7 / 256.0, d9, d8);
                        affineTransform2 = affineTransform3.appendTransform(affineTransform2);
                        if (this.extend == null) break;
                        if (this.extend[0]) {
                            d14 = Double.NEGATIVE_INFINITY;
                        }
                        if (!this.extend[1]) break;
                        d16 = Double.POSITIVE_INFINITY;
                        break;
                    }
                    case 3: {
                        AffineTransform affineTransform3;
                        d9 = this.coords[0];
                        d8 = this.coords[1];
                        d7 = (double)this.coords[3] - d9;
                        d6 = (double)this.coords[4] - d8;
                        d5 = Math.abs(this.coords[2]);
                        d4 = Math.abs(this.coords[5]);
                        if (d7 == 0.0 && d6 == 0.0) {
                            d2 = 0.0;
                            affineTransform3 = new AffineTransform(1.0, 0.0, 0.0, 1.0, d9, d8);
                            affineTransform2 = affineTransform3.appendTransform(affineTransform2);
                        } else {
                            d2 = Math.sqrt(d7 * d7 + d6 * d6);
                            affineTransform3 = new AffineTransform(d7 / d2, d6 / d2, -d6 / d2, d7 / d2, d9, d8);
                            affineTransform2 = affineTransform3.appendTransform(affineTransform2);
                        }
                        d3 = d4 - d5;
                        if (this.extend == null) break;
                        if (this.extend[0]) {
                            d14 = d5 < d4 ? -256.0 * d5 / d3 : Double.NEGATIVE_INFINITY;
                        }
                        if (!this.extend[1]) break;
                        if (d5 > d4) {
                            d16 = 256.0 - 256.0 * d4 / d3;
                            break;
                        }
                        d16 = Double.POSITIVE_INFINITY;
                        break;
                    }
                }
                if (this.subtype == 2 || this.subtype == 3) {
                    double d18 = 0.0;
                    d = 1.0;
                    if (this.domain != null) {
                        d18 = this.domain[0];
                        d = this.domain[1];
                    }
                    d -= d18;
                    nArray2 = new int[257];
                    n3 = 0;
                    while (n3 < 256) {
                        float f = (float)(d18 + (double)n3 * d / 255.0);
                        if (this.funcs != null) {
                            if (this.funcs.length == 1) {
                                nArray2[n3] = this.colorModel.getRGB(this.funcs[0].value(f));
                            } else {
                                n5 = 0;
                                while (n5 < n6) {
                                    fArray[n5] = this.funcs[n5].value(f)[0];
                                    ++n5;
                                }
                                nArray2[n3] = this.colorModel.getRGB(fArray);
                            }
                        } else {
                            n5 = 0;
                            while (n5 < n6) {
                                fArray[n5] = f;
                                ++n5;
                            }
                            nArray2[n3] = this.colorModel.getRGB(fArray);
                        }
                        ++n3;
                    }
                    nArray2[256] = nArray2[255];
                }
                try {
                    affineTransform2 = affineTransform2.getInverse();
                    double d19 = affineTransform2.geta();
                    d = affineTransform2.getb();
                    double d20 = affineTransform2.getc();
                    double d21 = affineTransform2.getd();
                    double d22 = affineTransform2.getx();
                    double d23 = affineTransform2.gety();
                    double d24 = rectangle.x;
                    double d25 = rectangle.y;
                    double d26 = d19 * d24 + d20 * d25 + d22;
                    double d27 = d * d24 + d21 * d25 + d23;
                    int n8 = 0;
                    switch (this.subtype) {
                        case 1: {
                            int n9;
                            n3 = 0;
                            while (n3 < n2) {
                                n9 = 0;
                                while (n9 < n) {
                                    if (d26 >= d11 && d26 <= d13 && d27 >= d10 && d27 <= d12) {
                                        if (this.funcs != null) {
                                            if (this.funcs.length == 1) {
                                                n5 = this.colorModel.getRGB(this.funcs[0].value(d26, d27));
                                            } else {
                                                n5 = 0;
                                                while (n5 < n6) {
                                                    fArray[n5] = this.funcs[n5].value(d26, d27)[0];
                                                    ++n5;
                                                }
                                                n5 = this.colorModel.getRGB(fArray);
                                            }
                                        } else {
                                            n5 = this.colorModel.getRGB((float)d26, (float)d27);
                                        }
                                        nArray[n8] = n5;
                                    }
                                    ++n8;
                                    d26 += d19;
                                    d27 += d;
                                    ++n9;
                                }
                                d26 += d20 - (double)n * d19;
                                d27 += d21 - (double)n * d;
                                ++n3;
                            }
                            break;
                        }
                        case 2: {
                            int n9;
                            n3 = 0;
                            while (n3 < n2) {
                                n9 = 0;
                                while (n9 < n) {
                                    if (d26 <= d16 && d26 >= d14) {
                                        n5 = (int)d26;
                                        if (n5 < 0) {
                                            n5 = 0;
                                        } else if (n5 > 256) {
                                            n5 = 256;
                                        }
                                        nArray[n8] = nArray2[n5];
                                    }
                                    ++n8;
                                    d26 += d19;
                                    ++n9;
                                }
                                d26 += d20 - (double)n * d19;
                                ++n3;
                            }
                            break;
                        }
                        case 3: {
                            int n9;
                            double d28 = (d2 /= 256.0) * d2 - (d3 /= 256.0) * d3;
                            double d29 = 4.0 * d28;
                            double d30 = 1.0 / (2.0 * d28);
                            double d31 = d5 * d3;
                            double d32 = d5 * d5;
                            n3 = 0;
                            while (n3 < n2) {
                                n9 = 0;
                                while (n9 < n) {
                                    double d33 = -2.0 * (d26 * d2 + d31);
                                    double d34 = d26 * d26 + d27 * d27 - d32;
                                    double d35 = d33 * d33 - d29 * d34;
                                    if (d35 >= 0.0) {
                                        double d36;
                                        d35 = Math.sqrt(d35);
                                        if (d30 > 0.0) {
                                            d36 = (-d33 + d35) * d30;
                                            if (d36 > d16) {
                                                d36 = (-d33 - d35) * d30;
                                            }
                                        } else {
                                            d36 = (-d33 - d35) * d30;
                                            if (d36 > d16) {
                                                d36 = (-d33 + d35) * d30;
                                            }
                                        }
                                        if (d36 <= d16 && d36 >= d14) {
                                            n5 = (int)d36;
                                            if (n5 < 0) {
                                                n5 = 0;
                                            } else if (n5 > 256) {
                                                n5 = 256;
                                            }
                                            nArray[n8] = nArray2[n5];
                                        }
                                    }
                                    ++n8;
                                    d26 += d19;
                                    d27 += d;
                                    ++n9;
                                }
                                d26 += d20 - (double)n * d19;
                                d27 += d21 - (double)n * d;
                                ++n3;
                            }
                            break;
                        }
                        default: {
                            if (this.funcs == null) break block59;
                        }
                    }
                }
                catch (AffineException affineException) {}
            }
            if (this.funcs == null) break block59;
            n3 = this.funcs.length;
            while (n3-- > 0) {
                this.funcs[n3].flush();
            }
        }
        SidecarImage sidecarImage = new SidecarImage(n, n2, nArray, 0, n);
        sidecarImage.setOrigin(rectangle.x, rectangle.y);
        return sidecarImage;
    }
}

