/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.ConjoinedStreamFactory;
import com.adobe.acrobat.pdf.EmptyInputStreamFactory;
import com.adobe.acrobat.pdf.VContentsStreamFactoryForVRef;
import com.adobe.acrobat.pdf.VContentsStreamFactoryProvider;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.util.StreamFactory;
import com.adobe.pe.vtypes.VStreamFactory;

public class VContentsStreamFactory
extends VStreamFactory {
    static final String VContentsStreamFactory_K = "VContentsStreamFactory";
    private static VContentsStreamFactoryProvider provider = null;
    private static final String Contents_K = "Contents";
    private PDFReference pageRef;

    VContentsStreamFactory(PDFReference pDFReference) {
        this.pageRef = pDFReference;
    }

    protected StreamFactory computeStreamFactory(Requester requester) throws Exception {
        PDFDict pDFDict = this.pageRef.resolve(requester).dictValue(requester);
        if (pDFDict.hasKey(Contents_K)) {
            PDFObj pDFObj = pDFDict.get(Contents_K);
            if (pDFObj.type(requester) == 7) {
                PDFArray pDFArray = pDFObj.arrayValue(requester);
                ConjoinedStreamFactory conjoinedStreamFactory = new ConjoinedStreamFactory(pDFArray.size());
                int n = 0;
                while (n < pDFArray.size()) {
                    PDFReference pDFReference = pDFArray.get(n).pdfReferenceValue(requester);
                    StreamFactory streamFactory = pDFReference.getFilteredVStreamFactory().streamFactoryValue(requester);
                    conjoinedStreamFactory.setFactory(n, streamFactory);
                    ++n;
                }
                return conjoinedStreamFactory;
            }
            return pDFObj.pdfReferenceValue(requester).getFilteredVStreamFactory().streamFactoryValue(requester);
        }
        return new EmptyInputStreamFactory();
    }

    public static VStreamFactory getVContentsStreamFactory(PDFReference pDFReference) throws Exception {
        VContentsStreamFactory.initProvider();
        VStreamFactory vStreamFactory = (VStreamFactory)pDFReference.getExtensionData(VContentsStreamFactory_K);
        return vStreamFactory;
    }

    public static VStreamFactory getVContentsStreamFactory(VPDFReference vPDFReference) {
        return new VContentsStreamFactoryForVRef(vPDFReference);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new VContentsStreamFactoryProvider();
            Extension.registerProvider(VContentsStreamFactory_K, provider);
        }
    }
}

