/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.filters.BitfieldInputStream;
import com.adobe.acrobat.pdf.PSCalculatorExecuter;
import com.adobe.acrobat.pdf.PSCalculatorStack;
import com.adobe.util.MemUtil;
import java.io.InputStream;
import java.util.Hashtable;

public class Function
implements Cloneable {
    public static final int SAMPLED = 0;
    public static final int EXPONENTIAL = 2;
    public static final int STITCHED1 = 3;
    public static final int PSCALCULATOR = 4;
    public static final int Identity_I = -1;
    static Hashtable predefinedKeys = new Hashtable(37);
    int functionType;
    int mDomain;
    float[] domain;
    float[] encode;
    float[] encodeScale;
    int[] size;
    int[] sizeN;
    int mRange;
    float[] range;
    float[] decode;
    float[] decodeScale;
    float[] expC0;
    float[] expC1;
    float exponent;
    float[] bounds;
    Function[] functions;
    int nFunc;
    int bitsPerSample;
    int tableSize;
    int order;
    Object table;
    PSCalculatorExecuter psExec;
    PSCalculatorStack psStack;

    static {
        predefinedKeys.put("Identity", new Integer(-1));
    }

    public Function(String string) {
        this.functionType = predefinedKeys.contains(string) ? (Integer)predefinedKeys.get(string) : -1;
    }

    public Function(float[] fArray, float[] fArray2, InputStream inputStream) throws Exception {
        this.functionType = 4;
        this.domain = fArray;
        this.mDomain = this.domain.length / 2;
        this.range = fArray2;
        this.mRange = this.range.length / 2;
        this.psExec = new PSCalculatorExecuter();
        this.psExec.compile(inputStream);
        this.psStack = null;
    }

    public Function(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float f) {
        int n;
        this.functionType = 2;
        this.domain = fArray;
        this.mDomain = this.domain.length / 2;
        this.exponent = f;
        this.range = fArray2;
        this.mRange = this.range != null ? this.range.length / 2 : (fArray3 != null ? fArray3.length : (fArray4 != null ? fArray4.length : this.mDomain));
        if (fArray3 == null) {
            fArray3 = new float[this.mRange];
            n = 0;
            while (n < this.mRange) {
                fArray3[n] = 0.0f;
                ++n;
            }
        }
        this.expC0 = fArray3;
        if (fArray4 == null) {
            fArray4 = new float[this.mRange];
            n = 0;
            while (n < this.mRange) {
                fArray4[n] = 1.0f;
                ++n;
            }
        }
        this.expC1 = fArray4;
        n = 0;
        while (n < this.mRange) {
            int n2 = n;
            this.expC1[n2] = this.expC1[n2] - this.expC0[n];
            ++n;
        }
    }

    public Function(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, int n, int n2, InputStream inputStream) throws Exception {
        this.functionType = 0;
        this.domain = fArray;
        this.mDomain = this.domain.length / 2;
        this.mRange = 1;
        this.size = new int[this.mDomain];
        int n3 = 0;
        while (n3 < this.mDomain) {
            this.size[n3] = (int)fArray3[n3];
            ++n3;
        }
        if (fArray2 != null) {
            this.encode = fArray2;
        } else {
            this.encode = new float[2 * this.mDomain];
            n3 = 0;
            while (n3 < this.mDomain) {
                this.encode[2 * n3] = 0.0f;
                this.encode[2 * n3 + 1] = this.size[n3] - 1;
                ++n3;
            }
        }
        this.encodeScale = new float[this.mDomain];
        n3 = 0;
        while (n3 < this.mDomain) {
            this.encodeScale[n3] = this.encode[2 * n3 + 1] - this.encode[2 * n3];
            if (this.encodeScale[n3] != 0.0f) {
                int n4 = n3;
                this.encodeScale[n4] = this.encodeScale[n4] / (this.domain[2 * n3 + 1] - this.domain[2 * n3]);
            }
            ++n3;
        }
        this.range = fArray4;
        this.mRange = this.range.length / 2;
        if (fArray5 != null) {
            this.decode = fArray5;
        } else {
            this.decode = new float[2 * this.mRange];
            System.arraycopy(this.range, 0, this.decode, 0, 2 * this.mRange);
        }
        this.decodeScale = new float[this.mRange];
        float f = (1L << n) - 1L;
        n3 = 0;
        while (n3 < this.mRange) {
            this.decodeScale[n3] = (this.decode[2 * n3 + 1] - this.decode[2 * n3]) / f;
            ++n3;
        }
        this.bitsPerSample = n;
        this.order = n2;
        this.sizeN = new int[this.mDomain];
        this.sizeN[0] = this.mRange;
        n3 = 1;
        while (n3 < this.mDomain) {
            this.sizeN[n3] = this.sizeN[n3 - 1] * this.size[n3 - 1];
            ++n3;
        }
        this.tableSize = this.sizeN[this.mDomain - 1] * this.size[this.mDomain - 1];
        BitfieldInputStream bitfieldInputStream = new BitfieldInputStream(inputStream);
        if (n <= 8) {
            byte[] byArray = MemUtil.allocByte(this.tableSize);
            n3 = 0;
            while (n3 < this.tableSize) {
                byArray[n3] = (byte)bitfieldInputStream.read(n);
                ++n3;
            }
            this.table = byArray;
        } else {
            int[] nArray = MemUtil.allocInt(this.tableSize);
            n3 = 0;
            while (n3 < this.tableSize) {
                nArray[n3] = (int)bitfieldInputStream.read(n);
                ++n3;
            }
            this.table = nArray;
        }
    }

    public Function(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, Function[] functionArray) {
        this.functionType = 3;
        this.domain = fArray;
        this.encode = fArray4;
        this.functions = functionArray;
        this.mDomain = 1;
        this.range = fArray2;
        this.mRange = this.range != null ? this.range.length / 2 : functionArray[0].getRangeSize();
        this.nFunc = functionArray.length;
        this.bounds = new float[this.nFunc + 1];
        this.bounds[0] = this.domain[0];
        int n = 1;
        while (n < this.nFunc) {
            this.bounds[n] = fArray3[n - 1];
            ++n;
        }
        this.bounds[n] = this.domain[1];
        this.encodeScale = new float[this.nFunc];
        n = 0;
        while (n < this.nFunc) {
            this.encodeScale[n] = (this.encode[2 * n + 1] - this.encode[2 * n]) / (this.bounds[n + 1] - this.bounds[n]);
            ++n;
        }
    }

    public void flush() {
        this.psStack = null;
    }

    public int getDomainSize() {
        return this.mDomain;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public int getRangeSize() {
        return this.mRange;
    }

    private float[] interpolate1(float[] fArray, float[] fArray2, float f) {
        int n = 0;
        while (n < this.mRange) {
            int n2 = n;
            fArray[n2] = fArray[n2] + (fArray2[n] - fArray[n]) * f;
            ++n;
        }
        return fArray;
    }

    private float[] interpolate2(float[] fArray, float[] fArray2, float[] fArray3, float f) {
        int n = 0;
        while (n < this.mRange) {
            float f2 = fArray[n];
            float f3 = fArray2[n];
            float f4 = fArray3[n];
            float f5 = (f4 + f2) / 2.0f - f3;
            float f6 = (f4 - f2) / 2.0f;
            fArray[n] = f * (f * f5 + f6) + f3;
            ++n;
        }
        return fArray;
    }

    private float[] interpolate3(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float f) {
        int n = 0;
        while (n < this.mRange) {
            float f2 = fArray[n];
            float f3 = fArray2[n];
            float f4 = fArray3[n];
            float f5 = fArray4[n];
            float f6 = f5 + f2;
            float f7 = f5 - f2;
            float f8 = f4 + f3;
            float f9 = f4 - f3;
            float f10 = (f7 - 3.0f * f9) / 8.0f;
            float f11 = (f6 - f8) / 4.0f;
            float f12 = -(f7 - 27.0f * f9) / 24.0f;
            float f13 = -(f6 - 9.0f * f8) / 16.0f;
            fArray[n] = f * (f * (f * f10 + f11) + f12) + f13;
            ++n;
        }
        return fArray;
    }

    public static boolean isPredefined(String string) {
        return predefinedKeys.contains(string);
    }

    private float[] lookup0(float[] fArray, int n) {
        if (n >= this.mDomain) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.mDomain) {
                n2 += (int)fArray[n3] * this.sizeN[n3];
                ++n3;
            }
            float[] fArray2 = new float[this.mRange];
            if (this.table instanceof byte[]) {
                byte[] byArray = (byte[])this.table;
                n3 = 0;
                while (n3 < this.mRange) {
                    fArray2[n3] = byArray[n2++] & 0xFF;
                    ++n3;
                }
            } else if (this.table instanceof int[]) {
                int[] nArray = (int[])this.table;
                if (this.bitsPerSample < 32) {
                    n3 = 0;
                    while (n3 < this.mRange) {
                        fArray2[n3] = nArray[n2++];
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < this.mRange) {
                        fArray2[n3] = (long)nArray[n2++] & 0xFFFFFFFFL;
                        ++n3;
                    }
                }
            }
            return fArray2;
        }
        int n4 = (int)fArray[n];
        float f = fArray[n] - (float)n4;
        if (fArray[n] == (float)n4) {
            return this.lookup0(fArray, n + 1);
        }
        if (this.order == 1 || this.size[n] == 2) {
            float[] fArray3 = new float[this.mDomain];
            System.arraycopy(fArray, 0, fArray3, 0, this.mDomain);
            fArray3[n] = n4;
            float[] fArray4 = this.lookup0(fArray3, n + 1);
            fArray3[n] = n4 + 1;
            float[] fArray5 = this.lookup0(fArray3, n + 1);
            return this.interpolate1(fArray4, fArray5, f);
        }
        if (this.size[n] == 3) {
            float[] fArray6 = new float[this.mDomain];
            System.arraycopy(fArray, 0, fArray6, 0, this.mDomain);
            f += (float)(n4 - 1);
            fArray6[n] = 0.0f;
            float[] fArray7 = this.lookup0(fArray6, n + 1);
            fArray6[n] = 1.0f;
            float[] fArray8 = this.lookup0(fArray6, n + 1);
            fArray6[n] = 2.0f;
            float[] fArray9 = this.lookup0(fArray6, n + 1);
            return this.interpolate2(fArray7, fArray8, fArray9, f);
        }
        float[] fArray10 = new float[this.mDomain];
        System.arraycopy(fArray, 0, fArray10, 0, this.mDomain);
        f = (float)((double)f - 0.5);
        if (n4 == 0) {
            f -= 1.0f;
            n4 = 1;
        } else if (n4 + 2 >= this.size[n]) {
            f += (float)(n4 - (this.size[n] - 3));
            n4 = this.size[n] - 3;
        }
        fArray10[n] = n4 - 1;
        float[] fArray11 = this.lookup0(fArray10, n + 1);
        fArray10[n] = n4;
        float[] fArray12 = this.lookup0(fArray10, n + 1);
        fArray10[n] = n4 + 1;
        float[] fArray13 = this.lookup0(fArray10, n + 1);
        fArray10[n] = n4 + 2;
        float[] fArray14 = this.lookup0(fArray10, n + 1);
        return this.interpolate3(fArray11, fArray12, fArray13, fArray14, f);
    }

    public float[] value(double d) {
        float[] fArray = new float[]{(float)d};
        return this.value(fArray);
    }

    public float[] value(double d, double d2) {
        float[] fArray = new float[]{(float)d, (float)d2};
        return this.value(fArray);
    }

    /*
     * Unable to fully structure code
     */
    public float[] value(float[] var1_1) {
        switch (this.functionType) {
            case -1: {
                return var1_1;
            }
            case 0: {
                var4_2 = new float[this.mDomain];
                var2_7 = 0;
                while (var2_7 < this.mDomain) {
                    var3_13 = var2_7 + var2_7;
                    var4_2[var2_7] = Math.min((float)(this.size[var2_7] - 1), Math.max(0.0f, (var1_1[var2_7] - this.domain[var3_13]) * this.encodeScale[var2_7] + this.encode[var3_13]));
                    ++var2_7;
                }
                var4_2 = this.lookup0(var4_2, 0);
                var2_7 = 0;
                while (var2_7 < this.mRange) {
                    var3_13 = var2_7 + var2_7;
                    var4_2[var2_7] = Math.min(this.range[var3_13 + 1], Math.max(this.range[var3_13], var4_2[var2_7] * this.decodeScale[var2_7] + this.decode[var3_13]));
                    ++var2_7;
                }
                return var4_2;
            }
            case 2: {
                var4_3 = new float[this.mRange];
                var5_18 = Math.min(this.domain[1], Math.max(this.domain[0], var1_1[0]));
                var5_18 = Math.pow(var5_18, this.exponent);
                var2_8 = 0;
                while (var2_8 < this.mRange) {
                    var3_14 = var2_8 + var2_8;
                    var7_20 = (float)((double)this.expC0[var2_8] + var5_18 * (double)this.expC1[var2_8]);
                    if (this.range != null) {
                        var7_20 = Math.min(this.range[var3_14 + 1], Math.max(this.range[var3_14], var7_20));
                    }
                    var4_3[var2_8] = var7_20;
                    ++var2_8;
                }
                return var4_3;
            }
            case 3: {
                var4_4 = var1_1;
                var5_19 = Math.min(this.domain[1], Math.max(this.domain[0], var1_1[0]));
                var2_9 = 0;
                while (var2_9 < this.nFunc) {
                    if (var5_19 <= this.bounds[var2_9 + 1]) {
                        var3_15 = var2_9 + var2_9;
                        var5_19 = (var5_19 - this.bounds[var2_9]) * this.encodeScale[var2_9] + this.encode[var3_15];
                        var4_4 = this.functions[var2_9].value(var5_19);
                        if (this.range == null) break;
                        var2_9 = 0;
                        while (var2_9 < this.mRange) {
                            var3_15 = var2_9 + var2_9;
                            var4_4[var2_9] = Math.min(this.range[var3_15 + 1], Math.max(this.range[var3_15], var4_4[var2_9]));
                            ++var2_9;
                        }
                        break;
                    }
                    ++var2_9;
                }
                return var4_4;
            }
            case 4: {
                if (this.psStack == null) {
                    this.psStack = new PSCalculatorStack();
                }
                this.psStack.reset();
                var4_5 = new float[this.mRange];
                try {
                    var2_10 = 0;
                    while (var2_10 < this.mDomain) {
                        var3_16 = var2_10 + var2_10;
                        this.psStack.push();
                        this.psStack.setNumberValue(Math.min(this.domain[var3_16 + 1], Math.max(this.domain[var3_16], var1_1[var2_10])));
                        ++var2_10;
                    }
                    this.psExec.compute(this.psStack);
                    if (this.psStack.stackSize() != this.mRange) {
                        throw new Exception();
                    }
                    var2_10 = 0;
                    while (var2_10 < this.mRange) {
                        var3_16 = var2_10 + var2_10;
                        var4_5[var2_10] = Math.min(this.range[var3_16 + 1], Math.max(this.range[var3_16], (float)this.psStack.getNumberValue(1 - this.mRange + var2_10)));
                        ++var2_10;
                    }
                    ** GOTO lbl84
                }
                catch (Exception v0) {
                    var2_11 = 0;
                    ** while (var2_11 < this.mRange)
                }
lbl-1000:
                // 1 sources

                {
                    var3_17 = var2_11 + var2_11;
                    var4_5[var2_11] = this.range[var3_17];
                    ++var2_11;
                    continue;
                }
lbl84:
                // 2 sources

                return var4_5;
            }
        }
        var4_6 = new float[this.mRange];
        var2_12 = 0;
        while (var2_12 < this.mRange) {
            var4_6[var2_12] = NaNf;
            ++var2_12;
        }
        return var4_6;
    }
}

