/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.ContentOperator;
import com.adobe.acrobat.page.ContentParser;
import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.Pattern;
import com.adobe.acrobat.pdf.VPDFColorModel;
import com.adobe.acrobat.pdf.VPattern;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.UnexpectedTypeException;
import com.adobe.pe.notify.Requester;

class Funct_SetColor
extends ContentOperator {
    public static final int rg = 1;
    public static final int RG = 2;
    public static final int k = 3;
    public static final int K = 4;
    public static final int g = 5;
    public static final int G = 6;
    public static final int cs = 7;
    public static final int CS = 8;
    public static final int sc = 9;
    public static final int SC = 10;
    public static final int scn = 11;
    public static final int SCN = 12;
    public static final int ri = 13;
    int myType;
    boolean isStrokeColor;
    boolean isFillColor;
    private static final String Page_K = "Page";
    private static final String DeviceRGB_K = "DeviceRGB";
    private static final String DeviceCMYK_K = "DeviceCMYK";
    private static final String DeviceGray_K = "DeviceGray";

    public Funct_SetColor(int n) {
        this.myType = n;
        this.isFillColor = false;
        this.isStrokeColor = false;
        switch (this.myType) {
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                this.isStrokeColor = true;
                break;
            }
            default: {
                this.isFillColor = true;
            }
        }
    }

    private ColorValue makeColor(ContentParser contentParser, PDFColorModel pDFColorModel) throws UnexpectedTypeException {
        int n = pDFColorModel.getNumComponents();
        float[] fArray = new float[n];
        int n2 = n;
        while (n2-- > 0) {
            fArray[n2] = (float)contentParser.popDouble();
        }
        return new ColorValue(pDFColorModel, fArray);
    }

    private ColorValue makeColor(Pattern pattern, ContentParser contentParser, PDFColorModel pDFColorModel) throws UnexpectedTypeException {
        float[] fArray = null;
        if (pattern.isUncolored()) {
            int n = pDFColorModel.getNumComponents();
            fArray = new float[n];
            int n2 = n;
            while (n2-- > 0) {
                fArray[n2] = (float)contentParser.popDouble();
            }
        }
        return new ColorValue(pattern, pDFColorModel, fArray);
    }

    public void setUp(Requester requester, ContentParser contentParser) throws Exception {
        PDFReference pDFReference = contentParser.getResources();
        try {
            switch (this.myType) {
                case 1: 
                case 2: {
                    PDFColorModel pDFColorModel = VPDFColorModel.getVPDFColorModel(DeviceRGB_K, pDFReference).colorModel(requester);
                    ColorValue colorValue = this.makeColor(contentParser, pDFColorModel);
                    if (this.isFillColor) {
                        contentParser.setGState(contentParser.getGState().setFillColor(colorValue));
                    } else {
                        contentParser.setGState(contentParser.getGState().setStrokeColor(colorValue));
                    }
                    break;
                }
                case 3: 
                case 4: {
                    PDFColorModel pDFColorModel = VPDFColorModel.getVPDFColorModel(DeviceCMYK_K, pDFReference).colorModel(requester);
                    ColorValue colorValue = this.makeColor(contentParser, pDFColorModel);
                    if (this.isFillColor) {
                        contentParser.setGState(contentParser.getGState().setFillColor(colorValue));
                    } else {
                        contentParser.setGState(contentParser.getGState().setStrokeColor(colorValue));
                    }
                    break;
                }
                case 5: 
                case 6: {
                    PDFColorModel pDFColorModel = VPDFColorModel.getVPDFColorModel(DeviceGray_K, pDFReference).colorModel(requester);
                    ColorValue colorValue = this.makeColor(contentParser, pDFColorModel);
                    if (this.isFillColor) {
                        contentParser.setGState(contentParser.getGState().setFillColor(colorValue));
                    } else {
                        contentParser.setGState(contentParser.getGState().setStrokeColor(colorValue));
                    }
                    break;
                }
                case 7: 
                case 8: {
                    PDFColorModel pDFColorModel = VPDFColorModel.getVPDFColorModel(contentParser.popName(), pDFReference).colorModel(requester);
                    ColorValue colorValue = new ColorValue(pDFColorModel, pDFColorModel.getBlack());
                    if (this.isFillColor) {
                        contentParser.setGState(contentParser.getGState().setFillColor(colorValue));
                    } else {
                        contentParser.setGState(contentParser.getGState().setStrokeColor(colorValue));
                    }
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    ColorValue colorValue;
                    ColorValue colorValue2 = null;
                    PDFColorModel pDFColorModel = null;
                    colorValue2 = this.isFillColor ? contentParser.getGState().getFillColor() : contentParser.getGState().getStrokeColor();
                    pDFColorModel = colorValue2.colormodel;
                    if (pDFColorModel == null) {
                        pDFColorModel = VPDFColorModel.getVPDFColorModel(DeviceGray_K, pDFReference).colorModel(requester);
                    }
                    int n = pDFColorModel.getNumComponents();
                    boolean bl = false;
                    if (pDFColorModel.getPDFColorSpace() == 21) {
                        Pattern pattern = VPattern.getVPattern(contentParser.popName(), pDFReference).patternValue(requester);
                        colorValue = this.makeColor(pattern, contentParser, pDFColorModel);
                    } else {
                        colorValue = this.makeColor(contentParser, pDFColorModel);
                    }
                    if (this.isFillColor) {
                        contentParser.setGState(contentParser.getGState().setFillColor(colorValue));
                    } else {
                        contentParser.setGState(contentParser.getGState().setStrokeColor(colorValue));
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }
}

