/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.ContentInspectorFriend;
import com.adobe.acrobat.page.DrawContext;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.ClipShape;
import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.FloatRect;

public class ContentXObjectForm
extends Content
implements ContentInspectorFriend {
    private ContentArray contentArray;
    private FloatRect bbox;
    private AffineTransform matrix;
    private FloatRect userBBox;

    public ContentXObjectForm(GState gState, ContentArray contentArray, AffineTransform affineTransform, FloatRect floatRect, int n, int n2) throws Exception {
        super(gState, n, n2);
        this.contentArray = contentArray;
        this.bbox = floatRect;
        this.matrix = affineTransform;
        this.userBBox = floatRect.transformRect(gState.getCTM());
    }

    public void draw(DrawContext drawContext) throws Exception {
        AffineTransform affineTransform = this.matrix.appendTransform(this.gState.getCTM()).appendTransform(drawContext.transform);
        BezierPath bezierPath = new BezierPath(this.bbox);
        bezierPath = bezierPath.transform(affineTransform);
        ComplexPolygon complexPolygon = bezierPath.flattenBezierPath();
        ClipShape clipShape = new ClipShape(null);
        clipShape.setClip(drawContext.clip);
        clipShape.setClip(complexPolygon, 1);
        drawContext.awtg.flushText();
        AWTGraphics aWTGraphics = new AWTGraphics(drawContext.awtg);
        DrawContext drawContext2 = new DrawContext(aWTGraphics, affineTransform, clipShape);
        this.contentArray.draw(drawContext2);
        aWTGraphics.dispose();
    }

    public FloatRect getBoundingBox() {
        return this.userBBox;
    }

    public String getShortDescription() {
        return "Form";
    }
}

