/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.ContentInspectorFriend;
import com.adobe.acrobat.page.DrawContext;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.FloatRect;

class ContentPainting
extends Content
implements ContentInspectorFriend {
    private FloatRect bbox = null;
    private BezierPath bz;
    private byte myType;

    public ContentPainting(BezierPath bezierPath, byte by, GState gState, int n, int n2) {
        super(gState, n, n2);
        this.bz = bezierPath;
        this.myType = by;
    }

    public void draw(DrawContext drawContext) throws Exception {
        switch (this.myType) {
            case 1: {
                this.drawPath(drawContext.awtg, this.bz);
                break;
            }
            case 2: {
                this.drawPath(drawContext.awtg, this.bz);
                break;
            }
            case 3: {
                this.fillPath(drawContext.awtg, this.bz);
                break;
            }
            case 5: {
                this.evenFillPath(drawContext.awtg, this.bz);
                break;
            }
            case 6: {
                this.fillStrokePath(drawContext.awtg, this.bz);
                break;
            }
            case 7: {
                this.fillStrokePath(drawContext.awtg, this.bz);
                break;
            }
            case 8: {
                this.evenFillStrokePath(drawContext.awtg, this.bz);
                break;
            }
            case 9: {
                this.evenFillStrokePath(drawContext.awtg, this.bz);
                break;
            }
        }
    }

    private void drawPath(AWTGraphics aWTGraphics, BezierPath bezierPath) {
        aWTGraphics.setPath(bezierPath);
        aWTGraphics.setStrokeColor(this.gState.getStrokeColor());
        aWTGraphics.drawPath();
        aWTGraphics.setPath(null);
    }

    private void evenFillPath(AWTGraphics aWTGraphics, BezierPath bezierPath) {
        bezierPath.setEvenOdd();
        aWTGraphics.setPath(bezierPath);
        aWTGraphics.setFillColor(this.gState.getFillColor());
        aWTGraphics.fillPath();
        aWTGraphics.setPath(null);
    }

    private void evenFillStrokePath(AWTGraphics aWTGraphics, BezierPath bezierPath) {
        bezierPath.setEvenOdd();
        aWTGraphics.setPath(bezierPath);
        aWTGraphics.setFillColor(this.gState.getFillColor());
        aWTGraphics.fillPath();
        aWTGraphics.setStrokeColor(this.gState.getStrokeColor());
        aWTGraphics.drawPath();
        aWTGraphics.setPath(null);
    }

    private void fillPath(AWTGraphics aWTGraphics, BezierPath bezierPath) {
        bezierPath.setWinding();
        aWTGraphics.setPath(bezierPath);
        aWTGraphics.setFillColor(this.gState.getFillColor());
        aWTGraphics.fillPath();
        aWTGraphics.setPath(null);
    }

    private void fillStrokePath(AWTGraphics aWTGraphics, BezierPath bezierPath) {
        bezierPath.setWinding();
        aWTGraphics.setPath(bezierPath);
        aWTGraphics.setFillColor(this.gState.getFillColor());
        aWTGraphics.fillPath();
        aWTGraphics.setStrokeColor(this.gState.getStrokeColor());
        aWTGraphics.drawPath();
        aWTGraphics.setPath(null);
    }

    public synchronized FloatRect getBoundingBox() {
        if (this.bbox == null) {
            this.bbox = this.bz.getBoundingBox();
            switch (this.myType) {
                case 1: 
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    double d = this.gState.getLineWidth() / 2.0;
                    this.bbox = this.bbox.grow(d, d);
                }
            }
            this.bbox = this.bbox.transformRect(this.gState.getCTM());
        }
        return this.bbox;
    }

    public String getShortDescription() {
        switch (this.myType) {
            case 1: {
                return "close and stroke Path";
            }
            case 2: {
                return "stroke Path";
            }
            case 3: {
                return "fill Path";
            }
            case 5: {
                return "EO fill Path";
            }
            case 6: {
                return "fill and stroke Path";
            }
            case 7: {
                return "close, fill and stroke Path";
            }
            case 8: {
                return "EO fill and stroke Path";
            }
            case 9: {
                return "close, EO fill and stroke Path";
            }
            case 0: {
                return "end Path";
            }
        }
        return "Path";
    }
}

